/*
 * Decompiled with CFR 0.152.
 */
package de.plans.fmca.client;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FMCAPlugin
extends AbstractUIPlugin {
    private static final ILogger logger = Logger.getLogger(FMCAPlugin.class);
    private static FMCAPlugin plugin;

    public FMCAPlugin() {
        plugin = this;
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        String iconPath = "icons/";
        URL installURL = FMCAPlugin.getDefault().getBundle().getEntry("/");
        try {
            URL url = new URL(installURL, String.valueOf(iconPath) + fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            logger.error("Invalid image URL: " + installURL.toExternalForm() + " -> " + iconPath + fileName, (Throwable)e);
            return null;
        }
    }

    public static FMCAPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getCockpitImage() {
        return FMCAPlugin.getImageDescriptor("ArcWayLogo_16x16.gif");
    }

    public static File getWorkspaceRootDirectory() {
        IPath path = FMCAPlugin.getDefault().getStateLocation();
        File rootDirectory = path.toFile();
        if (!rootDirectory.exists()) {
            rootDirectory.mkdirs();
        }
        return rootDirectory;
    }
}

