/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.pakager;

import com.arcway.cockpit.errorreporting.pakager.FileNameTranslator;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final ILogger logger = Logger.getLogger(Zip.class);
    private static final String ZIP_SEPARATOR = "/";

    public static void createZipFile(File sourceDirectory, File destinationFile, FileNameTranslator translator) throws IOException, JvmExternalResourceInteractionException {
        ZipOutputStream zos = Zip.createZipOutputStream(destinationFile);
        try {
            Zip.createZipEntries(sourceDirectory, sourceDirectory, zos, translator);
            zos.flush();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                logger.warn("Zip Output stream could not be closed successfully. ZipFile: " + destinationFile.getPath(), (Throwable)e);
            }
        }
    }

    private static ZipOutputStream createZipOutputStream(File destination) throws IOException {
        if (destination.exists()) {
            throw new IOException("Destination File already exists.");
        }
        if (!destination.getParentFile().exists()) {
            throw new FileNotFoundException("Cannot find the path specified.");
        }
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        return zos;
    }

    private static void createZipEntries(File file, File root, ZipOutputStream zos, FileNameTranslator translator) throws IOException, JvmExternalResourceInteractionException {
        if (!file.exists()) {
            throw new IOException("Error while opening zip file: cannot find file " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            File[] content;
            File[] fileArray = content = file.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                Zip.createZipEntries(element, root, zos, translator);
                ++n2;
            }
        } else {
            Zip.createZipEntry(file, root, zos, translator);
        }
    }

    private static void createZipEntry(File source, File root, ZipOutputStream zos, FileNameTranslator translator) throws IOException, JvmExternalResourceInteractionException {
        if (!source.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IOException("File to compress is not in directory to compress.");
        }
        int translatedRootPathSize = translator.getTranslatedPath(root).size();
        List<String> translatedSourcePath = translator.getTranslatedPath(source);
        StringBuilder relativePath = new StringBuilder();
        int i = translatedRootPathSize;
        while (i < translatedSourcePath.size()) {
            if (i != translatedRootPathSize) {
                relativePath.append(ZIP_SEPARATOR);
            }
            relativePath.append(translatedSourcePath.get(i));
            ++i;
        }
        Zip.writeZipEntry(source, relativePath.toString(), zos);
    }

    public static void writeZipEntry(File source, String name, ZipOutputStream zos) throws IOException, JvmExternalResourceInteractionException {
        ZipEntry e = new ZipEntry(name);
        zos.putNextEntry(e);
        DataCopyHelper.copyFile((File)source, (OutputStream)zos, (boolean)false);
    }
}

