/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.pakager;

import com.arcway.cockpit.errorreporting.data.CockpitVariantDetector;
import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.cockpit.errorreporting.gui.ErrorBriefDescriptionAndCustomerContactData;
import com.arcway.cockpit.errorreporting.pakager.FileNameTranslator;
import com.arcway.cockpit.errorreporting.pakager.IndexGenerator;
import com.arcway.cockpit.errorreporting.pakager.Zip;
import com.arcway.cockpit.errorreporting.pakager.html.HtmlProvider;
import com.arcway.cockpit.errorreporting.pakager.img.IconProvider;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.fmca.client.PSCServices;
import de.plans.psc.client.PSCApplicationIdentifier;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;

public class Pakager {
    private static final ILogger LOGGER = Logger.getLogger(Pakager.class);
    private static final String sessionTempSubDirPrefix = "err_rpt";

    public File createErrorReportPackage(File p_targetDirectory, Collection<IDataFetcher> dataFetchers, ErrorBriefDescriptionAndCustomerContactData errorBriefDescriptionAndCustomerContactDataWizardPage) throws JvmExternalResourceInteractionException, IOException {
        SessionTempDirectoryManager.SessionTempDirectory sessionTempSubDir = null;
        try {
            sessionTempSubDir = SessionTempDirectoryManager.createSessionTempSubDirectory((String)sessionTempSubDirPrefix);
            for (IDataFetcher dataFetcher : dataFetchers) {
                dataFetcher.fetchData((File)sessionTempSubDir);
            }
            FileNameTranslator translator = new FileNameTranslator();
            try {
                IndexGenerator.generateJavaScriptAndHtml((File)sessionTempSubDir, translator, errorBriefDescriptionAndCustomerContactDataWizardPage);
            }
            catch (IOException e) {
                LOGGER.error("Unable to generate dtree.js and/or tree.html on " + sessionTempSubDir, (Throwable)e);
                throw new Error(e);
            }
            File sessionTempHtmlSubDir = new File((File)sessionTempSubDir, "html");
            File oldDataTreeJavaScript = new File((File)sessionTempSubDir, "dtree.js");
            File oldDataTreeHTML = new File((File)sessionTempSubDir, "tree.html");
            File oldoverviewHTML = new File((File)sessionTempSubDir, "overview.html");
            File dataTreeJavaScript = new File(sessionTempHtmlSubDir, "dtree.js");
            File dataTreeHTML = new File(sessionTempHtmlSubDir, "tree.html");
            File overviewHTML = new File(sessionTempHtmlSubDir, "overview.html");
            FileHelper.ensureDirectoryExistance((File)sessionTempHtmlSubDir);
            FileHelper.moveFile((File)oldDataTreeJavaScript, (File)dataTreeJavaScript);
            FileHelper.moveFile((File)oldDataTreeHTML, (File)dataTreeHTML);
            FileHelper.moveFile((File)oldoverviewHTML, (File)overviewHTML);
            HtmlProvider.copyHtmlFiles((File)sessionTempSubDir);
            IconProvider.copyIndexIcons((File)sessionTempSubDir);
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append("AC_DiagnoseInformation");
            try {
                fileNameBuilder.append("_");
                SimpleDateFormat creationDateFormat = new SimpleDateFormat();
                creationDateFormat.applyPattern("ddMMyy_HH-mm-SSS");
                fileNameBuilder.append(creationDateFormat.format(Calendar.getInstance().getTime()));
                fileNameBuilder.append("_");
                String cockpitVariant = CockpitVariantDetector.detectCockpitVariant();
                fileNameBuilder.append(CockpitVariantDetector.convertDetectedCockpitVariant2ShortString(cockpitVariant));
                fileNameBuilder.append("_");
                PSCApplicationIdentifier applicationIdentifier = PSCServices.getServiceFacade().getApplicationIdentifier();
                fileNameBuilder.append(applicationIdentifier.getClientVersion().replace(".", "-"));
                fileNameBuilder.append("-");
                fileNameBuilder.append(applicationIdentifier.getClientBuild());
            }
            catch (Throwable th) {
                LOGGER.error("unhandled catch block", th);
            }
            fileNameBuilder.append(".zip");
            String portableFileName = FileHelper.convertStringToPortableFileName((String)fileNameBuilder.toString());
            assert (portableFileName.equals(fileNameBuilder.toString()));
            File destinationZipFile = new File(p_targetDirectory, portableFileName);
            Zip.createZipFile((File)sessionTempSubDir, destinationZipFile, translator);
            File file = destinationZipFile;
            return file;
        }
        finally {
            if (sessionTempSubDir != null) {
                FileHelper.deleteFileOrDirectory((File)sessionTempSubDir);
            }
        }
    }
}

