/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.pakager;

import com.arcway.cockpit.errorreporting.gui.ErrorBriefDescriptionAndCustomerContactData;
import com.arcway.cockpit.errorreporting.gui.Messages;
import com.arcway.cockpit.errorreporting.pakager.FileNameTranslator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class IndexGenerator {
    private static final ILogger LOGGER = Logger.getLogger(IndexGenerator.class);
    private static final String CRLF = "\r\n";
    private static final String ENCODING_UTF_8 = "UTF-8";

    public static void generateJavaScriptAndHtml(File sessionTempSubDir, FileNameTranslator translator, ErrorBriefDescriptionAndCustomerContactData errorBriefDescriptionAndCustomerContactData) throws IOException {
        int parentUID = 0;
        File dataTreeJavaScript = new File(sessionTempSubDir, "dtree.js");
        File dataTreeHTML = new File(sessionTempSubDir, "tree.html");
        File overviewHTML = new File(sessionTempSubDir, "overview.html");
        try {
            BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataTreeJavaScript)));
            fout.write("function Node(id, pid, name, url, title, target, icon, iconOpen, open) {\r\n   this.id = id;\r\n   this.pid = pid;\r\n   this.name = name;\r\n   this.url = url;\r\n   this.title = title;\r\n   this.target = target;\r\n   this.icon = icon;\r\n   this.iconOpen = iconOpen;\r\n   this._io = open || false;\r\n   this._is = false;\r\n   this._ls = false;\r\n   this._hc = false;\r\n   this._ai = 0;\r\n   this._p;\r\n};\r\n\r\nfunction dTree(objName) {\r\n   this.config = {\r\n      target: null,\r\n      folderLinks: true,\r\n      useSelection: true,\r\n      useCookies: true,\r\n      useLines: true,\r\n      useIcons: true,\r\n      useStatusText: false,\r\n      closeSameLevel: false,\r\n      inOrder: false\r\n   };\r\n   this.icon = {\r\n      root: 'img/base.gif',\r\n      folder: 'img/folder.gif',\r\n      folderOpen: 'img/folderopen.gif',\r\n      node: 'img/page.gif',\r\n      empty: 'img/empty.gif',\r\n      line: 'img/line.gif',\r\n      join: 'img/join.gif',\r\n      joinBottom: 'img/joinbottom.gif',\r\n      plus: 'img/plus.gif',\r\n      plusBottom: 'img/plusbottom.gif',\r\n      minus: 'img/minus.gif',\r\n      minusBottom: 'img/minusbottom.gif',\r\n      nlPlus: 'img/nolines_plus.gif',\r\n      nlMinus: 'img/nolines_minus.gif'\r\n   };\r\n   this.obj = objName;\r\n   this.aNodes = [];\r\n   this.aIndent = [];\r\n   this.root = new Node(-1);\r\n   this.selectedNode = null;\r\n   this.selectedFound = false;\r\n   this.completed = false;\r\n};\r\n\r\ndTree.prototype.add = function(id, pid, name, url, title, target, icon, iconOpen, open) {\r\n   this.aNodes[this.aNodes.length] = new Node(id, pid, name, url, title, target, icon, iconOpen, open);\r\n};\r\n\r\ndTree.prototype.openAll = function() {\r\n   this.oAll(true);\r\n};\r\n\r\ndTree.prototype.closeAll = function() {\r\n   this.oAll(false);\r\n};\r\n\r\ndTree.prototype.toString = function() {\r\n   var str = '<div class=\"dtree\">\\n';\r\n   if (document.getElementById) {\r\n      if (this.config.useCookies) \r\n         this.selectedNode = this.getSelected();\r\n      str += this.addNode(this.root);\r\n   } else str += 'Browser not supported.';\r\n   str += '</div>';\r\n   if (!this.selectedFound)\r\n      this.selectedNode = null;\r\n   this.completed = true;\r\n   return str;\r\n};\r\n\r\ndTree.prototype.addNode = function(pNode) {\r\n   var str = '';\r\n   var n=0;\r\n   if (this.config.inOrder) \r\n      n = pNode._ai;\r\n   for (n; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n].pid == pNode.id) {\r\n         var cn = this.aNodes[n];\r\n         cn._p = pNode;\r\n         cn._ai = n;\r\n         this.setCS(cn);\r\n         if (!cn.target && this.config.target)\r\n            cn.target = this.config.target;\r\n         if (cn._hc && !cn._io && this.config.useCookies)\r\n            cn._io = this.isOpen(cn.id);\r\n         if (!this.config.folderLinks && cn._hc)\r\n            cn.url = null;\r\n         if (this.config.useSelection && cn.id == this.selectedNode && !this.selectedFound) {\r\n            cn._is = true;\r\n            this.selectedNode = n;\r\n            this.selectedFound = true;\r\n         }\r\n         str += this.node(cn, n);\r\n         if (cn._ls)\r\n            break;\r\n      }\r\n   }\r\n   return str;\r\n};\r\n\r\ndTree.prototype.node = function(node, nodeId) {\r\n   var str = '<div class=\"dTreeNode\">' + this.indent(node, nodeId);\r\n   if (this.config.useIcons) {\r\n      if (!node.icon)\r\n         node.icon = (this.root.id == node.pid) ? this.icon.root : ((node._hc) ? this.icon.folder : this.icon.node);\r\n      if (!node.iconOpen)\r\n         node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;\r\n      if (this.root.id == node.pid) {\r\n         node.icon = this.icon.root;\r\n         node.iconOpen = this.icon.root;\r\n      }\r\n      str += '<img id=\"i' + this.obj + nodeId + '\" src=\"' + ((node._io) ? node.iconOpen : node.icon) + '\" alt=\"\" />';\r\n   }\r\n   if (node.url) {\r\n      str += '<a id=\"s' + this.obj + nodeId + '\" class=\"' + ((this.config.useSelection) ? ((node._is ? 'nodeSel' : 'node')) : 'node') + '\" href=\"' + node.url + '\"';\r\n      if (node.title)\r\n         str += ' title=\"' + node.title + '\"';\r\n      if (node.target)\r\n         str += ' target=\"' + node.target + '\"';\r\n      if (this.config.useStatusText)\r\n         str += ' onmouseover=\"window.status=\\'' + node.name + '\\';return true;\" onmouseout=\"window.status=\\'\\';return true;\" ';\r\n      if (this.config.useSelection && ((node._hc && this.config.folderLinks) || !node._hc))\r\n         str += ' onclick=\"javascript: ' + this.obj + '.s(' + nodeId + ');\"';\r\n      str += '>';\r\n   }\r\n   else if ((!this.config.folderLinks || !node.url) && node._hc && node.pid != this.root.id)\r\n      str += '<a href=\"javascript: ' + this.obj + '.o(' + nodeId + ');\" class=\"node\">';\r\n   str += node.name;\r\n   if (node.url || ((!this.config.folderLinks || !node.url) && node._hc)) \r\n      str += '</a>';\r\n   str += '</div>';\r\n   if (node._hc) {\r\n      str += '<div id=\"d' + this.obj + nodeId + '\" class=\"clip\" style=\"display:' + ((this.root.id == node.pid || node._io) ? 'block' : 'none') + ';\">';\r\n      str += this.addNode(node);\r\n      str += '</div>';\r\n   }\r\n   this.aIndent.pop();\r\n   return str;\r\n};\r\n\r\ndTree.prototype.indent = function(node, nodeId) {\r\n   var str = '';\r\n   if (this.root.id != node.pid) {\r\n      for (var n=0; n<this.aIndent.length; n++)\r\n         str += '<img src=\"' + ( (this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line : this.icon.empty ) + '\" alt=\"\" />';\r\n      (node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);\r\n      if (node._hc) {\r\n         str += '<a href=\"javascript: ' + this.obj + '.o(' + nodeId + ');\"><img id=\"j' + this.obj + nodeId + '\" src=\"';\r\n         if (!this.config.useLines)\r\n            str += (node._io) ? this.icon.nlMinus : this.icon.nlPlus;\r\n         else\r\n            str += ( (node._io) ? ((node._ls && this.config.useLines) ? this.icon.minusBottom : this.icon.minus) : ((node._ls && this.config.useLines) ? this.icon.plusBottom : this.icon.plus ) );\r\n         str += '\" alt=\"\" /></a>';\r\n      } else\r\n         str += '<img src=\"' + ( (this.config.useLines) ? ((node._ls) ? this.icon.joinBottom : this.icon.join ) : this.icon.empty) + '\" alt=\"\" />';\r\n   }\r\n   return str;\r\n};\r\n\r\n\r\ndTree.prototype.setCS = function(node) {\r\n   var lastId;\r\n   for (var n=0; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n].pid == node.id) node._hc = true;\r\n      if (this.aNodes[n].pid == node.pid) lastId = this.aNodes[n].id;\r\n   }\r\n   if (lastId==node.id) \r\n      node._ls = true;\r\n};\r\n\r\ndTree.prototype.getSelected = function() {\r\n   var sn = this.getCookie('cs' + this.obj);\r\n   return (sn) ? sn : null;\r\n};\r\n\r\ndTree.prototype.s = function(id) {\r\n   if (!this.config.useSelection)\r\n      return;\r\n   var cn = this.aNodes[id];\r\n   if (cn._hc && !this.config.folderLinks) \r\n      return;\r\n   if (this.selectedNode != id) {\r\n      if (this.selectedNode || this.selectedNode==0) {\r\n         eOld = document.getElementById(\"s\" + this.obj + this.selectedNode);\r\n         eOld.className = \"node\";\r\n      }\r\n      eNew = document.getElementById(\"s\" + this.obj + id);\r\n      eNew.className = \"nodeSel\";\r\n      this.selectedNode = id;\r\n      if (this.config.useCookies)\r\n         this.setCookie('cs' + this.obj, cn.id);\r\n   }\r\n};\r\n\r\ndTree.prototype.o = function(id) {\r\n   var cn = this.aNodes[id];\r\n   this.nodeStatus(!cn._io, id, cn._ls);\r\n   cn._io = !cn._io;\r\n   if (this.config.closeSameLevel) \r\n      this.closeLevel(cn);\r\n   if (this.config.useCookies) \r\n      this.updateCookie();\r\n};\r\n\r\ndTree.prototype.oAll = function(status) {\r\n   for (var n=0; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n]._hc && this.aNodes[n].pid != this.root.id) {\r\n         this.nodeStatus(status, n, this.aNodes[n]._ls)\r\n         this.aNodes[n]._io = status;\r\n      }\r\n   }\r\n   if (this.config.useCookies) \r\n      this.updateCookie();\r\n};\r\n\r\ndTree.prototype.openTo = function(nId, bSelect, bFirst) {\r\n   if (!bFirst) {\r\n      for (var n=0; n<this.aNodes.length; n++) {\r\n         if (this.aNodes[n].id == nId) {\r\n            nId=n;\r\n            break;\r\n         }\r\n      }\r\n   }\r\n   var cn=this.aNodes[nId];\r\n   if (cn.pid==this.root.id || !cn._p) \r\n      return;\r\n   cn._io = true;\r\n   cn._is = bSelect;\r\n   if (this.completed && cn._hc) \r\n      this.nodeStatus(true, cn._ai, cn._ls);\r\n   if (this.completed && bSelect) \r\n      this.s(cn._ai);\r\n   else if (bSelect) \r\n      this._sn=cn._ai;\r\n   this.openTo(cn._p._ai, false, true);\r\n};\r\n\r\ndTree.prototype.closeLevel = function(node) {\r\n   for (var n=0; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id && this.aNodes[n]._hc) {\r\n         this.nodeStatus(false, n, this.aNodes[n]._ls);\r\n         this.aNodes[n]._io = false;\r\n         this.closeAllChildren(this.aNodes[n]);\r\n      }\r\n   }\r\n};\r\n\r\ndTree.prototype.closeAllChildren = function(node) {\r\n   for (var n=0; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) {\r\n         if (this.aNodes[n]._io) this.nodeStatus(false, n, this.aNodes[n]._ls);\r\n         this.aNodes[n]._io = false;\r\n         this.closeAllChildren(this.aNodes[n]);\r\n      }\r\n   }\r\n};\r\n\r\ndTree.prototype.nodeStatus = function(status, id, bottom) {\r\n   eDiv\t= document.getElementById('d' + this.obj + id);\r\n   eJoin = document.getElementById('j' + this.obj + id);\r\n   if (this.config.useIcons) {\r\n      eIcon = document.getElementById('i' + this.obj + id);\r\n      eIcon.src = (status) ? this.aNodes[id].iconOpen : this.aNodes[id].icon;\r\n   }\r\n   eJoin.src = (this.config.useLines)?((status)?((bottom)?this.icon.minusBottom:this.icon.minus):((bottom)?this.icon.plusBottom:this.icon.plus)):\r\n   ((status)?this.icon.nlMinus:this.icon.nlPlus);\r\n   eDiv.style.display = (status) ? 'block': 'none';\r\n};\r\n\r\ndTree.prototype.clearCookie = function() {\r\n   var now = new Date();\r\n   var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);\r\n   this.setCookie('co'+this.obj, 'cookieValue', yesterday);\r\n   this.setCookie('cs'+this.obj, 'cookieValue', yesterday);\r\n};\r\n\r\ndTree.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {\r\n   document.cookie =    escape(cookieName) + '=' + escape(cookieValue)\r\n                     + (expires ? '; expires=' + expires.toGMTString() : '')\r\n                     + (path ? '; path=' + path : '')\r\n                     + (domain ? '; domain=' + domain : '')\r\n                     + (secure ? '; secure' : '');\r\n};\r\n\r\ndTree.prototype.getCookie = function(cookieName) {\r\n   var cookieValue = '';\r\n   var posName = document.cookie.indexOf(escape(cookieName) + '=');\r\n   if (posName != -1) {\r\n      var posValue = posName + (escape(cookieName) + '=').length;\r\n      var endPos = document.cookie.indexOf(';', posValue);\r\n      if (endPos != -1) \r\n         cookieValue = unescape(document.cookie.substring(posValue, endPos));\r\n      else \r\n         cookieValue = unescape(document.cookie.substring(posValue));\r\n   }\r\n   return (cookieValue);\r\n};\r\n\r\ndTree.prototype.updateCookie = function() {\r\n   var str = '';\r\n   for (var n=0; n<this.aNodes.length; n++) {\r\n      if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {\r\n         if (str) str += '.';\r\n            str += this.aNodes[n].id;\r\n      }\r\n   }\r\n   this.setCookie('co' + this.obj, str);\r\n};\r\n\r\ndTree.prototype.isOpen = function(id) {\r\n   var aOpen = this.getCookie('co' + this.obj).split('.');\r\n   for (var n=0; n<aOpen.length; n++)\r\n      if (aOpen[n] == id) \r\n         return true;\r\n      return false;\r\n};\r\n\r\nif (!Array.prototype.push) {\r\n   Array.prototype.push = function array_push() {\r\n      for(var i=0;i<arguments.length;i++)\r\n         this[this.length]=arguments[i];\r\n      return this.length;\r\n   }\r\n};\r\n\r\nif (!Array.prototype.pop) {\r\n   Array.prototype.pop = function array_pop() {\r\n      lastElement = this[this.length-1];\r\n      this.length = Math.max(this.length-1,0);\r\n      return lastElement;\r\n   }\r\n};\r\n");
            int rootUID = 0;
            fout.write("d = new dTree('d');\r\n");
            fout.write("d.add(0,-1,'Index','overview.html','','Data','');\r\n");
            int elementUID = 1;
            File[] fileArray = sessionTempSubDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File rootdirectory = fileArray[n2];
                if (rootdirectory.isDirectory()) {
                    String urlEncodedRootDirectoryname = IndexGenerator.javaScriptUrlEncode(rootdirectory.getName());
                    fout.write("d.add(" + elementUID + ",0,decodeURIComponent('" + urlEncodedRootDirectoryname + "'),'','','','img/folder.gif');\r\n");
                    rootUID = elementUID++;
                    File[] fileArray2 = rootdirectory.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File subdirectory = fileArray2[n4];
                        String urlEncodedSubDirectoryname = IndexGenerator.javaScriptUrlEncode(subdirectory.getName());
                        fout.write("   d.add(" + elementUID + "," + rootUID + ",decodeURIComponent('" + urlEncodedSubDirectoryname + "'),'','','','img/folder.gif');\r\n");
                        parentUID = elementUID++;
                        File[] fileArray3 = subdirectory.listFiles();
                        int n5 = fileArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            File file = fileArray3[n6];
                            if (file.isDirectory()) {
                                fout.write("      d.add(" + elementUID + "," + parentUID + ",'" + translator.getTranslatedName(file) + "','','','','img/folder.gif');\r\n");
                            } else {
                                String filename = translator.getTranslatedName(file);
                                String fileParentName = translator.getTranslatedName(file.getParentFile());
                                String fileRootParentName = translator.getTranslatedName(file.getParentFile().getParentFile());
                                String elementPath = "../" + fileRootParentName + "/" + fileParentName + "/" + filename;
                                String urlEncodedElementDisplayname = IndexGenerator.javaScriptUrlEncode(file.getName());
                                fout.write("      d.add(" + elementUID + "," + parentUID + ",decodeURIComponent('" + urlEncodedElementDisplayname + "'),'" + elementPath + "',decodeURIComponent('" + urlEncodedElementDisplayname + "'),'Data','img/page.gif');");
                            }
                            fout.write(CRLF);
                            ++elementUID;
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            fout.write(CRLF);
            fout.write("document.write(d);");
            fout.close();
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.applyPattern("EEEE, dd. MMMM yyyy HH:mm");
            Calendar cal = Calendar.getInstance();
            String reportDate = fmt.format(cal.getTime());
            fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataTreeHTML)));
            fout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n<html>\r\n   <head>\r\n      <title>Navigation</title>\r\n      <link rel=\"StyleSheet\" href=\"dtree.css\" type=\"text/css\" />\r\n   </head>\r\n   <body bgcolor=\"#F0F0F0\">\r\n      <table>\r\n         <tr>\r\n            <td>\r\n               <img src=\"img/arcwaylogo.gif\" alt=\"ARCWAY AG\">\r\n               <hr noshade width=\"100%\" size=\"3\">\r\n            </td>\r\n         </tr>\r\n         <tr>\r\n            <td>\r\n               <br><p style=\"font-family:Arial,sans-serif; font-size:12px; color:blue\">\r\n\t\t\t\t   " + reportDate + CRLF + "\t\t        </p>" + CRLF + "               <div class=\"dtree\">" + CRLF + "                  <p><a href=\"javascript: d.openAll();\">open all</a> | <a href=\"javascript: d.closeAll();\">close all</a></p>" + CRLF + "               </div>" + CRLF + "               <script type=\"text/javascript\" src=\"dtree.js\"></script>" + CRLF + "            </td>" + CRLF + "         </tr>" + CRLF + "      </table>" + CRLF + "   </body>" + CRLF + "</html>");
            fout.close();
            String errorBriefDescription = errorBriefDescriptionAndCustomerContactData.getErrorBriefDescription();
            String contactData = errorBriefDescriptionAndCustomerContactData.getContactData();
            String severity = errorBriefDescriptionAndCustomerContactData.getSeverity();
            fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(overviewHTML)));
            fout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n<html>\r\n   <head>\r\n      <title>Overview</title>\r\n   </head>\r\n   <body>\r\n\t   <h2>\r\n\t      <pre>\r\n" + severity + CRLF + "\t      </pre>" + CRLF + "      </h2>" + CRLF + "\t   <h3>" + CRLF + Messages.getString("ErrorReportingWizard.ContactDataForHtml") + "\t   </h3>" + CRLF + "\t      <pre>" + CRLF + contactData + CRLF + "\t      </pre>" + CRLF + "\t   <h3>" + CRLF + Messages.getString("ErrorReportingWizard.ErrorBriefDescriptionForHtml") + "\t   </h3>" + CRLF + "\t      <pre>" + CRLF + errorBriefDescription + CRLF + "\t      </pre>" + CRLF + "\t   <br>" + "   </body>" + CRLF + "</html>");
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to create: " + dataTreeJavaScript + "/" + dataTreeHTML, (Throwable)e);
            throw new Error(e);
        }
    }

    private static String javaScriptUrlEncode(String s) {
        String result = s;
        try {
            String intermediateResult = URLEncoder.encode(s, ENCODING_UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            int i = 0;
            while (i < intermediateResult.length()) {
                char c = intermediateResult.charAt(i);
                if (c == '+') {
                    resultBuilder.append("%20");
                } else {
                    resultBuilder.append(c);
                }
                ++i;
            }
            result = resultBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

