/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.pakager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileNameTranslator {
    final String AllowedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.-";
    final char ReplacementChar = (char)95;
    Map<List<String>, List<String>> dictionary = new HashMap<List<String>, List<String>>();

    public List<String> getTranslatedPath(File file) {
        ArrayList<String> key = new ArrayList<String>();
        File f = file;
        while (f != null) {
            key.add(0, f.getName());
            f = f.getParentFile();
        }
        List<String> translatedPath = this.dictionary.get(key);
        if (translatedPath == null) {
            String resultElement;
            File parentFile = file.getParentFile();
            ArrayList<Object> translatedParentPathElements = parentFile != null ? new ArrayList<String>(this.getTranslatedPath(parentFile)) : new ArrayList();
            String resultPrefix = this.encodeFileNamePart(file.getName());
            int count = -1;
            while (true) {
                resultElement = count == -1 ? resultPrefix : String.valueOf(resultPrefix) + count;
                ArrayList<String> translationCandidate = new ArrayList<String>(translatedParentPathElements);
                translationCandidate.add(resultElement);
                if (!this.dictionary.containsValue(translationCandidate)) break;
                ++count;
            }
            translatedPath = new ArrayList<String>(translatedParentPathElements);
            translatedPath.add(resultElement);
            this.dictionary.put(key, translatedPath);
        }
        return translatedPath;
    }

    public String getTranslatedName(File file) {
        String resultElement;
        List<String> translatedPath = this.getTranslatedPath(file);
        if (translatedPath.isEmpty()) {
            assert (false);
            resultElement = "_empty_";
        } else {
            resultElement = translatedPath.get(translatedPath.size() - 1);
        }
        return resultElement;
    }

    private String encodeFileNamePart(String name) {
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.-".indexOf(chars[i]) == -1) {
                chars[i] = 95;
            }
            ++i;
        }
        return new String(chars);
    }
}

