/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.gui;

import com.arcway.cockpit.errorreporting.gui.ErrorReportingHtmlFileWizardPage;
import com.arcway.cockpit.errorreporting.gui.ErrorReportingWizard;
import com.arcway.cockpit.errorreporting.gui.Messages;
import com.arcway.cockpit.errorreporting.pakager.TargetDirectoryParameterChooser;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FileAttachmentsWizardPage
extends WizardPage {
    private final ErrorReportingWizard errorReportingWizard;
    private Composite rootComposite;

    public FileAttachmentsWizardPage(String pageName, ErrorReportingWizard p_errorReportingWizard) {
        super(pageName);
        this.setTitle(Messages.getString("FileAttachmentsWizardPage.title"));
        this.setMessage(Messages.getString("FileAttachmentsWizardPage.message"));
        this.errorReportingWizard = p_errorReportingWizard;
    }

    public void createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 2048);
        this.rootComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)this.rootComposite);
        Control browserControl = ErrorReportingHtmlFileWizardPage.createBrowserControl(this.rootComposite, ((Object)((Object)this)).getClass(), Messages.getString("FileAttachmentsWizardPage.DiagnoseInformationPackage.htmlfile"));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(browserControl);
        Button createDiagnoseInformationPackage = new Button(this.rootComposite, 8);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)createDiagnoseInformationPackage);
        createDiagnoseInformationPackage.setText(Messages.getString("FileAttachmentsWizardPage.CreateDiagnoseInformationPackage"));
        createDiagnoseInformationPackage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File targetDirectoryName = TargetDirectoryParameterChooser.selectTargetDirectoryName(FileAttachmentsWizardPage.this.getShell());
                if (targetDirectoryName != null) {
                    File file = FileAttachmentsWizardPage.this.errorReportingWizard.createDiagnoseInformationPackage(targetDirectoryName);
                    MessageDialog.openInformation((Shell)FileAttachmentsWizardPage.this.getShell(), (String)Messages.getString("FileAttachmentsWizardPage.CreatedDiagnoseInformationPackage.Title"), (String)NLS.bind((String)Messages.getString("FileAttachmentsWizardPage.CreatedDiagnoseInformationPackage.Message"), (Object)file.getParent(), (Object)file.getName()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.rootComposite);
    }
}

