/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.gui;

import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.io.TextFileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.InputStream;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ErrorReportingHtmlFileWizardPage
extends WizardPage {
    private static final ILogger LOGGER = Logger.getLogger(ErrorReportingHtmlFileWizardPage.class);
    private final String htmlFileName;

    public ErrorReportingHtmlFileWizardPage(String pageName, String title, String message, String htmlFileName) {
        super(pageName);
        this.htmlFileName = htmlFileName;
        this.setTitle(title);
        this.setMessage(message);
    }

    public void createControl(Composite parent) {
        Class<?> classFromPackageContainingHtmlResourceFiles = ((Object)((Object)this)).getClass();
        Control browserControl = ErrorReportingHtmlFileWizardPage.createBrowserControl(parent, classFromPackageContainingHtmlResourceFiles, this.htmlFileName);
        this.setControl(browserControl);
    }

    public static Control createBrowserControl(Composite parent, Class<?> classFromPackageContainingHtmlResourceFiles, String htmlFileName) {
        String htmlFileEncoding = "iso-8859-1";
        Composite browserComposite = new Composite(parent, 2048);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(browserComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)browserComposite);
        IBrowser hintBrowser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)browserComposite, (int)0);
        String htmlString = "<html><body>Unable to fetch html resource file. Please send error reports to <a href=\"mailto:support@arcway.com\">support@arcway.com</a></body><html>";
        try {
            InputStream htmlStream = classFromPackageContainingHtmlResourceFiles.getResourceAsStream(htmlFileName);
            htmlString = TextFileHelper.getStreamContentAsString((InputStream)htmlStream, (String)"iso-8859-1");
            assert (htmlString.indexOf("charset=iso-8859-1") != -1);
        }
        catch (Exception e) {
            LOGGER.error("unable to fetch html resource file " + classFromPackageContainingHtmlResourceFiles.getPackage().getName() + htmlFileName, (Throwable)e);
        }
        hintBrowser.setHtml(htmlString);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(hintBrowser.getSWTControl());
        return browserComposite;
    }
}

