/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.gui;

import com.arcway.cockpit.errorreporting.data.AdditionalFileFetcher;
import com.arcway.cockpit.errorreporting.gui.Messages;
import com.arcway.cockpit.errorreporting.pakager.SourceFileParameterChooser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class AdditionalFilesWizardPage
extends WizardPage {
    private static final ILogger LOGGER = Logger.getLogger(AdditionalFilesWizardPage.class);
    private final AdditionalFileFetcher additionalFileFetcher;
    private Composite rootComposite;
    private List listAddedFiles;
    private int indexOfSelectedFile;

    public AdditionalFilesWizardPage(String pageName, AdditionalFileFetcher p_additionalFileFetcher) {
        super(pageName);
        this.additionalFileFetcher = p_additionalFileFetcher;
    }

    private void informAdditionalFileFetcher() {
        ArrayList<File> additionalFiles = new ArrayList<File>();
        String[] stringArray = this.listAddedFiles.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            additionalFiles.add(new File(filename));
            ++n2;
        }
        this.additionalFileFetcher.setFileList(Collections.unmodifiableCollection(additionalFiles));
    }

    public void createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 2048);
        this.rootComposite.setLayout((Layout)new GridLayout());
        this.listAddedFiles = new List(this.rootComposite, 2818);
        Button chooseFileButton = new Button(this.rootComposite, 8);
        Button removeFileEntryButton = new Button(this.rootComposite, 8);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        this.listAddedFiles.setLayoutData((Object)data);
        chooseFileButton.setText(Messages.getString("ErrorReportingWizard.AddNewFile"));
        removeFileEntryButton.setText(Messages.getString("ErrorReportingWizard.RemoveFile"));
        chooseFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File selectedFile = SourceFileParameterChooser.selectFile(AdditionalFilesWizardPage.this.getShell());
                if (selectedFile != null) {
                    AdditionalFilesWizardPage.this.listAddedFiles.add(selectedFile.getAbsolutePath());
                    AdditionalFilesWizardPage.this.informAdditionalFileFetcher();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        removeFileEntryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalFilesWizardPage.this.indexOfSelectedFile = -1;
                AdditionalFilesWizardPage.this.indexOfSelectedFile = AdditionalFilesWizardPage.this.listAddedFiles.getSelectionIndex();
                LOGGER.debug("index of selected element [swt.widgets.List]: " + AdditionalFilesWizardPage.this.indexOfSelectedFile);
                if (AdditionalFilesWizardPage.this.indexOfSelectedFile >= 0) {
                    AdditionalFilesWizardPage.this.listAddedFiles.remove(AdditionalFilesWizardPage.this.indexOfSelectedFile);
                    AdditionalFilesWizardPage.this.informAdditionalFileFetcher();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.rootComposite);
    }
}

