/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.data;

import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.PSCClientLogMgr;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.io.File;

public class CockpitLogFetcher
implements IDataFetcher {
    private static final ILogger LOGGER = Logger.getLogger(CockpitLogFetcher.class);

    @Override
    public void fetchData(File sessionTempSubDir) {
        XMLConfigParameterMgr parameterMgr = EclipsePlugin.getDefault().getClientServiceFacade().getParameterManager();
        PSCClientLogMgr.LoggingParameterSet loggingParameterSet = (PSCClientLogMgr.LoggingParameterSet)parameterMgr.getSubtree(PSCClientLogMgr.LoggingParameterSet.XML_NAME);
        File destinationParentLogDir = new File(sessionTempSubDir, "Logfiles");
        File destinationCockpitLogDir = new File(destinationParentLogDir, "CockpitLog");
        File logFile = new File(loggingParameterSet.getLogFilePath());
        File logFileDir = logFile.getParentFile();
        if (!destinationParentLogDir.exists()) {
            destinationParentLogDir.mkdir();
        }
        destinationCockpitLogDir.mkdir();
        File[] fileArray = logFileDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(logFile.getName())) {
                try {
                    File targetFile = new File(destinationCockpitLogDir, file.getName());
                    DataCopyHelper.copyFile((File)file, (File)targetFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    LOGGER.error("Unable to copy Cockpit-logfile(s) to temporary directory.", (Throwable)e);
                    throw new Error(e);
                }
            }
            ++n2;
        }
    }
}

