/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.reporttypesandtemplates;

import com.arcway.cockpit.docgen.writer.IDocumentationWriter;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportTemplateTypes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IResultLauncher;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.Set;

public class VelocityReportType
implements IReportType {
    private final IDocumentationWriter documentationWriter;

    public VelocityReportType(IDocumentationWriter documentationWriter) {
        this.documentationWriter = documentationWriter;
    }

    public IClientFunctionLicenseType getNeededLicenseType() {
        return this.documentationWriter.getNeededLicenseType();
    }

    public String getID() {
        return this.documentationWriter.getID();
    }

    public String getDisplayName() {
        return this.documentationWriter.getDisplayName();
    }

    public String getDescription() {
        return this.documentationWriter.getDescription();
    }

    public Set<String> getApplicableReportTemplateTypes() {
        return this.documentationWriter.getApplicableReportTemplateTypes();
    }

    public boolean isApplicable(IReportTemplate reportTemplate) {
        File reportTemplateFile = reportTemplate.getReportFile();
        Set<String> reportTemplateOutputTypes = VelocityReportTemplateTypes.getReportTemplateOutputTypes(reportTemplateFile);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)reportTemplateFile);
        }
        catch (JvmExternalResourceInteractionException jvmExternalResourceInteractionException) {
            // empty catch block
        }
        return reportTemplateOutputTypes.isEmpty() || reportTemplateOutputTypes.contains(this.documentationWriter.getID());
    }

    public String getRequiredFormatPalette(IReportTemplate reportTemplate) {
        File reportTemplateFile = reportTemplate.getReportFile();
        String requiredFormatPalette = VelocityReportTemplateTypes.getReportTemplateRequiredFormatPalette(reportTemplateFile);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)reportTemplateFile);
        }
        catch (JvmExternalResourceInteractionException jvmExternalResourceInteractionException) {
            // empty catch block
        }
        if (requiredFormatPalette == null) {
            requiredFormatPalette = "";
        }
        if ((requiredFormatPalette = requiredFormatPalette.trim()).length() == 0) {
            requiredFormatPalette = null;
        }
        return requiredFormatPalette;
    }

    public Set<String> getFilterIDs(IReportTemplate reportTemplate) {
        File reportTemplateFile = reportTemplate.getReportFile();
        Set<String> filterIDs = VelocityReportTemplateTypes.getReportTemplateFilterIDs(reportTemplateFile);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)reportTemplateFile);
        }
        catch (JvmExternalResourceInteractionException jvmExternalResourceInteractionException) {
            // empty catch block
        }
        return filterIDs;
    }

    public String getRequiredOutputTemplateTypeID() {
        return this.documentationWriter.getRequiredOutputTemplateTypeID();
    }

    public String getOutputFormat(IReportTemplate reportTemplate) {
        return this.documentationWriter.getOutputFormat(reportTemplate);
    }

    public boolean hasDeterminedOutputFile() {
        return this.documentationWriter.hasDeterminedOutputFile();
    }

    public File determineOutputFile(ReportJob reportJob) {
        return this.documentationWriter.determineOutputFile(reportJob);
    }

    public IResultLauncher getResultLauncher() {
        return this.documentationWriter.getResultLauncher();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof IReportType) {
                IReportType reportType = (IReportType)obj;
                return this.getID().equals(reportType.getID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

