/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.reporttypesandtemplates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ReportTemplateHeaders {
    public static final String TEMPLATE_HEADER_TEMPLATE_ENCODING_KEY = "templateEncoding";
    public static final String TEMPLATE_HEADER_TARGET_ENCODING_KEY = "targetEncoding";
    public static final String TEMPLATE_HEADER_TARGET_TYPE_KEY = "targetType";
    public static final String TEMPLATE_HEADER_OUTPUT_TYPES_KEY = "outputTypes";
    public static final String TEMPLATE_HEADER_FILTER_IDS_KEY = "filterIDs";
    public static final String TEMPLATE_HEADER_REQUIRED_FORMAT_PALETTE_KEY = "requiredFormatPalette";
    public static final String TEMPLATE_HEADER_REAL_LOCAL_VARIABLES = "realLocalVariables";
    public static final String TEMPLATE_HEADER_VELOCIMACRO_MAX_DEPTH = "velocimacroMaxDepth";
    public static final String TEMPLATE_HEADER_DIRECTIVE_PARSE_MAX_DEPTH = "directiveParseMaxDepth";
    public static final String TEMPLATE_HEADER_CANCELABLE_KEY = "cancelable";

    public static Map<String, String> readASCIIHeader(File templateFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templateFile), "US-ASCII"));
            HashMap<String, String> headerMap = new HashMap<String, String>();
            while ((line = reader.readLine()) != null && line.startsWith("##")) {
                int endQuoteIndex;
                int equalsIndex = line.indexOf("=\"");
                if (equalsIndex < 2 || (endQuoteIndex = line.indexOf("\"", equalsIndex + 2)) < 0) continue;
                headerMap.put(line.substring(2, equalsIndex), line.substring(equalsIndex + 2, endQuoteIndex));
            }
            HashMap<String, String> hashMap = headerMap;
            return hashMap;
        }
    }

    public static final String getHeaderParameter(Map<String, String> headerMap, String key, String defaultValue) {
        String value = headerMap.get(key);
        return value != null ? value : defaultValue;
    }

    public static boolean isHeaderParameterTrue(Map<String, String> headerMap, String key) {
        return "true".equalsIgnoreCase(headerMap.get(key));
    }
}

