/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.nooutput;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.AbstractDocumentationWriter;
import com.arcway.cockpit.docgen.writer.nooutput.ClientFunctionLicenseTypeReportsNoOutput;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.geometry.Dimension;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class NoOutputDocumentationWriter
extends AbstractDocumentationWriter {
    private static final String REPORT_TYPE_ID = "NO_OUTPUT";
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";
    private static final double PREFERRED_IMAGE_RESOLUTION = 192.0;
    private static final int PREFERRED_IMAGE_SIZE = 2400;
    private static final Set<String> applicableReportTemplateTypes = Collections.singleton("velocity.nooutput");

    @Override
    public Set<String> getApplicableReportTemplateTypes() {
        return applicableReportTemplateTypes;
    }

    @Override
    public String getID() {
        return REPORT_TYPE_ID;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("NoOutputDocumentationWriter.Label");
    }

    @Override
    public String getDescription() {
        return Messages.getString("NoOutputDocumentationWriter.Description");
    }

    @Override
    public String getRequiredOutputTemplateTypeID() {
        return null;
    }

    @Override
    public String getOutputFormat(IReportTemplate reportTemplate) {
        return REPORT_TYPE_ID;
    }

    @Override
    public String getPreferredImageType() {
        return ".svg";
    }

    @Override
    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInPixel(new Dimension(2400.0, 2400.0), 192.0);
    }

    @Override
    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsNoOutput.getInstance();
    }

    @Override
    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        return FILES_AND_IMAGES_DIRECTORY_NAME + File.separator + fileName;
    }

    @Override
    public void postProcess(VelocityReportJob reportJob, IWorkbenchPage workbenchPage) throws ReportGenerationException {
    }
}

