/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOColSpec;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTBody;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTFoot;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTHead;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOTGroup
extends EOCommonObject {
    public static String XML_NAME = "tgroup";
    private static final String ATTR_TAG_ALIGN = "align";
    private static final String ATTR_TAG_CHAR = "char";
    private static final String ATTR_TAG_CHAROFF = "charoff";
    private static final String ATTR_TAG_COLS = "cols";
    private static final String ATTR_TAG_COLSEP = "colsep";
    private static final String ATTR_TAG_ROWSEP = "rowsep";
    private static final String ATTR_TAG_TGROUPSTYLE = "tgroupstyle";
    private String attrAlign = null;
    private String attrChar = null;
    private String attrCharoff = null;
    private Integer attrCols = null;
    private String attrColsep = null;
    private String attrRowsep = null;
    private String attrTGroupStyle = null;
    private final List colspecList = new ArrayList();
    private EOTHead thead = null;
    private EOTFoot tfoot = null;
    private EOTBody tbody = null;

    public EOTGroup() {
        super(XML_NAME);
    }

    public EOTGroup(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrCols != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLS, this.attrCols);
        }
        if (this.attrAlign != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ALIGN, this.attrAlign);
        }
        if (this.attrChar != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CHAR, this.attrChar);
        }
        if (this.attrCharoff != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CHAROFF, this.attrCharoff);
        }
        if (this.attrColsep != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLSEP, this.attrColsep);
        }
        if (this.attrRowsep != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ROWSEP, this.attrRowsep);
        }
        if (this.attrTGroupStyle != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TGROUPSTYLE, this.attrTGroupStyle);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean result = true;
        if (name.equals(ATTR_TAG_ALIGN)) {
            this.attrAlign = value;
        } else if (name.equals(ATTR_TAG_CHAR)) {
            this.attrChar = value;
        } else if (name.equals(ATTR_TAG_CHAROFF)) {
            this.attrCharoff = value;
        } else if (name.equals(ATTR_TAG_COLS)) {
            this.attrCols = Integer.valueOf(value);
        } else if (name.equals(ATTR_TAG_COLSEP)) {
            this.attrColsep = value;
        } else if (name.equals(ATTR_TAG_ROWSEP)) {
            this.attrRowsep = value;
        } else if (name.equals(ATTR_TAG_TGROUPSTYLE)) {
            this.attrTGroupStyle = value;
        } else {
            result = super.setAttributeFromXML(name, value);
        }
        return result;
    }

    @Override
    protected boolean hasChildren() {
        return this.colspecList.size() != 0 || this.thead != null || this.tfoot != null || this.tbody != null;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EOColSpec colspec : this.colspecList) {
            colspec.writeXMLBody(writeContext, depth);
        }
        if (this.thead != null) {
            this.thead.writeXMLBody(writeContext, depth);
        }
        if (this.tfoot != null) {
            this.tfoot.writeXMLBody(writeContext, depth);
        }
        if (this.tbody != null) {
            this.tbody.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean result = true;
        if (newChild instanceof EOColSpec) {
            this.colspecList.add(newChild);
        } else if (newChild instanceof EOTHead) {
            this.thead = (EOTHead)newChild;
        } else if (newChild instanceof EOTFoot) {
            this.tfoot = (EOTFoot)newChild;
        } else if (newChild instanceof EOTBody) {
            this.tbody = (EOTBody)newChild;
        } else {
            result = false;
        }
        return result;
    }

    public void setAlign(String string) {
        this.attrAlign = string;
    }

    public void setChar(String string) {
        this.attrChar = string;
    }

    public void setCharoff(String string) {
        this.attrCharoff = string;
    }

    public int getCols() {
        if (this.attrCols != null) {
            return this.attrCols;
        }
        return 0;
    }

    public void setCols(int columns) {
        this.attrCols = new Integer(columns);
    }

    public void setColsep(String string) {
        this.attrColsep = string;
    }

    public void setRowsep(String string) {
        this.attrRowsep = string;
    }

    public void setTGroupStyle(String string) {
        this.attrTGroupStyle = string;
    }

    public void add(EOTHead thead) {
        this.thead = thead;
    }

    public void add(EOTFoot tfoot) {
        this.tfoot = tfoot;
    }

    public void add(EOTBody tbody) {
        this.tbody = tbody;
    }

    public void add(EOColSpec colspec) {
        this.colspecList.add(colspec);
    }

    public EOTHead getTableHead() {
        return this.thead;
    }

    public EOTBody getTableBody() {
        return this.tbody;
    }

    public EOTFoot getTableFoot() {
        return this.tfoot;
    }

    public List getColspec() {
        return new ArrayList(this.colspecList);
    }
}

