/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOSubtitle
extends EOCommonObject {
    public static String XML_NAME = "subtitle";
    private static final String ATTR_TAG_PAGENUM = "pagenum";
    private String attrPagenum = null;
    private final ArrayList content = new ArrayList();

    public EOSubtitle() {
        super(XML_NAME);
    }

    public EOSubtitle(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrPagenum != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_PAGENUM, this.attrPagenum);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_PAGENUM)) {
            this.attrPagenum = value;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return this.content.size() >= 1;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (Object obj : this.content) {
            if (obj instanceof String) {
                String text = (String)obj;
                this.appendIndentToXML(writeContext, depth);
                this.appendContentToXML(writeContext, String.valueOf(text) + "\n");
                continue;
            }
            if (!(obj instanceof EOCommonObject)) continue;
            EOCommonObject eo = (EOCommonObject)((Object)obj);
            eo.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOCommonObject) {
            this.content.add(newChild);
        } else {
            success = false;
        }
        return success;
    }

    protected boolean addContentFromXML(String value) {
        String contentString;
        boolean success = false;
        if (value != null && (contentString = EOCommonObject.removeTabAndNewlineChars(value)).length() > 0) {
            this.content.add(contentString);
            success = true;
        }
        return success;
    }

    public void add(String text) {
        this.content.add(text);
    }

    public void add(EOAnchor anchor) {
        this.content.add(anchor);
    }

    public void add(EOLink link) {
        this.content.add(link);
    }

    public List<?> getContent(ReportJob reportJob) {
        return EOSubtitle.mergeContentIfNoMarkupsAllowed(this.content, reportJob);
    }

    public String getContentAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object contentElement : this.content) {
            if (!(contentElement instanceof String)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append((String)contentElement);
        }
        return stringBuffer.toString();
    }
}

