/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOSection
extends EOCommonObject {
    public static String XML_NAME = "section";
    private static final String ATTR_TAG_LABEL = "label";
    private static final String ATTR_TAG_STATUS = "status";
    private String attrLabel = null;
    private String attrStatus = null;
    private EOTitle title = null;
    private EOSubtitle subtitle = null;
    private final ArrayList nonSectionContent = new ArrayList();
    private final ArrayList sectionContent = new ArrayList();

    public EOSection() {
        super(XML_NAME);
    }

    public EOSection(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrLabel != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LABEL, this.attrLabel);
        }
        if (this.attrStatus != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_STATUS, this.attrStatus);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_LABEL)) {
            this.attrLabel = value;
        } else if (name.equals(ATTR_TAG_STATUS)) {
            this.attrStatus = value;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return this.title != null || this.nonSectionContent.size() >= 1 || this.sectionContent.size() >= 1;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        EOCommonObject eo;
        if (this.title != null) {
            this.title.writeXMLBody(writeContext, depth);
        }
        if (this.subtitle != null) {
            this.subtitle.writeXMLBody(writeContext, depth);
        }
        if (this.nonSectionContent.size() > 0) {
            for (Object obj : this.nonSectionContent) {
                if (!(obj instanceof EOCommonObject)) continue;
                eo = (EOCommonObject)((Object)obj);
                eo.writeXMLBody(writeContext, depth);
            }
        }
        if (this.sectionContent.size() > 0) {
            for (Object obj : this.sectionContent) {
                if (!(obj instanceof EOCommonObject)) continue;
                eo = (EOCommonObject)((Object)obj);
                eo.writeXMLBody(writeContext, depth);
            }
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOTitle) {
            this.title = (EOTitle)newChild;
        } else if (newChild instanceof EOSubtitle) {
            this.subtitle = (EOSubtitle)newChild;
        } else if (newChild instanceof EOSection) {
            this.sectionContent.add(newChild);
        } else if (newChild instanceof EOCommonObject) {
            this.nonSectionContent.add(newChild);
        } else {
            success = false;
        }
        return success;
    }

    public void setLabel(String string) {
        this.attrLabel = string;
    }

    public void setStatus(String string) {
        this.attrStatus = string;
    }

    public void add(EOAnchor anchor) {
        this.nonSectionContent.add(anchor);
    }

    public void add(EOPara para) {
        this.nonSectionContent.add(para);
    }

    public void add(EOSection section) {
        this.sectionContent.add(section);
    }

    public void add(EOTable table) {
        this.nonSectionContent.add(table);
    }

    public void add(EOTitle title) {
        this.title = title;
    }

    public void add(EOSimpleList list) {
        this.nonSectionContent.add(list);
    }

    public void add(EOSubtitle subtitle) {
        this.subtitle = subtitle;
    }

    public EOTitle getTitle() {
        return this.title;
    }

    public EOSubtitle getSubtitle() {
        return this.subtitle;
    }

    public void add(EOMediaObject mediaObject) {
        assert (mediaObject != null) : "EOMediaObject object is null";
        this.nonSectionContent.add(mediaObject);
    }

    public List getContent() {
        ArrayList result = new ArrayList();
        result.addAll(this.nonSectionContent);
        result.addAll(this.sectionContent);
        return result;
    }
}

