/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOColSpec
extends EOCommonObject {
    public static String XML_NAME = "colspec";
    private static final String ATTR_TAG_ALIGN = "align";
    private static final String ATTR_TAG_CHAR = "char";
    private static final String ATTR_TAG_CHAROFF = "charoff";
    private static final String ATTR_TAG_COLNAME = "colname";
    private static final String ATTR_TAG_COLNUM = "column";
    private static final String ATTR_TAG_COLSEP = "colsep";
    private static final String ATTR_TAG_COLWIDTH = "colwidth";
    private static final String ATTR_TAG_ROWSEP = "rowsep";
    private String attrAlign = null;
    private String attrChar = null;
    private String attrCharoff = null;
    private String attrColname = null;
    private String attrColnum = null;
    private String attrColsep = null;
    private String attrColwidth = null;
    private double attrColwidthInPt = 0.0;
    private String attrRowsep = null;

    public EOColSpec() {
        super(XML_NAME);
    }

    public EOColSpec(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrAlign != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ALIGN, this.attrAlign);
        }
        if (this.attrChar != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CHAR, this.attrChar);
        }
        if (this.attrCharoff != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_CHAROFF, this.attrCharoff);
        }
        if (this.attrColname != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLNAME, this.attrColname);
        }
        if (this.attrColsep != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLSEP, this.attrColsep);
        }
        if (this.attrColnum != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLNUM, this.attrColnum);
        }
        if (this.attrColwidth != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_COLWIDTH, this.attrColwidth);
        }
        if (this.attrRowsep != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ROWSEP, this.attrRowsep);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean result = true;
        if (name.equals(ATTR_TAG_ALIGN)) {
            this.attrAlign = value;
        } else if (name.equals(ATTR_TAG_CHAR)) {
            this.attrChar = value;
        } else if (name.equals(ATTR_TAG_CHAROFF)) {
            this.attrCharoff = value;
        } else if (name.equals(ATTR_TAG_COLNAME)) {
            this.attrColname = value;
        } else if (name.equals(ATTR_TAG_COLNUM)) {
            this.attrColnum = value;
        } else if (name.equals(ATTR_TAG_COLSEP)) {
            this.attrColsep = value;
        } else if (name.equals(ATTR_TAG_COLWIDTH)) {
            this.setColumnwidth(value);
        } else if (name.equals(ATTR_TAG_ROWSEP)) {
            this.attrRowsep = value;
        } else {
            result = super.setAttributeFromXML(name, value);
        }
        return result;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getAttrAlign() {
        return this.attrAlign;
    }

    public void setAlign(String string) {
        this.attrAlign = string;
    }

    public void setChar(String string) {
        this.attrChar = string;
    }

    public void setCharoff(String string) {
        this.attrCharoff = string;
    }

    public String getColname() {
        return this.attrColname;
    }

    public void setColname(String string) {
        this.attrColname = string;
    }

    public void setColsep(String string) {
        this.attrColsep = string;
    }

    public void setColnum(String string) {
        this.attrColnum = string;
    }

    public void setColumnwidth(String string) {
        if (string.endsWith("mm")) {
            String value = string.substring(0, string.length() - "mm".length());
            this.setColumnwidthInMm(Double.parseDouble(value));
        } else if (string.endsWith("pt")) {
            String value = string.substring(0, string.length() - "pt".length());
            this.setColumnwidthInPt(Double.parseDouble(value));
        } else {
            this.attrColwidth = string;
        }
    }

    public void setColumnwidthInMm(double mm) {
        this.attrColwidth = String.valueOf((int)this.toPt(mm));
        this.attrColwidthInPt = this.toPt(mm);
    }

    public void setColumnwidthInPt(double pt) {
        this.attrColwidth = String.valueOf((int)pt);
        this.attrColwidthInPt = pt;
    }

    public String getColumnwidth() {
        return this.attrColwidth;
    }

    public double getColumnwidthInPt() {
        return this.attrColwidthInPt;
    }

    public double getColumnwidthInMm() {
        return this.toMm(this.attrColwidthInPt);
    }

    public double getColumnwidthInPoints() {
        return this.toMm(this.attrColwidthInPt) / 10.0 * 28.35;
    }

    private double toPt(double mm) {
        return mm / 0.376;
    }

    private double toMm(double pt) {
        return pt * 0.376;
    }

    public void setRowsep(String string) {
        this.attrRowsep = string;
    }
}

