/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOArticle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBookInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitleAbbrev;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOBook
extends EOCommonObject {
    public static String XML_NAME = "book";
    private static final String ATTR_TAG_FPI = "fpi";
    private static final String ATTR_TAG_LABEL = "label";
    private static final String ATTR_TAG_STATUS = "status";
    private String attrFpi = null;
    private String attrLabel = null;
    private String attrStatus = null;
    private EOTitle title = null;
    private EOSubtitle subtitle = null;
    private EOTitleAbbrev titleAbbrev = null;
    private EOBookInfo bookInfo = null;
    private final ArrayList<Object> content = new ArrayList();

    public EOBook() {
        super(XML_NAME);
    }

    public EOBook(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.attrFpi != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FPI, this.attrFpi);
        }
        if (this.attrLabel != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_LABEL, this.attrLabel);
        }
        if (this.attrStatus != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_STATUS, this.attrStatus);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_FPI)) {
            this.attrFpi = value;
        } else if (name.equals(ATTR_TAG_LABEL)) {
            this.attrLabel = value;
        } else if (name.equals(ATTR_TAG_STATUS)) {
            this.attrStatus = value;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return this.title != null || this.content.size() >= 1;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.title != null) {
            this.title.writeXMLBody(writeContext, depth);
            if (this.subtitle != null) {
                this.subtitle.writeXMLBody(writeContext, depth);
            }
            if (this.titleAbbrev != null) {
                this.titleAbbrev.writeXMLBody(writeContext, depth);
            }
            if (this.bookInfo != null) {
                this.bookInfo.writeXMLBody(writeContext, depth);
            }
        }
        if (this.content.size() > 0) {
            for (Object obj : this.content) {
                if (!(obj instanceof EOCommonObject)) continue;
                EOCommonObject eo = (EOCommonObject)((Object)obj);
                eo.writeXMLBody(writeContext, depth);
            }
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOTitle) {
            this.title = (EOTitle)newChild;
        } else if (newChild instanceof EOSubtitle) {
            this.subtitle = (EOSubtitle)newChild;
        } else if (newChild instanceof EOTitleAbbrev) {
            this.titleAbbrev = (EOTitleAbbrev)newChild;
        } else if (newChild instanceof EOBookInfo) {
            this.bookInfo = (EOBookInfo)newChild;
        } else if (newChild instanceof EOCommonObject) {
            this.content.add(newChild);
        } else {
            success = false;
        }
        return success;
    }

    public void setFpi(String fpi) {
        this.attrFpi = fpi;
    }

    public void setLabel(String label) {
        this.attrLabel = label;
    }

    public void setStatus(String string) {
        this.attrStatus = string;
    }

    public void add(EOArticle article) {
        assert (article != null) : "EOArticle is null";
        this.content.add((Object)article);
    }

    public void add(EOChapter chapter) {
        assert (chapter != null) : "EOChapter is null";
        this.content.add((Object)chapter);
    }

    public void add(EOPreface preface) {
        assert (preface != null) : "EOPreface is null";
        this.content.add((Object)preface);
    }

    public void add(EOTitle title) {
        assert (title != null) : "EOTitle is null";
        this.title = title;
    }

    public void add(EOSubtitle subtitle) {
        assert (subtitle != null) : "EOSubtitle is null";
        this.subtitle = subtitle;
    }

    public void add(EOTitleAbbrev titleAbbrev) {
        assert (titleAbbrev != null) : "EOTitleAbbrev is null";
        this.titleAbbrev = titleAbbrev;
    }

    public void add(EOBookInfo bookInfo) {
        assert (bookInfo != null) : "EOBookInfo is null";
        this.bookInfo = bookInfo;
    }

    public EOTitle getTitle() {
        return this.title;
    }

    public EOSubtitle getSubtitle() {
        return this.subtitle;
    }

    public String getStatus() {
        return this.attrStatus;
    }

    public EOTitleAbbrev getTitleAbbrev() {
        return this.titleAbbrev;
    }

    public EOBookInfo getBookInfo() {
        return this.bookInfo;
    }

    public List<?> getContent() {
        return new ArrayList<Object>(this.content);
    }
}

