/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCommonObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;

public class EOArticle
extends EOCommonObject {
    public static final String XML_NAME = "article";
    private static final String ATTR_TAG_CLASS = "class";
    private static final String ATTR_TAG_PARENTBOOK = "parentbook";
    private static final String ATTR_TAG_STATUS = "status";
    private String articleClass = "";
    private String parentbook = "";
    private String status = "";
    private EOTitle title = null;
    private EOSubtitle subtitle = null;
    private final ArrayList nonSectionContent = new ArrayList();
    private final ArrayList sectionContent = new ArrayList();

    public EOArticle() {
        super(XML_NAME);
    }

    public EOArticle(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        this.appendAttrToXML(writeContext, ATTR_TAG_CLASS, this.articleClass);
        this.appendAttrToXML(writeContext, ATTR_TAG_PARENTBOOK, this.parentbook);
        this.appendAttrToXML(writeContext, ATTR_TAG_STATUS, this.status);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_CLASS)) {
            this.articleClass = value;
        } else if (name.equals(ATTR_TAG_PARENTBOOK)) {
            this.parentbook = value;
        } else if (name.equals(ATTR_TAG_STATUS)) {
            this.status = value;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        boolean hasChildren = this.title != null || this.nonSectionContent.size() >= 1 || this.sectionContent.size() >= 1;
        return hasChildren;
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        EOCommonObject eo;
        if (this.title != null) {
            this.title.writeXMLBody(writeContext, depth);
            if (this.subtitle != null) {
                this.subtitle.writeXMLBody(writeContext, depth);
            }
        }
        if (this.nonSectionContent.size() > 0) {
            for (Object obj : this.nonSectionContent) {
                if (!(obj instanceof EOCommonObject)) continue;
                eo = (EOCommonObject)((Object)obj);
                eo.writeXMLBody(writeContext, depth);
            }
        }
        if (this.sectionContent.size() > 0) {
            for (Object obj : this.sectionContent) {
                if (!(obj instanceof EOCommonObject)) continue;
                eo = (EOCommonObject)((Object)obj);
                eo.writeXMLBody(writeContext, depth);
            }
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOTitle) {
            this.title = (EOTitle)newChild;
        } else if (newChild instanceof EOSubtitle) {
            this.subtitle = (EOSubtitle)newChild;
        } else if (newChild instanceof EOSection) {
            this.sectionContent.add(newChild);
        } else if (newChild instanceof EOCommonObject) {
            this.nonSectionContent.add(newChild);
        } else {
            success = false;
        }
        return success;
    }

    public void add(EOAnchor anchor) {
        assert (anchor != null) : "EOAnchor object is null";
        this.nonSectionContent.add(anchor);
    }

    public void add(EOPara para) {
        assert (para != null) : "EOPara object is null";
        this.nonSectionContent.add(para);
    }

    public void add(EOSection section) {
        assert (section != null) : "EOSection object is null";
        this.sectionContent.add(section);
    }

    public void add(EOTable table) {
        assert (table != null) : "EOTable object is null";
        this.sectionContent.add(table);
    }

    public void add(EOTitle p_title) {
        this.title = p_title;
    }

    public void add(EOSimpleList list) {
        assert (list != null) : "EOSimpleList object is null";
        this.nonSectionContent.add(list);
    }

    public void add(EOSubtitle p_subtitle) {
        this.subtitle = p_subtitle;
    }

    public void add(EOMediaObject mediaObject) {
        assert (mediaObject != null) : "EOMediaObject object is null";
        this.nonSectionContent.add(mediaObject);
    }
}

