/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook.model;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOArticle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBiblioID;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBiblioMisc;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBookInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOChapter;
import com.arcway.cockpit.docgen.writer.docbook.model.EOColSpec;
import com.arcway.cockpit.docgen.writer.docbook.model.EOCopyright;
import com.arcway.cockpit.docgen.writer.docbook.model.EODate;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEdition;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEntry;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageData;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOIssueNum;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMember;
import com.arcway.cockpit.docgen.writer.docbook.model.EOObjectInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOOrgName;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPreface;
import com.arcway.cockpit.docgen.writer.docbook.model.EOProductName;
import com.arcway.cockpit.docgen.writer.docbook.model.EOProductNumber;
import com.arcway.cockpit.docgen.writer.docbook.model.EOReleaseInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EORow;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTBody;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTFoot;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTGroup;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTHead;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitleAbbrev;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.StacktraceConverter;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DocBookEOFactory
implements IEncodableObjectFactory {
    private static final ILogger logger = Logger.getLogger(DocBookEOFactory.class);
    private static XMLDecoder decoder = new XMLDecoder();

    public EncodableObjectBase createEncodableObject(String xmlName, XMLContext context) throws EXDecoderException {
        if (xmlName.equals(EOAnchor.XML_NAME)) {
            return new EOAnchor(context);
        }
        if (xmlName.equals("article")) {
            return new EOArticle(context);
        }
        if (xmlName.equals(EOBook.XML_NAME)) {
            return new EOBook(context);
        }
        if (xmlName.equals(EOBookInfo.XML_NAME)) {
            return new EOBookInfo(context);
        }
        if (xmlName.equals(EOIssueNum.XML_NAME)) {
            return new EOIssueNum(context);
        }
        if (xmlName.equals(EODate.XML_NAME)) {
            return new EODate(context);
        }
        if (xmlName.equals(EOBiblioID.XML_NAME)) {
            return new EOBiblioID(context);
        }
        if (xmlName.equals(EOProductName.XML_NAME)) {
            return new EOProductName(context);
        }
        if (xmlName.equals(EOProductNumber.XML_NAME)) {
            return new EOProductNumber(context);
        }
        if (xmlName.equals(EOBiblioMisc.XML_NAME)) {
            return new EOBiblioMisc(context);
        }
        if (xmlName.equals(EOCopyright.XML_NAME)) {
            return new EOCopyright(context);
        }
        if (xmlName.equals(EOOrgName.XML_NAME)) {
            return new EOOrgName(context);
        }
        if (xmlName.equals(EOEdition.XML_NAME)) {
            return new EOEdition(context);
        }
        if (xmlName.equals(EOReleaseInfo.XML_NAME)) {
            return new EOReleaseInfo(context);
        }
        if (xmlName.equals(EOTitleAbbrev.XML_NAME)) {
            return new EOTitleAbbrev(context);
        }
        if (xmlName.equals(EOChapter.XML_NAME)) {
            return new EOChapter(context);
        }
        if (xmlName.equals(EOPreface.XML_NAME)) {
            return new EOPreface(context);
        }
        if (xmlName.equals(EOColSpec.XML_NAME)) {
            return new EOColSpec(context);
        }
        if (xmlName.equals(EOEntry.XML_NAME)) {
            return new EOEntry(context);
        }
        if (xmlName.equals("imagedata")) {
            return new EOImageData(context);
        }
        if (xmlName.equals(EOImageObject.XML_NAME)) {
            return new EOImageObject(context);
        }
        if (xmlName.equals(EOLink.XML_NAME)) {
            return new EOLink(context);
        }
        if (xmlName.equals(EOMediaObject.XML_NAME)) {
            return new EOMediaObject(context);
        }
        if (xmlName.equals(EOMember.XML_NAME)) {
            return new EOMember(context);
        }
        if (xmlName.equals(EOPara.XML_NAME)) {
            return new EOPara(context);
        }
        if (xmlName.equals(EORow.XML_NAME)) {
            return new EORow(context);
        }
        if (xmlName.equals(EOSection.XML_NAME)) {
            return new EOSection(context);
        }
        if (xmlName.equals(EOSimpleList.XML_NAME)) {
            return new EOSimpleList(context);
        }
        if (xmlName.equals(EOSubtitle.XML_NAME)) {
            return new EOSubtitle(context);
        }
        if (xmlName.equals(EOTable.XML_NAME)) {
            return new EOTable(context);
        }
        if (xmlName.equals(EOTBody.XML_NAME)) {
            return new EOTBody(context);
        }
        if (xmlName.equals(EOTFoot.XML_NAME)) {
            return new EOTFoot(context);
        }
        if (xmlName.equals(EOTGroup.XML_NAME)) {
            return new EOTGroup(context);
        }
        if (xmlName.equals(EOTHead.XML_NAME)) {
            return new EOTHead(context);
        }
        if (xmlName.equals(EOTitle.XML_NAME)) {
            return new EOTitle(context);
        }
        if (xmlName.equals(EOObjectInfo.XML_NAME)) {
            return new EOObjectInfo(context);
        }
        if (xmlName.equals(EOUlink.XML_NAME)) {
            return new EOUlink(context);
        }
        if (xmlName.equals(EOEmphasis.XML_NAME)) {
            return new EOEmphasis(context);
        }
        if (xmlName.equals(EOPhrase.XML_NAME)) {
            return new EOPhrase(context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOBook load(String filename) throws Exception {
        EOBook result = null;
        File configurationFile = new File(filename);
        if (configurationFile.exists()) {
            try {
                BufferedInputStream b_in = new BufferedInputStream(new FileInputStream(configurationFile));
                try {
                    XMLDecoder xMLDecoder = decoder;
                    synchronized (xMLDecoder) {
                        boolean areAttibutValuesByDefaultURLEncoded = false;
                        result = (EOBook)decoder.decodeXML((InputStream)b_in, (IEncodableObjectFactory)this, areAttibutValuesByDefaultURLEncoded);
                    }
                }
                catch (EXDecoderException e) {
                    logger.error("Exception when decoding DocBook file: " + filename, (Throwable)e);
                    String title = Messages.getString("DocBookEOFactory.ErrorTitle");
                    String msg = String.valueOf(Messages.getString("DocBookEOFactory.ErrorText1")) + filename + Messages.getString("DocBookEOFactory.ErrorText2");
                    Throwable cause = e.getCause() == null ? e : e.getCause();
                    msg = String.valueOf(msg) + "\n" + cause.getLocalizedMessage();
                    throw new ReportGenerationException(title, msg, cause);
                }
                catch (Exception e) {
                    logger.error("Exception when decoding DocBook file: " + filename, (Throwable)e);
                    String title = Messages.getString("DocBookEOFactory.ErrorTitle");
                    String msg = String.valueOf(title) + "\n\n" + e.getLocalizedMessage() + "\n\n";
                    msg = String.valueOf(msg) + StacktraceConverter.stacktraceToString((Throwable)e);
                    throw new ReportGenerationException(title, msg, (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Can not find DocBook file: " + filename, (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(EOBook book, String filename) {
        boolean success = false;
        File configurationFile = new File(filename);
        if (book != null) {
            try {
                DocBookEOFactory docBookEOFactory = this;
                synchronized (docBookEOFactory) {
                    book.writeToFile(configurationFile);
                }
                success = true;
            }
            catch (Exception e) {
                success = false;
            }
        } else {
            assert (false) : "nothing to save";
            success = false;
        }
        return success;
    }
}

