/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook;

import com.arcway.cockpit.docgen.writer.VelocityReportTemplateFileValidator;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportTemplateTypes;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplateType;
import com.arcway.lib.io.IFileValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class ReportTemplateTypeNonDocBook
implements IReportTemplateType {
    public static final String NON_DOCBOOK_REPORT_TEMPLATE_TYPE_ID = "velocity.non-docbook";

    public String getID() {
        return NON_DOCBOOK_REPORT_TEMPLATE_TYPE_ID;
    }

    public Collection<String> getPossibleFileExtensions() {
        return Collections.singleton("rpttpl");
    }

    public IFileValidator getHighPerformanceFileValidator() {
        return this.getFileValidator(false);
    }

    public IFileValidator getThoroughFileValidator() {
        return this.getFileValidator(true);
    }

    private IFileValidator getFileValidator(boolean thorough) {
        return new VelocityReportTemplateFileValidator(thorough){

            @Override
            public boolean isValid_(File file) {
                String reportTemplateTargetType = VelocityReportTemplateTypes.getReportTemplateTargetType(file);
                boolean isDocBook = "docbook".equalsIgnoreCase(reportTemplateTargetType);
                boolean isNoOutput = "nooutput".equalsIgnoreCase(reportTemplateTargetType);
                boolean isCockpitScript = "cockpitscript".equalsIgnoreCase(reportTemplateTargetType);
                boolean isCockpitScriptNoOutput = "cockpitscript_nooutput".equalsIgnoreCase(reportTemplateTargetType);
                return !isDocBook && !isNoOutput && !isCockpitScript && !isCockpitScriptNoOutput;
            }
        };
    }
}

