/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DocBookPostProcessingProgress {
    private final IProgressMonitor progressMonitor;
    private final List<Integer> sectionCount;
    private int chapterProgress;
    private int sectionProgress;

    public DocBookPostProcessingProgress(IProgressMonitor monitor, List<Integer> sectionCount) {
        assert (monitor != null);
        this.progressMonitor = monitor;
        this.sectionCount = sectionCount;
        this.chapterProgress = 0;
        this.sectionProgress = 0;
        this.initialiseProgress();
    }

    public void incrementSectionProgress() {
        ++this.sectionProgress;
        this.progressMonitor.worked(1);
        this.updateProgressMonitor();
    }

    public void incrementChapterProgress() {
        ++this.chapterProgress;
        this.sectionProgress = 0;
        this.progressMonitor.worked(1);
        this.updateProgressMonitor();
    }

    public void checkCancelState() throws ReportGenerationCanceledException {
        if (this.progressMonitor.isCanceled()) {
            throw new ReportGenerationCanceledException();
        }
    }

    private void initialiseProgress() {
        int partCount = this.sectionCount.size();
        for (Integer sectionsInChapter : this.sectionCount) {
            partCount += sectionsInChapter.intValue();
        }
        this.progressMonitor.beginTask(Messages.getString("DocBookPostProcessingProgress.0"), partCount);
        this.updateProgressMonitor();
    }

    private void updateProgressMonitor() {
        String msg1 = "";
        if (this.chapterProgress < this.sectionCount.size()) {
            msg1 = String.valueOf(Messages.getString("DocBookPostProcessingProgress.5")) + (this.chapterProgress + 1);
            msg1 = String.valueOf(msg1) + Messages.getString("DocBookPostProcessingProgress.6") + this.sectionCount.size();
            if (this.sectionProgress < this.sectionCount.get(this.chapterProgress) + 1) {
                msg1 = String.valueOf(msg1) + ", ";
                msg1 = String.valueOf(msg1) + Messages.getString("DocBookPostProcessingProgress.7") + (this.sectionProgress + 1);
                msg1 = String.valueOf(msg1) + Messages.getString("DocBookPostProcessingProgress.8") + (this.sectionCount.get(this.chapterProgress) + 1);
            }
        }
        this.progressMonitor.subTask(msg1);
    }
}

