/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.docbook;

import com.arcway.cockpit.docgen.writer.AbstractDocumentationWriterWithProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageData;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOObjectInfo;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDocBookDocumentationWriter
extends AbstractDocumentationWriterWithProgress {
    private static final Set<String> applicableReportTemplateTypes = new HashSet<String>(2);

    static {
        applicableReportTemplateTypes.add("velocity.docbook");
        applicableReportTemplateTypes.add("velocity.unspecified");
    }

    public AbstractDocBookDocumentationWriter(boolean threadable, boolean cancelable) {
        super(threadable, cancelable);
    }

    @Override
    public Set<String> getApplicableReportTemplateTypes() {
        return applicableReportTemplateTypes;
    }

    protected final String getDocBookSnippetForEmbeddedMediaObject(String fileName, String displayName, String format, double width_mm, double height_mm, boolean add1AdjustmentPixelToWidthAndHeight) throws EXEncoderException {
        EOMediaObject mediaObject = new EOMediaObject();
        EOObjectInfo objectInfo = new EOObjectInfo();
        objectInfo.setTitle(displayName);
        mediaObject.setObjectInfo(objectInfo);
        EOImageObject imageObject = new EOImageObject();
        mediaObject.add(imageObject);
        EOImageData imageData = new EOImageData();
        imageData.setFileReference(fileName);
        imageData.setFormat(format.toUpperCase());
        double effectiveWidth_mm = width_mm;
        double effectiveHeight_mm = height_mm;
        if (add1AdjustmentPixelToWidthAndHeight) {
            double mmPerPixelIn72DPI = 0.35277777777777775;
            double mmOf1PixelIn72DPI = mmPerPixelIn72DPI * 1.0;
            if (effectiveWidth_mm > 0.0) {
                effectiveWidth_mm += mmOf1PixelIn72DPI;
            }
            if (effectiveHeight_mm > 0.0) {
                effectiveHeight_mm += mmOf1PixelIn72DPI;
            }
        }
        if (effectiveWidth_mm > 0.0) {
            imageData.setWidth(effectiveWidth_mm, "mm");
        }
        if (effectiveHeight_mm > 0.0) {
            imageData.setDepth(effectiveHeight_mm, "mm");
        }
        imageObject.addChild((EncodableObjectBase)imageData);
        return mediaObject.toXMLString(true, false);
    }

    protected final String getDocBookSnippetForExternalFileLink(String fileName, String displayName) throws EXEncoderException {
        EOUlink link = new EOUlink();
        link.setUrl(fileName);
        link.setContentInternal(displayName);
        return link.toXMLString(true, false);
    }
}

