/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.cockpitscript;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.AbstractDocumentationWriterWithProgress;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.cockpitscript.ClientFunctionLicenseTypeReportsCockpitScript;
import com.arcway.cockpit.docgen.writer.cockpitscript.CockpitScriptNoOutputDocumentationWriter;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptInterpreter;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;

public class CockpitScriptDocumentationWriter
extends AbstractDocumentationWriterWithProgress {
    private static final String REPORT_TYPE_ID = "COCKPIT_SCRIPT";
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";
    private static final double PREFERRED_IMAGE_RESOLUTION = 192.0;
    private static final int PREFERRED_IMAGE_SIZE = 2400;
    private static final Set<String> applicableReportTemplateTypes = Collections.singleton("velocity.cockpitscript");

    public CockpitScriptDocumentationWriter() {
        super(false, true);
    }

    @Override
    public Set<String> getApplicableReportTemplateTypes() {
        return applicableReportTemplateTypes;
    }

    @Override
    public String getID() {
        return REPORT_TYPE_ID;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("CockpitScriptDocumentationWriter.Label");
    }

    @Override
    public String getDescription() {
        return Messages.getString("CockpitScriptDocumentationWriter.Description");
    }

    @Override
    public String getRequiredOutputTemplateTypeID() {
        return null;
    }

    @Override
    public String getOutputFormat(IReportTemplate reportTemplate) {
        return REPORT_TYPE_ID;
    }

    @Override
    public String getPreferredImageType() {
        return ".svg";
    }

    @Override
    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInPixel(new Dimension(2400.0, 2400.0), 192.0);
    }

    @Override
    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsCockpitScript.getInstance();
    }

    @Override
    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        return FILES_AND_IMAGES_DIRECTORY_NAME + File.separator + fileName;
    }

    @Override
    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor monitor) throws ReportGenerationCanceledException, ReportGenerationException {
        boolean cancelled;
        ReportJob baseReportJob = reportJob.getBaseReportJob();
        Map projectUID2filterItems = baseReportJob != null ? baseReportJob.getProjectUID2filterItems() : Collections.emptyMap();
        ScriptCommandContext scriptUIContext = new ScriptCommandContext(projectUID2filterItems, workbenchPage, monitor);
        File scriptFile = reportJob.getRawReportFile();
        ScriptInterpreter scriptInterpreter = ScriptInterpreter.createScriptInterpreter((File)scriptFile, null, (ScriptCommandContext)scriptUIContext);
        try {
            scriptInterpreter.executeCommands();
        }
        catch (ScriptExecutionException e) {
            CockpitScriptNoOutputDocumentationWriter.handleScriptExecutinException(monitor, e);
        }
        File createdLogFile = scriptInterpreter.getCreatedLogFile();
        boolean bl = cancelled = monitor != null && monitor.isCanceled();
        if (!cancelled) {
            File targetLogFile = new File(reportJob.getBaseReportJob().getReportFilename(), "cockpitscript.log");
            try {
                DataCopyHelper.copyFile((File)createdLogFile, (File)targetLogFile);
                reportJob.getBaseReportJob().setReportMainFileName(targetLogFile.getAbsolutePath());
                reportJob.getBaseReportJob().registerReportResultFiles(Collections.singleton(targetLogFile));
            }
            catch (JvmExternalResourceInteractionException e) {
                throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyReportFile.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyReportFile.Message"), (Throwable)e);
            }
            this.copyGraphicsAndFilesToTargetLocation(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
        }
    }

    @Override
    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpReportFile(reportJob);
    }
}

