/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer;

import com.arcway.cockpit.docgen.core.AbstractVelocityReportProcessor;
import com.arcway.cockpit.docgen.core.velocity.Velocity15_2_Cockpit_LogChute;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;

public abstract class VelocityReportTemplateFileValidator
implements IFileValidator {
    private static final ILogger LOGGER;
    private static final Parser parser;
    private static File lastFileChecked;
    private static boolean lastFileResult;
    private final boolean thorough;

    static {
        Parser parser_nonfinal;
        LOGGER = Logger.getLogger(VelocityReportTemplateFileValidator.class);
        try {
            RuntimeInstance runtimeInstance = new RuntimeInstance();
            AbstractVelocityReportProcessor.initialiseVelocityEngine(runtimeInstance);
            runtimeInstance.init();
            parser_nonfinal = runtimeInstance.createNewParser();
        }
        catch (Exception e) {
            LOGGER.warn("Velocity engine could not be initialised.");
            parser_nonfinal = null;
        }
        parser = parser_nonfinal;
        lastFileChecked = null;
        lastFileResult = false;
    }

    public VelocityReportTemplateFileValidator(boolean thorough) {
        this.thorough = thorough;
    }

    public final boolean isValid(File file) {
        boolean isVelocityReportTemplate;
        if (file == null) {
            return false;
        }
        if (file == lastFileChecked) {
            isVelocityReportTemplate = lastFileResult;
        } else {
            if (this.thorough) {
                isVelocityReportTemplate = false;
                try (FileReader fileReader = new FileReader(file);){
                    Velocity15_2_Cockpit_LogChute.reportErrors();
                    parser.parse((Reader)fileReader, file.getName());
                    isVelocityReportTemplate = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (ParseException parseException) {
                }
                catch (IOException iOException) {}
            } else {
                isVelocityReportTemplate = true;
            }
            lastFileChecked = file;
            lastFileResult = isVelocityReportTemplate;
        }
        if (isVelocityReportTemplate) {
            return this.isValid_(file);
        }
        return false;
    }

    protected abstract boolean isValid_(File var1);
}

