/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.writer.IDocumentationWriter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IResultLauncher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.Collections;

public abstract class AbstractDocumentationWriter
implements IDocumentationWriter {
    protected final void copyRawReportToTargetLocation(VelocityReportJob reportJob) throws ReportGenerationException {
        this.copyRawReportToTargetLocation(reportJob, new File(reportJob.getBaseReportJob().getReportFilename()));
    }

    protected final void copyRawReportToTargetLocation(VelocityReportJob reportJob, String fileName) throws ReportGenerationException {
        File file = new File(reportJob.getBaseReportJob().getReportFilename());
        file = new File(file, fileName);
        this.copyRawReportToTargetLocation(reportJob, file);
    }

    private void copyRawReportToTargetLocation(VelocityReportJob reportJob, File file) throws ReportGenerationException {
        try {
            DataCopyHelper.copyFile((File)reportJob.getRawReportFile(), (File)file);
            reportJob.getBaseReportJob().registerReportResultFiles(Collections.singletonList(file));
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyReportFile.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyReportFile.Message"), (Throwable)e);
        }
    }

    protected final void copyGraphicsAndFilesToTargetLocation(VelocityReportJob reportJob, String subDirectoryName) throws ReportGenerationException {
        this.copyGraphicsAndFilesToTargetLocation(reportJob, subDirectoryName, IFileValidator.ALL_ACCEPTING_FILE_VALIDATOR);
    }

    protected final void copyGraphicsAndFilesToTargetLocation(VelocityReportJob reportJob, String subDirectoryName, IFileValidator fileValidator) throws ReportGenerationException {
        try {
            File reportTargetFile = new File(reportJob.getBaseReportJob().getReportFilename());
            assert (reportTargetFile.isDirectory());
            File targetDirectory = reportTargetFile.isDirectory() ? reportTargetFile : new File(reportTargetFile.getParent());
            File graphicsAndFilesTargetDirectory = new File(targetDirectory, subDirectoryName);
            reportJob.getGraphicsAndFilesStore().copyAllGraphicsAndFilesToTargetDirectory(reportJob.getBaseReportJob(), graphicsAndFilesTargetDirectory, fileValidator);
        }
        catch (Exception e) {
            if (e instanceof ReportGenerationException) {
                throw (ReportGenerationException)((Object)e);
            }
            throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyGraphicsAndFileObjects.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyGraphicsAndFileObjects.Message"), (Throwable)e);
        }
    }

    protected final void copyAdditionalFileToTargetLocation(VelocityReportJob reportJob, String fileName) throws ReportGenerationException {
        String sourceFileNameWithoutPath;
        File sourceFile;
        try {
            sourceFile = new File(fileName);
            sourceFileNameWithoutPath = sourceFile.getName();
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyAdditionalFile.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyAdditionalFile.Message"), (Throwable)e);
        }
        this.copyAdditionalFileToTargetLocation(reportJob, sourceFile, sourceFileNameWithoutPath);
    }

    protected final void copyAdditionalFileToTargetLocation(VelocityReportJob reportJob, File sourceFile, String targetFileName) throws ReportGenerationException {
        try {
            File reportTargetFile = new File(reportJob.getBaseReportJob().getReportFilename());
            assert (reportTargetFile.isDirectory());
            File targetDirectory = reportTargetFile.isDirectory() ? reportTargetFile : new File(reportTargetFile.getParent());
            File additionalFileTargetFile = new File(targetDirectory, targetFileName);
            reportJob.getBaseReportJob().registerReportResultFiles(Collections.singletonList(additionalFileTargetFile));
            DataCopyHelper.copyFile((File)sourceFile, (File)additionalFileTargetFile);
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyAdditionalFile.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyAdditionalFile.Message"), (Throwable)e);
        }
    }

    public final void cleanUpReportFile(VelocityReportJob reportJob) {
        try {
            File targetFile = new File(reportJob.getBaseReportJob().getReportFilename());
            FileHelper.deleteExistingFileOrDirectory((File)targetFile);
        }
        catch (JvmExternalResourceInteractionException jvmExternalResourceInteractionException) {
            // empty catch block
        }
    }

    public final void cleanUpAdditionalFile(VelocityReportJob reportJob, String fileName) {
        try {
            File reportTargetFile = new File(reportJob.getBaseReportJob().getReportFilename());
            File targetDirectory = reportTargetFile.isDirectory() ? reportTargetFile : new File(reportTargetFile.getParent());
            File additionalFileToDelete = new File(targetDirectory, fileName);
            FileHelper.deleteExistingFileOrDirectory((File)additionalFileToDelete);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void cleanUpAdditionalDirectory(VelocityReportJob reportJob, String directoryName) {
        try {
            File reportTargetFile = new File(reportJob.getBaseReportJob().getReportFilename());
            File targetDirectory = reportTargetFile.isDirectory() ? reportTargetFile : new File(reportTargetFile.getParent());
            File targetSubDirectory = new File(targetDirectory, directoryName);
            FileHelper.deleteExistingFileOrDirectory((File)targetSubDirectory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean hasDeterminedOutputFile() {
        return false;
    }

    @Override
    public File determineOutputFile(ReportJob reportJob) {
        return null;
    }

    @Override
    public IResultLauncher getResultLauncher() {
        return null;
    }
}

