/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IInternalAbstractPlanAgentController;
import com.arcway.cockpit.frame.client.project.planagents.IInternalPlanAgentControllerExtension;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FactoryInput;
import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentControllerExtension;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInputExtension;
import com.arcway.planagent.controllinginterface.planexporter.IPlanExporterControllerExtension;
import com.arcway.planagent.controllinginterface.planexporter.IPlanExporterExtension;
import com.arcway.planagent.controllinginterface.planexporter.PlanExporterFactoryInput;
import com.arcway.planagent.controllinginterface.planexporter.PlanExporterInputExtension;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.Collection;

public class PlanExporterControllerExtension
implements IPlanExporterControllerExtension,
IInternalPlanAgentControllerExtension,
IGraphicProvider {
    private static final ILogger logger = Logger.getLogger(PlanExporterControllerExtension.class);
    private final IPlan plan;
    private final PlanDisplayParameters planDisplayParameters;
    private final IDocGeneratorProjectAgent projectAgent;
    private IPlanExporterExtension planAgentExtension = null;
    private IInternalAbstractPlanAgentController abstractPlanAgentController = null;
    private final boolean withMetaInformation;
    private final boolean withComments;
    private final double angle;

    public PlanExporterControllerExtension(IDocGeneratorProjectAgent projectAgent, IPlan plan, PlanDisplayParameters planDisplayParameters, boolean withMetaInformation, boolean withComments, double angle) {
        this.projectAgent = projectAgent;
        this.plan = plan;
        this.planDisplayParameters = planDisplayParameters;
        this.withMetaInformation = withMetaInformation;
        this.withComments = withComments;
        this.angle = angle;
    }

    public Collection<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
        return this.abstractPlanAgentController.getPlanStructure();
    }

    public FlowType getFlowType() {
        return this.abstractPlanAgentController.getFlowType();
    }

    protected IInternalAbstractPlanAgentController getAbstractPlanAgentController() {
        return this.abstractPlanAgentController;
    }

    public void setAbstractPlanAgentController(IInternalAbstractPlanAgentController abstractPlanAgentController) {
        this.abstractPlanAgentController = abstractPlanAgentController;
    }

    protected static final Dimension getLimitedPlanSizeInMM(Dimension planSizeInMM, Dimension maximumSizeInMM) {
        Dimension graphicDimension = null;
        if (maximumSizeInMM == null) {
            graphicDimension = planSizeInMM;
        } else {
            Dimension planDimension = planSizeInMM;
            if (planDimension != null) {
                if (planDimension.width < 1.0E-10 || planDimension.height < 1.0E-10) {
                    graphicDimension = planDimension;
                } else if (planDimension.width < maximumSizeInMM.width && planDimension.height < maximumSizeInMM.height) {
                    graphicDimension = planDimension;
                } else {
                    double imageHeight;
                    double imageWidth;
                    double scaleWidth = maximumSizeInMM.width / planDimension.width;
                    double scaleHeight = maximumSizeInMM.height / planDimension.height;
                    if (scaleWidth < scaleHeight) {
                        imageWidth = planDimension.width * scaleWidth;
                        imageHeight = planDimension.height * scaleWidth;
                    } else {
                        imageWidth = planDimension.width * scaleHeight;
                        imageHeight = planDimension.height * scaleHeight;
                    }
                    graphicDimension = new Dimension(imageWidth, imageHeight);
                }
            }
        }
        return graphicDimension;
    }

    public void closePlanAgent() {
        this.planAgentExtension.close();
    }

    public void planAgentClosed() {
    }

    public void setPlanAgentExtension(IPlanAgentExtension planAgentExtension) {
        this.planAgentExtension = (IPlanExporterExtension)planAgentExtension;
        this.checkOptions();
    }

    public void close() {
        this.closePlanAgent();
    }

    public void export(IPrinter printer, PageSetup hints) throws PrintingFailure {
        this.checkOptions();
        this.planAgentExtension.export(printer, hints);
    }

    private void checkOptions() {
        if (this.withMetaInformation) {
            this.planAgentExtension.showInformation();
        } else {
            this.planAgentExtension.hideInformation();
        }
        if (this.withComments) {
            this.planAgentExtension.showComments();
        } else {
            this.planAgentExtension.hideComments();
        }
        this.planAgentExtension.setRotation(this.angle);
    }

    public String getName() {
        return this.plan.getPlanName();
    }

    public String getUID() {
        return this.plan.getUID();
    }

    public boolean launch(IProgressDisplay pDisplay) {
        boolean launched = false;
        try {
            PlanExporterFactoryInput factoryInput = new PlanExporterFactoryInput();
            PlanExporterInputExtension planAgentInputExtension = new PlanExporterInputExtension((IPlanAgentControllerExtension)this);
            this.projectAgent.launchPlanAgent(this.plan, this.planDisplayParameters, (IInternalPlanAgentControllerExtension)this, (FactoryInput)factoryInput, (PlanAgentInputExtension)planAgentInputExtension, pDisplay);
            launched = true;
        }
        catch (PlanAgentManager.EXPlanAgentLaunchException e) {
            logger.error("addPlan() - Unable to launch plan agent export controller extension", (Throwable)e);
        }
        catch (EXWriteAccessDeniedException e) {
            logger.error("addPlan() - Write access denied: unable to launch plan export controller extension", (Throwable)e);
        }
        return launched;
    }

    public Rectangle getViewSizeInMM() {
        return this.planAgentExtension.getViewSize();
    }

    public void planStructureChanged() {
    }

    public void dispose() {
    }
}

