/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.docgen.provider.interfaces.IPlanPresentationRule;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Geo;

public class ForcedViewRectangle {
    private final Double zoom;
    private final double offsetX;
    private final double offsetY;
    private final Dimension sizeInMM;

    public static ForcedViewRectangle convert(IPlanPresentationRule planPresentationRule) {
        Double zoom = planPresentationRule.getZoom();
        Double winMM = planPresentationRule.getWidthInMM();
        Double hinMM = planPresentationRule.getHeightInMM();
        Dimension sizeInMM = winMM == null || hinMM == null ? null : new Dimension(winMM.doubleValue(), hinMM.doubleValue());
        double offsetXinMM = planPresentationRule.getOffsetXinMM();
        double offsetYinMM = planPresentationRule.getOffsetYinMM();
        ForcedViewRectangle forcedViewRectangle = zoom == null && winMM == null && hinMM == null && Geo.isZero((double)offsetXinMM) && Geo.isZero((double)offsetYinMM) ? null : new ForcedViewRectangle(zoom, offsetXinMM, offsetYinMM, sizeInMM);
        return forcedViewRectangle;
    }

    public ForcedViewRectangle(Double zoom, double offsetX, double offsetY, Dimension sizeInMM) {
        this.zoom = zoom;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.sizeInMM = sizeInMM;
    }

    public Double getZoom() {
        return this.zoom;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public Dimension getSizeInMM() {
        return this.sizeInMM;
    }
}

