/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.PrintingFailure;
import de.plans.lib.svg.ILink;
import java.io.File;
import java.util.Map;

public abstract class AbstractGraphicAdapter {
    public abstract Dimension export(PlanImageSizeHint var1, IGraphicProvider var2, Map<String, String> var3, String var4, Map<String, ILink> var5, ForcedViewRectangle var6) throws PrintingFailure, EXEmptyResult;

    public abstract void save(File var1) throws PrintingFailure, EXEmptyResult;

    protected static Dimension getPlanSizeInMM(IGraphicProvider graphicProvider, ForcedViewRectangle forcedViewRectangle, boolean proceedIfPlanIsEmpty) throws EXEmptyResult {
        Dimension planSizeInMM;
        Dimension forcedSizeInMM;
        Dimension dimension = forcedSizeInMM = forcedViewRectangle == null ? null : forcedViewRectangle.getSizeInMM();
        if (forcedSizeInMM != null) {
            planSizeInMM = forcedSizeInMM;
        } else {
            planSizeInMM = AbstractGraphicAdapter.getPlanDimension(graphicProvider);
            if (proceedIfPlanIsEmpty && planSizeInMM == null) {
                planSizeInMM = new Dimension(0.0, 0.0);
            }
        }
        if (planSizeInMM == null) {
            throw new EXEmptyResult();
        }
        return planSizeInMM;
    }

    protected static Dimension calculateLimitedPlanSize(Dimension planSizeInMM, PlanImageSizeHint preferredSize) {
        Dimension maximumSizeInMM = preferredSize.getPreferredSizeInMM();
        Dimension limitedPlanSizeInMM = AbstractGraphicAdapter.getLimitedPlanSizeInMM(planSizeInMM, maximumSizeInMM);
        return limitedPlanSizeInMM;
    }

    public static final Dimension getLimitedPlanSizeInMM(Dimension planSizeInMM, Dimension maximumSizeInMM) {
        Dimension graphicDimension = null;
        if (maximumSizeInMM == null) {
            graphicDimension = planSizeInMM;
        } else {
            Dimension planDimension = planSizeInMM;
            if (planDimension != null) {
                if (planDimension.width < 1.0E-10 || planDimension.height < 1.0E-10) {
                    graphicDimension = planDimension;
                } else if (planDimension.width < maximumSizeInMM.width && planDimension.height < maximumSizeInMM.height) {
                    graphicDimension = planDimension;
                } else {
                    double imageHeight;
                    double imageWidth;
                    double scaleWidth = maximumSizeInMM.width / planDimension.width;
                    double scaleHeight = maximumSizeInMM.height / planDimension.height;
                    if (scaleWidth < scaleHeight) {
                        imageWidth = planDimension.width * scaleWidth;
                        imageHeight = planDimension.height * scaleWidth;
                    } else {
                        imageWidth = planDimension.width * scaleHeight;
                        imageHeight = planDimension.height * scaleHeight;
                    }
                    graphicDimension = new Dimension(imageWidth, imageHeight);
                }
            }
        }
        return graphicDimension;
    }

    public abstract void disposeImages();

    private static Dimension getPlanDimension(IGraphicProvider graphicProvider) {
        Rectangle planBounds = graphicProvider.getViewSizeInMM();
        Dimension planDimension = planBounds == null ? null : planBounds.getDimension();
        return planDimension;
    }
}

