/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.dialogs;

import com.arcway.cockpit.docgen.provider.dialogs.UserRequestDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StringInputDialog
extends UserRequestDialog {
    private static final ILogger LOGGER = Logger.getLogger(StringInputDialog.class);
    protected String defaultValue;
    protected String selectedString;

    public StringInputDialog(Shell parentShell, String title, String message, String label, String defaultValue) {
        super(parentShell, title, message, label);
        this.defaultValue = defaultValue;
    }

    public String getSelectedString() {
        return this.selectedString;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        area.setLayout((Layout)gl);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblLabel = new Label(area, 0);
        lblLabel.setText(this.label);
        lblLabel.setLayoutData((Object)new GridData(4, 0, false, false));
        final Text text = new Text(area, 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        if (this.defaultValue != null) {
            text.setText(this.defaultValue);
        }
        this.selectedString = text.getText();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringInputDialog.this.selectedString = text.getText();
            }
        });
        return area;
    }
}

