/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.dialogs;

import com.arcway.cockpit.docgen.provider.dialogs.UserRequestDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MultipleStringSelectionDialog
extends UserRequestDialog {
    private static final ILogger LOGGER = Logger.getLogger(MultipleStringSelectionDialog.class);
    private final List<String> availableList;
    private final List<Integer> indexListOfPreselection;
    private final List<Integer> indexListOfSelection = new ArrayList<Integer>();

    public MultipleStringSelectionDialog(Shell parentShell, String title, String message, String label, List<String> availableList, List<Integer> indexListOfPreselection) {
        super(parentShell, title, message, label);
        this.availableList = availableList;
        this.indexListOfPreselection = indexListOfPreselection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 2048);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gl = new GridLayout(2, false);
        area.setLayout((Layout)gl);
        Label lblLabel = new Label(area, 0);
        lblLabel.setText(this.label);
        lblLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        final Table table = new Table(area, 34);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 250;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        for (String entry : this.availableList) {
            TableItem tableItem = new TableItem(table, 16384);
            tableItem.setText(entry);
        }
        for (Integer preselectedIndex : this.indexListOfPreselection) {
            int index = preselectedIndex;
            if (index < 0 || index >= table.getItemCount()) continue;
            table.getItem(index).setChecked(true);
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleStringSelectionDialog.this.indexListOfSelection.clear();
                int i = 0;
                while (i < table.getItemCount()) {
                    TableItem item = table.getItem(i);
                    if (item.getChecked()) {
                        MultipleStringSelectionDialog.this.indexListOfSelection.add(new Integer(i));
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MultipleStringSelectionDialog.this.indexListOfSelection.clear();
                int i = 0;
                while (i < table.getItemCount()) {
                    TableItem item = table.getItem(i);
                    if (item.getChecked()) {
                        MultipleStringSelectionDialog.this.indexListOfSelection.add(new Integer(i));
                    }
                    ++i;
                }
            }
        });
        return area;
    }

    public List<Integer> getSelection() {
        return this.indexListOfSelection;
    }
}

