/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.dialogs.MultipleStringSelectionDialog;
import com.arcway.cockpit.docgen.provider.dialogs.SingleStringSelectionDialog;
import com.arcway.cockpit.docgen.provider.dialogs.StringInputDialog;
import com.arcway.cockpit.docgen.provider.interfaces.IUserInputRequester;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserInputRequester
implements IReportRelatedReportProvider,
IUserInputRequester {
    private IReportRelatedReportContext reportContext;

    @Override
    public void setup(IReportRelatedReportContext reportContext) {
        this.reportContext = reportContext;
    }

    @Override
    public String requestStringInput(String title, String message, String lable) {
        return this.requestStringInput(title, message, lable, null);
    }

    @Override
    public String requestStringInput(String title, String message, String lable, String defaultValue) {
        final String[] chosenString = new String[1];
        final String[] titleAndLabel = new String[]{title, message, lable, defaultValue};
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parentShell = UserInputRequester.this.getParentShell();
                StringInputDialog dialog = new StringInputDialog(parentShell, titleAndLabel[0], titleAndLabel[1], titleAndLabel[2], titleAndLabel[3]);
                dialog.open();
                chosenString[0] = dialog.getSelectedString();
            }
        });
        return HTMLEncoder.encode((String)chosenString[0]);
    }

    @Override
    public int requestStringSelectionFromList(String title, String message, String lable, List<String> selectionList) {
        return this.requestStringSelectionFromList(title, message, lable, selectionList, 0);
    }

    @Override
    public int requestStringSelectionFromList(String title, String message, String lable, List<String> availableList, int indexOfDefaultValue) {
        final int[] defaultValue = new int[1];
        final int[] selection = new int[1];
        final String[] titleAndLabel = new String[4];
        final ArrayList<String> comboList = new ArrayList<String>();
        if (availableList == null || availableList.isEmpty()) {
            return 0;
        }
        comboList.clear();
        comboList.addAll(availableList);
        titleAndLabel[0] = title;
        titleAndLabel[1] = message;
        titleAndLabel[2] = lable;
        defaultValue[0] = indexOfDefaultValue;
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parentShell = UserInputRequester.this.getParentShell();
                SingleStringSelectionDialog dialog = new SingleStringSelectionDialog(parentShell, titleAndLabel[0], titleAndLabel[1], titleAndLabel[2], comboList, defaultValue[0]);
                dialog.open();
                selection[0] = dialog.getSelection();
            }
        });
        return selection[0];
    }

    public List<Integer> requestMultipleStringSelectionFromList(String title, String message, String lable, List<String> availableList, List<Integer> defaultSelection) {
        final String[] titleAndLabel = new String[3];
        final ArrayList<String> internalAvailableList = new ArrayList<String>();
        final ArrayList<Integer> internalPreselectedList = new ArrayList<Integer>();
        final ArrayList<Integer> internalSelectedList = new ArrayList<Integer>();
        internalAvailableList.clear();
        internalPreselectedList.clear();
        internalSelectedList.clear();
        if (availableList == null || availableList.isEmpty()) {
            return defaultSelection;
        }
        internalAvailableList.addAll(availableList);
        internalPreselectedList.addAll(defaultSelection);
        titleAndLabel[0] = title;
        titleAndLabel[1] = message;
        titleAndLabel[2] = lable;
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parentShell = UserInputRequester.this.getParentShell();
                MultipleStringSelectionDialog dialog = new MultipleStringSelectionDialog(parentShell, titleAndLabel[0], titleAndLabel[1], titleAndLabel[2], internalAvailableList, internalPreselectedList);
                dialog.open();
                internalSelectedList.addAll(dialog.getSelection());
            }
        });
        return internalSelectedList;
    }

    private Shell getParentShell() {
        Shell parentShell = this.reportContext.getCurrentPage().getWorkbenchWindow().getShell();
        return parentShell;
    }
}

