/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.StakeholderDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholder;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholderRole;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.docgen.provider.utils.StakeholderComparator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class StakeholderRoleDocGenProxy
extends AbstractCustomPropertiesAccessDocGenProxy
implements IStakeholderRole {
    private IDocGeneratorProjectAgent projectAgent = null;
    private com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole stakeholderRole = null;
    private Collection<AbstractFilter> filters = null;
    private final Locale locale;

    public StakeholderRoleDocGenProxy(com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole stakeholderRole, IDocGeneratorProjectAgent projectAgent, IGraphicsAndFilesHelper fileAttributeProvider, Collection<AbstractFilter> filters, Locale locale) {
        super((IAttributeOwner)stakeholderRole, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.stakeholderRole = stakeholderRole;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.stakeholderRole.getUID();
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.stakeholderRole.getName());
    }

    @Override
    public String getTypeID() {
        return "stakeholderRole";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"com.arcway.cockpit.stakeholderrole")).getDisplayName(this.locale);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.stakeholderRole.getName());
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.stakeholderRole.getDescription());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public List<? extends IStakeholder> getStakeholders() {
        ArrayList stakeholders = new ArrayList(this.projectAgent.getStakeholdersOfRole(this.stakeholderRole));
        Collections.sort(stakeholders, new StakeholderComparator());
        ArrayList<StakeholderDocGenProxy> result = new ArrayList<StakeholderDocGenProxy>(stakeholders.size());
        for (com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder stackholder : stakeholders) {
            StakeholderDocGenProxy stakeholderProxy = new StakeholderDocGenProxy(stackholder, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.locale);
            result.add(stakeholderProxy);
        }
        return result;
    }

    @Override
    public List<? extends IStakeholder> getStakeholdersWithCategory(String categoryID) {
        List<? extends IStakeholder> result = this.getStakeholders();
        return StakeholderRoleDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(result, categoryID);
    }

    @Override
    public List<? extends IStakeholder> getStakeholdersWithDefaultCategory() {
        return this.getStakeholdersWithCategory(null);
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.stakeholderRole.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.stakeholderRole.getAttribute(attrType);
        if (attribute != null && (attributeType = this.stakeholderRole.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.stakeholderRole.getModificationCount());
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

