/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.ConfiguredProject;
import com.arcway.cockpit.docgen.provider.ConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredProject;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.interfaces.IRootDataProvider;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.lib.java.locale.PresentationContext;
import de.plans.psc.client.communication.ServerConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.ui.IWorkbenchPage;

public class RootDataProvider
implements IRootDataProvider {
    public final Map<String, IConfiguredServerConnection> serverID2configuredServerConnection = new HashMap<String, IConfiguredServerConnection>();
    private final Map<String, ConfiguredProject> projectUID2configuredProject = new HashMap<String, ConfiguredProject>();
    private GraphicsAndFilesHelper graphicsAndFilesHelper;
    private PresentationContext presentationContext;
    private Map<String, Collection<AbstractFilter>> projectUID2filterCollection;
    private IWorkbenchPage currentPage;

    @Override
    public void setup(IReportRelatedReportContext reportContext) {
        this.graphicsAndFilesHelper = reportContext.getGraphicsProvider();
        this.presentationContext = reportContext.getPresentationContext();
        this.projectUID2filterCollection = reportContext.getProjectUID2FilterCollection();
        this.currentPage = reportContext.getCurrentPage();
        this.updateConfiguredServerConnections();
        this.updateConfiguredProjects();
    }

    @Override
    public void setup(IProjectRelatedReportContext reportContext) {
        this.graphicsAndFilesHelper = reportContext.getGraphicsProvider();
        this.presentationContext = reportContext.getPresentationContext();
        this.projectUID2filterCollection = reportContext.getProjectUID2FilterCollection();
        this.updateConfiguredServerConnections();
        IDocGeneratorProjectAgent projectAgent = reportContext.getProjectAgent();
        Map<String, IProjectRelatedReportProvider> projectRelatedReportDataProviders = reportContext.getProjectRelatedReportDataProviders();
        ConfiguredProject configuredProject = new ConfiguredProject(this, projectAgent, projectRelatedReportDataProviders, this.currentPage);
        String projectUID = projectAgent.getProjectUID();
        this.projectUID2configuredProject.put(projectUID, configuredProject);
        this.updateConfiguredProjects();
    }

    public GraphicsAndFilesHelper getGraphicsProvider() {
        return this.graphicsAndFilesHelper;
    }

    public PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    public Map<String, Collection<AbstractFilter>> getFilterCollection() {
        return this.projectUID2filterCollection;
    }

    private void updateConfiguredServerConnections() {
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        Collection configuredServerConnections = projectMgr.getConfiguredServerConnections();
        HashSet<String> unknownServerConnections = new HashSet<String>(this.serverID2configuredServerConnection.keySet());
        for (ServerConnection serverConnection : configuredServerConnections) {
            String serverID = serverConnection.getServerID();
            unknownServerConnections.remove(serverID);
            if (this.serverID2configuredServerConnection.containsKey(serverID)) continue;
            ConfiguredServerConnection configuredServerConnection = new ConfiguredServerConnection(this, serverConnection, this.currentPage);
            this.serverID2configuredServerConnection.put(serverID, configuredServerConnection);
        }
        for (String unknownServerID : unknownServerConnections) {
            this.serverID2configuredServerConnection.remove(unknownServerID);
        }
    }

    private void updateConfiguredProjects() {
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        ProjectAgent[] configuredProjectAgents = projectMgr.getConfiguredProjects();
        HashSet<String> unknownProjects = new HashSet<String>(this.projectUID2configuredProject.keySet());
        ProjectAgent[] projectAgentArray = configuredProjectAgents;
        int n = configuredProjectAgents.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAgent projectAgent = projectAgentArray[n2];
            String projectUID = projectAgent.getProjectUID();
            unknownProjects.remove(projectUID);
            if (!this.projectUID2configuredProject.containsKey(projectUID)) {
                ConfiguredProject configuredProject = new ConfiguredProject(this, (IFrameProjectAgent)projectAgent, this.currentPage);
                this.projectUID2configuredProject.put(projectUID, configuredProject);
            }
            ++n2;
        }
        for (String unknownProjectUID : unknownProjects) {
            this.projectUID2configuredProject.remove(unknownProjectUID);
        }
    }

    @Override
    public boolean isReaderClient() {
        int licenseConfiguration = ProjectMgr.getProjectMgr().getLicenseConfiguration();
        return licenseConfiguration == 2;
    }

    @Override
    public Map<String, IConfiguredServerConnection> getConfiguredServerConnections() {
        this.updateConfiguredServerConnections();
        return new HashMap<String, IConfiguredServerConnection>(this.serverID2configuredServerConnection);
    }

    @Override
    public Map<String, IConfiguredProject> getConfiguredProjects() {
        this.updateConfiguredProjects();
        return new HashMap<String, IConfiguredProject>(this.projectUID2configuredProject);
    }
}

