/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.todo_release.IReportTemplate;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ReportTemplateDocGenProxy
extends AbstractAttributeOwnerDocGenProxy
implements IReportTemplate {
    private IDocGeneratorProjectAgent projectAgent = null;
    private com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate reportTemplate = null;
    private Collection<AbstractFilter> filters = null;
    private final Locale locale;

    public ReportTemplateDocGenProxy(com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate reportTemplate, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper fileAttributeProvider, Locale locale) {
        super((IAttributeOwner)reportTemplate, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.reportTemplate = reportTemplate;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.reportTemplate.getUID();
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.reportTemplate.getName());
    }

    @Override
    public String getTypeID() {
        return "reportTemplate";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE)).getDisplayName(this.locale);
    }

    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.reportTemplate.getDescription());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.reportTemplate.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.reportTemplate.getAttribute(attrType);
        if (attribute != null && (attributeType = this.reportTemplate.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.reportTemplate.getModificationCount());
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.reportTemplate.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

