/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.ReportFileHelper;
import com.arcway.cockpit.docgen.provider.interfaces.ICockpitData;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.EXUnknownFlagOrPropertyOrChildRoleForStructuredData;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLElementWO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.IXMLRootElementRO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.codec.xml.XMLCharacters;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.codec.xml.XMLProcessingInstructionItem;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;
import de.plans.lib.localisation.DateFormatHelper;
import de.plans.lib.util.FileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Record
implements IRecord,
IXMLRootElementFactoryWO,
IXMLElementWO,
IXMLRootElementRO {
    private final IGraphicsAndFilesHelper graphicsAndFilesHelper;
    private final Locale locale;
    private final List<String> allKeysInAdditionOrder = new ArrayList<String>();
    private final Map<String, List<Object>> key2propertiesAndChildren = new HashMap<String, List<Object>>();
    private final Set<String> keysOfChildren = new HashSet<String>();
    private String uidCache = null;
    private String fallBackUID = null;
    public static final String KEY_ELEMENTARY_DATA = "value";
    public static final String VALUE_FLAG_TRUE = "true";

    public static String toString(Object value, String separator) {
        String string;
        if (value != null) {
            Object objects;
            Object typedValue;
            if (value instanceof Object[]) {
                typedValue = (Object[])value;
                objects = Arrays.asList(typedValue);
            } else if (value instanceof String[]) {
                typedValue = (String[])value;
                objects = Arrays.asList(typedValue);
            } else {
                objects = value instanceof Collection ? (typedValue = (Collection)value) : Collections.singletonList(value);
            }
            if (objects.isEmpty()) {
                string = null;
            } else if (objects.size() == 1) {
                Object object = objects.iterator().next();
                string = object == null ? null : object.toString();
            } else {
                StringBuilder stringConcatenation = new StringBuilder();
                Iterator iterator = objects.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (stringConcatenation.length() > 0) {
                        stringConcatenation.append(separator);
                    }
                    stringConcatenation.append(object == null ? " " : object.toString());
                }
                string = stringConcatenation.toString();
            }
        } else {
            string = null;
        }
        return string;
    }

    private static List<String> toStringList(Object value, String separator) {
        ArrayList<String> stringList;
        if (value != null) {
            Object objects;
            Object typedValue;
            if (value instanceof Object[]) {
                typedValue = (Object[])value;
                objects = Arrays.asList(typedValue);
            } else if (value instanceof String[]) {
                typedValue = (String[])value;
                objects = Arrays.asList(typedValue);
            } else {
                objects = value instanceof Collection ? (typedValue = (Collection)value) : Collections.singletonList(value);
            }
            stringList = new ArrayList<String>(objects.size());
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringList.add(Record.toString(object, separator));
            }
        } else {
            stringList = null;
        }
        return stringList;
    }

    public Record(IGraphicsAndFilesHelper graphicsAndFilesHelper, Locale locale) {
        this.graphicsAndFilesHelper = graphicsAndFilesHelper;
        this.locale = locale;
    }

    public Record(IGraphicsAndFilesHelper graphicsAndFilesHelper, Locale locale, ICockpitData cockpitData, Set<String> keyWhiteList) {
        Long creationDate;
        Long dateOfLastModification;
        this.graphicsAndFilesHelper = graphicsAndFilesHelper;
        this.locale = locale;
        this.set("wrappedObject", cockpitData);
        if (keyWhiteList == null || keyWhiteList.contains("uniqueIdentifier")) {
            this.set("uniqueIdentifier", cockpitData.getUniqueIdentifier());
        }
        if (keyWhiteList == null || keyWhiteList.contains("projectUniqueIdentifier")) {
            this.set("projectUniqueIdentifier", cockpitData.getProjectUniqueIdentifier());
        }
        if (keyWhiteList == null || keyWhiteList.contains("displayName")) {
            this.set("displayName", cockpitData.getDisplayName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("typeName")) {
            this.set("typeName", cockpitData.getTypeName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("typeID")) {
            this.set("typeID", cockpitData.getTypeID());
        }
        if (keyWhiteList == null || keyWhiteList.contains("commitVersion")) {
            this.set("commitVersion", cockpitData.getCommitVersion());
        }
        if ((keyWhiteList == null || keyWhiteList.contains("dateOfLastModification")) && (dateOfLastModification = cockpitData.getDateOfLastModification_MilliSecondsSince_01_01_1970()) != null) {
            this.set("dateOfLastModification", dateOfLastModification.toString());
        }
        if (keyWhiteList == null || keyWhiteList.contains("lastModifier")) {
            this.set("lastModifier", cockpitData.getLastModifier());
        }
        if ((keyWhiteList == null || keyWhiteList.contains("creationDate")) && (creationDate = cockpitData.getCreationDate_MilliSecondsSince_01_01_1970()) != null) {
            this.set("creationDate", creationDate.toString());
        }
        if (keyWhiteList == null || keyWhiteList.contains("creator")) {
            this.set("creator", cockpitData.getCreator());
        }
        if (keyWhiteList == null || keyWhiteList.contains("modificationCount")) {
            this.set("modificationCount", cockpitData.getModificationCount());
        }
    }

    public static int compare(IRecord record1, IRecord record2, List<String> keysForSorting) {
        return Record.getCompareString((Record)record1, keysForSorting).compareTo(Record.getCompareString((Record)record2, keysForSorting));
    }

    private static String getCompareString(Record record, List<String> keysForSorting) {
        String compareString;
        if (keysForSorting.isEmpty()) {
            compareString = record.getForcedUniqueIdentifier();
        } else {
            StringBuilder compareStringBuilder = new StringBuilder();
            for (String key : keysForSorting) {
                String compareStringForKey = Record.getCompareStringForKey(record, key);
                compareStringBuilder.append(compareStringForKey);
                compareStringBuilder.append('-');
            }
            compareString = compareStringBuilder.toString();
        }
        return compareString;
    }

    private static String getCompareStringForKey(IRecord record, String key) {
        String propertyString = Record.toString(record.get(key), " ");
        if (propertyString == null) {
            propertyString = " ";
        }
        return propertyString;
    }

    private String getForcedUniqueIdentifier() {
        String forcedUid = this.uidCache != null ? this.uidCache : this.getFallbackUID();
        return forcedUid;
    }

    private String getFallbackUID() {
        if (this.fallBackUID == null) {
            this.fallBackUID = UUIDGenerator.getUniqueID();
        }
        return this.fallBackUID;
    }

    public int hashCode() {
        return this.getForcedUniqueIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        Record otherRecord;
        boolean equals = obj == null ? false : (obj instanceof Record ? ((otherRecord = (Record)obj) == this ? true : this.getForcedUniqueIdentifier().equals(otherRecord.getForcedUniqueIdentifier())) : false);
        return equals;
    }

    private void updateCaches(String modifiedKey) {
        if ("uniqueIdentifier".equals(modifiedKey) || "projectUniqueIdentifier".equals(modifiedKey)) {
            this.updateUIDCache();
        }
    }

    private void updateUIDCache() {
        String puid;
        String uid = this.getUniqueIdentifier();
        this.uidCache = uid != null && !uid.isEmpty() ? ((puid = this.getProjectUniqueIdentifier()) != null && !puid.isEmpty() ? String.valueOf(puid) + '-' + uid : uid) : null;
    }

    private List<Object> getOrCreateChildren(String key, boolean asChild) {
        List<Object> children = this.key2propertiesAndChildren.get(key);
        if (children == null) {
            children = new ArrayList<Object>();
            this.allKeysInAdditionOrder.add(key);
            if (asChild) {
                this.keysOfChildren.add(key);
            }
            this.key2propertiesAndChildren.put(key, children);
        }
        return children;
    }

    @Override
    public void set(String key) {
        this.set(key, Boolean.TRUE);
    }

    @Override
    public void set(String key, Object value) {
        List<Object> children = this.getOrCreateChildren(key, false);
        children.clear();
        children.add(value);
        this.updateCaches(key);
    }

    @Override
    public void add(String key, Object value) {
        if (value != null) {
            List<Object> children = this.getOrCreateChildren(key, true);
            children.add(value);
            this.updateCaches(key);
        }
    }

    @Override
    public void addAll(String key, Collection<? extends Object> values) {
        if (values != null && !values.isEmpty()) {
            List<Object> children = this.getOrCreateChildren(key, true);
            for (Object object : values) {
                children.add(object);
            }
            this.updateCaches(key);
        }
    }

    @Override
    public IRecord createAndSet(String key) {
        Record newChild = new Record(this.graphicsAndFilesHelper, this.locale);
        this.set(key, newChild);
        return newChild;
    }

    @Override
    public IRecord createAndAdd(String key) {
        Record newChild = new Record(this.graphicsAndFilesHelper, this.locale);
        this.add(key, newChild);
        return newChild;
    }

    @Override
    public boolean isSet(String key) {
        boolean isSet = this.key2propertiesAndChildren.containsKey(key);
        return isSet;
    }

    @Override
    public boolean isTrue(String key) {
        List<Object> children = this.key2propertiesAndChildren.get(key);
        return children != null && children.size() == 1 && Boolean.TRUE.equals(children.get(0)) && !this.keysOfChildren.contains(key);
    }

    @Override
    public boolean isProperty(String key) {
        List<Object> children = this.key2propertiesAndChildren.get(key);
        return children != null && children.size() == 1 && !this.keysOfChildren.contains(key);
    }

    @Override
    public Object get(String key) {
        int nrOfChildren;
        List<Object> children = this.key2propertiesAndChildren.get(key);
        Object child = children != null ? ((nrOfChildren = children.size()) > 0 ? children.get(nrOfChildren - 1) : null) : null;
        return child;
    }

    @Override
    public List<Object> getAll(String key) {
        List<Object> children = this.key2propertiesAndChildren.get(key);
        if (children == null) {
            children = Collections.emptyList();
        }
        return children;
    }

    @Override
    public int getNrOfEntries(String key) {
        return this.getAll(key).size();
    }

    @Override
    public Object get(String key, int index) {
        List<Object> all = this.getAll(key);
        if (index < 0 || index >= all.size()) {
            return null;
        }
        return all.get(index);
    }

    @Override
    public void insertAt(String key, int index, Object value) {
        if (value != null) {
            List<Object> children = this.getOrCreateChildren(key, true);
            int indexForArray = Math.max(0, Math.min(children.size(), index));
            children.add(indexForArray, value);
        }
    }

    @Override
    public void replace(String key, int index, Object value) {
        if (value != null) {
            int nrOfEntries = this.getNrOfEntries(key);
            if (index >= 0 && index < nrOfEntries) {
                List<Object> children = this.getOrCreateChildren(key, true);
                children.set(index, value);
            }
        }
    }

    @Override
    public void reset(String key) {
        this.allKeysInAdditionOrder.remove(key);
        this.key2propertiesAndChildren.remove(key);
        this.keysOfChildren.remove(key);
        this.updateCaches(key);
    }

    @Override
    public List<String> getKeySet() {
        return this.allKeysInAdditionOrder;
    }

    @Override
    public void sortKeySet() {
        Collections.sort(this.allKeysInAdditionOrder);
    }

    @Override
    public String getID() {
        return Record.toString(this.get("id"), " ");
    }

    @Override
    public String getTitle() {
        return Record.toString(this.get("title"), " ");
    }

    @Override
    public String getName() {
        return Record.toString(this.get("name"), " ");
    }

    @Override
    public List<String> getDescription() {
        return Record.toStringList(this.getAll("description"), " ");
    }

    @Override
    public Object getWrappedObject() {
        return this.get("wrappedObject");
    }

    @Override
    public String getUniqueIdentifier() {
        return Record.toString(this.get("uniqueIdentifier"), " ");
    }

    @Override
    public String getProjectUniqueIdentifier() {
        return Record.toString(this.get("projectUniqueIdentifier"), " ");
    }

    @Override
    public String getDisplayName() {
        return Record.toString(this.get("displayName"), " ");
    }

    @Override
    public String getTypeName() {
        return Record.toString(this.get("typeName"), " ");
    }

    @Override
    public String getTypeID() {
        return Record.toString(this.get("typeID"), " ");
    }

    @Override
    public String getCommitVersion() {
        return Record.toString(this.get("commitVersion"), " ");
    }

    @Override
    public String getDateOfLastModification() {
        return this.getDatePropertyAsHTMLString("dateOfLastModification");
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("dateOfLastModification");
    }

    @Override
    public String getLastModifier() {
        return Record.toString(this.get("lastModifier"), " ");
    }

    @Override
    public String getCreationDate() {
        return this.getDatePropertyAsHTMLString("creationDate");
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        return Record.toString(this.get("creator"), " ");
    }

    @Override
    public String getModificationCount() {
        return Record.toString(this.get("modificationCount"), " ");
    }

    @Override
    public boolean hasCustomPropertyValues() {
        boolean hasCustomPropertyValues = false;
        for (String key : this.getKeySet()) {
            if (!key.startsWith("custom.")) continue;
            hasCustomPropertyValues = true;
            break;
        }
        return hasCustomPropertyValues;
    }

    @Override
    public boolean hasPropertyValue(String propertyID) {
        return this.get(propertyID) != null;
    }

    @Override
    public String getPropertyAsString(String propertyID) {
        String propertyAsString = this.getAll("_dateProperty").contains(propertyID) ? this.getDatePropertyAsHTMLString(propertyID) : (this.getAll("_commaSeparatedProperty").contains(propertyID) ? Record.toString(this.get(propertyID), ", ") : Record.toString(this.get(propertyID), " "));
        return propertyAsString;
    }

    private String getDatePropertyAsHTMLString(String key) {
        String htmlDate;
        Long longDate = this.getDateTimeProperty_MilliSecondsSince_01_01_1970(key);
        if (longDate != null) {
            Date date = new Date(longDate);
            htmlDate = DateFormatHelper.getDefault().getDateFormat(this.locale).format(date);
        } else {
            htmlDate = null;
        }
        return htmlDate;
    }

    @Override
    public List<String> getPropertyAsStringList(String propertyID) {
        List<String> propertyAsStringList = this.getAll("_dateProperty").contains(propertyID) ? Collections.singletonList(this.getDatePropertyAsHTMLString(propertyID)) : Record.toStringList(this.getAll(propertyID), " ");
        return propertyAsStringList;
    }

    @Override
    public List<String> getPropertyAsStringArray(String propertyID) {
        return this.getPropertyAsStringList(propertyID);
    }

    @Override
    public String getFileProperty(String propertyID) {
        return this.getFileProperty(propertyID, 0.0, 0.0);
    }

    @Override
    public String getFileProperty(String propertyID, double width_mm, double height_mm) {
        byte[] fileContent = this.getFileContent(propertyID);
        String originalFileName = this.getPropertyAsString(String.valueOf(propertyID) + "._originalfileName");
        String snippet = ReportFileHelper.writeFileIntoPostProcessingFile(this.graphicsAndFilesHelper, originalFileName, fileContent, width_mm, height_mm);
        return snippet;
    }

    @Override
    public String getFilePropertyAsFileName(String propertyID) {
        return this.getFilePropertyAsFileName(propertyID, "");
    }

    @Override
    public String getFilePropertyAsFileName(String propertyID, String fileNamePrefix) {
        byte[] fileContent = this.getFileContent(propertyID);
        String originalFileName = this.getPropertyAsString(String.valueOf(propertyID) + "._originalfileName");
        String prefix = String.valueOf(fileNamePrefix) + FileHelper.getFileNameWithoutExtension((String)originalFileName);
        int lastDotIndex = originalFileName.lastIndexOf(46);
        String extension = lastDotIndex != -1 ? originalFileName.substring(lastDotIndex) : "";
        File file = ReportFileHelper.writeFileIntoPreProcessingFile(fileContent, prefix, extension);
        String fileName = AbstractAttributeOwnerDocGenProxy.getFileName(file);
        return fileName;
    }

    @Override
    public List<String> getFilePropertyAsStringList(String propertyID, String characterEncoding) {
        List<String> fileContentAsStringListNONHTML = this.getFilePropertyAsRawStringList(propertyID, characterEncoding);
        return AbstractAttributeOwnerDocGenProxy.convertFileContentIntoHTMLEncodedNormalisedMultilineTextOutput(fileContentAsStringListNONHTML);
    }

    @Override
    public List<String> getFilePropertyAsRawStringList(String propertyID, String characterEncoding) {
        byte[] fileContent = this.getFileContent(propertyID);
        return AbstractAttributeOwnerDocGenProxy.convertFileContentIntoRawStringList(characterEncoding, fileContent);
    }

    @Override
    public List<String> getFilePropertyAsBase64StringList(String propertyID, boolean breakLines) {
        byte[] fileContent = this.getFileContent(propertyID);
        return AbstractAttributeOwnerDocGenProxy.getBase64StringList(breakLines, fileContent);
    }

    private byte[] getFileContent(String propertyID) {
        List<String> base64FileContent = this.getPropertyAsStringList(propertyID);
        String fileContentBase64Encoded = ReportFileHelper.concatenate(base64FileContent, false, false);
        byte[] fileContent = ReportFileHelper.decodeBase64File(fileContentBase64Encoded);
        return fileContent;
    }

    @Override
    public Long getDateTimeProperty_MilliSecondsSince_01_01_1970(String propertyID) {
        return Long.getLong(Record.toString(this.get(propertyID), " "));
    }

    @Override
    public String getCategoryID() {
        return Record.toString(this.get("categoryID"), " ");
    }

    @Override
    public String getCategoryLabel() {
        return Record.toString(this.get("categoryLabel"), " ");
    }

    @Override
    public boolean hasDefaultCategory() {
        return this.get("categoryID") == null;
    }

    public IRecord toRecord() {
        return this;
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        return this;
    }

    @Override
    public String getObjectType() {
        return Record.toString(this.get("objectType"), " ");
    }

    @Override
    public Object getAttribute(String attributeID) {
        return this.get(attributeID);
    }

    @Override
    public String getAttribute_asSingleLine(String attributeID) {
        return this.getPropertyAsString(attributeID);
    }

    @Override
    public List<String> getAttribute_asParagraphList(String attributeID) {
        return this.getPropertyAsStringList(attributeID);
    }

    @Override
    public Long getAttribute_asTimestamp_MilliSecondsSince_01_01_1970(String attributeID) {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970(attributeID);
    }

    public void encodeNonNullData(IDataType dataType, Object data) {
        Class type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
            this.encodeNonNullElementaryData(data, elementaryDataType);
        } else if (IStructuredDataType.class.isAssignableFrom(type)) {
            IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
            this.encodeNonNullStructuredData(data, structuredDataType);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void encodeNonNullElementaryData(Object data, IElementaryDataType elementaryDataType) {
        String valueAsString = elementaryDataType.getValueAsString(data);
        this.set(KEY_ELEMENTARY_DATA, valueAsString);
    }

    private void encodeNonNullStructuredData(Object data, IStructuredDataType structuredDataType) {
        for (IKey role : structuredDataType.getFlagAndPropertyAndChildRoles(data)) {
            IDataType dataTypeOfPropertyOrChildren;
            String key = role.toCanonicalString();
            SubDataType subDataType = structuredDataType.getSubDataType(role);
            if (subDataType.isFlag()) {
                if (structuredDataType.isSet(data, role)) {
                    this.set(key);
                    continue;
                }
                this.reset(key);
                continue;
            }
            if (subDataType.isProperty()) {
                dataTypeOfPropertyOrChildren = structuredDataType.getDataTypeOfPropertyOrChildren(data, role);
                Object property = structuredDataType.getProperty(data, role);
                Object encodedProperty = this.encodePropertyOrChild(dataTypeOfPropertyOrChildren, property);
                this.set(key, encodedProperty);
                continue;
            }
            if (subDataType.isChild()) {
                dataTypeOfPropertyOrChildren = structuredDataType.getDataTypeOfPropertyOrChildren(data, role);
                for (Object child : structuredDataType.getChildren(data, role)) {
                    Object encodedChild = this.encodePropertyOrChild(dataTypeOfPropertyOrChildren, child);
                    this.add(key, encodedChild);
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public Object encodePropertyOrChild(IDataType dataType, Object data) {
        Object encodedObject;
        if (dataType.isNull(data)) {
            encodedObject = null;
        } else {
            Class type = dataType.getStructureType();
            IDataType concreteDataType = dataType.getConcreteDataType();
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
                encodedObject = Record.encodeNonNullElementaryDataAsString(elementaryDataType, data);
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
                encodedObject = this.encodeNonNullStructuredData(structuredDataType, data);
            } else {
                throw new IllegalArgumentException("Data type is neither elementary nor structured");
            }
        }
        return encodedObject;
    }

    private static String encodeNonNullElementaryDataAsString(IElementaryDataType dataType, Object data) {
        return dataType.getValueAsString(data);
    }

    private Record encodeNonNullStructuredData(IStructuredDataType dataType, Object data) {
        Record newChild = new Record(this.graphicsAndFilesHelper, this.locale);
        newChild.encodeNonNullStructuredData(dataType, data);
        return newChild;
    }

    public Object decodeNonNullData(IDataType dataType) throws EXDataCreationFailed {
        Object data;
        Class type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
            data = this.decodeNonNullElementaryData(elementaryDataType);
        } else if (IStructuredDataType.class.isAssignableFrom(type)) {
            IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
            data = this.decodeNonNullStructuredData(structuredDataType);
        } else {
            throw new IllegalArgumentException("Data type is neither elementary nor structured");
        }
        return data;
    }

    private Object decodeNonNullElementaryData(IElementaryDataType dataType) throws EXDataCreationFailed {
        Object value = this.get(KEY_ELEMENTARY_DATA);
        if (value == null || !(value instanceof String)) {
            throw new EXDataCreationFailed((Exception)new IllegalArgumentException("value contains no string"));
        }
        String valueAsString = (String)value;
        IElementaryDataFactory dataFactory = dataType.createDataFactory();
        dataFactory.setCharacters(valueAsString);
        Object data = dataFactory.createDataElement();
        return data;
    }

    private Object decodeNonNullStructuredData(IStructuredDataType dataType) throws EXDataCreationFailed {
        IStructuredDataFactory dataFactory = dataType.createDataFactory();
        for (String key : this.getKeySet()) {
            this.decodeFlagOrPropertyOrChild(dataType, dataFactory, key);
        }
        Object data = dataFactory.createDataElement();
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeFlagOrPropertyOrChild(IStructuredDataType dataType, IStructuredDataFactory dataFactory, String key) throws EXDataCreationFailed {
        Key role = Key.getCanonicalKeyInstance((String)key);
        try {
            SubDataType roleType = dataType.getSubDataType((IKey)role);
            if (roleType == null) {
                throw new EXUnknownFlagOrPropertyOrChildRoleForStructuredData((IKey)role);
            }
            if (roleType.isFlag()) {
                List<Object> values = this.getAll(key);
                if (values.size() != 1) {
                    if (values.size() <= 1) return;
                    throw new EXDataCreationFailed((Exception)new IllegalArgumentException("Flag " + key + " contains more than one values."));
                }
                Object value = values.get(0);
                if (value instanceof String) {
                    String valueAsString = (String)value;
                    if (!VALUE_FLAG_TRUE.equals(valueAsString)) throw new EXDataCreationFailed((Exception)new IllegalArgumentException(String.valueOf(key) + " does not contain " + VALUE_FLAG_TRUE));
                    dataFactory.setFlag((IKey)role);
                    return;
                }
                if (!(value instanceof Boolean)) throw new EXDataCreationFailed((Exception)new IllegalArgumentException(String.valueOf(key) + " contains no Boolean and not String \"true\""));
                Boolean valueAsBoolean = (Boolean)value;
                if (valueAsBoolean == false) return;
                dataFactory.setFlag((IKey)role);
                return;
            }
            if (!roleType.isProperty()) {
                if (!roleType.isChild()) throw new EXUnknownFlagOrPropertyOrChildRoleForStructuredData((IKey)role);
            }
            List<Object> values = this.getAll(key);
            if (roleType.isProperty() && values.size() > 1) {
                throw new EXDataCreationFailed((Exception)new IllegalArgumentException("Property " + key + " contains more than one values."));
            }
            Iterator<Object> iterator = values.iterator();
            while (true) {
                IDataType dataTypeOfPropertyOrChildren;
                if (!iterator.hasNext()) {
                    return;
                }
                Object value = iterator.next();
                if (value == null) {
                    Object propertyOrChild = dataType.createNullDataElement();
                    dataFactory.addPropertyOrChild((IKey)role, propertyOrChild);
                    continue;
                }
                if (value instanceof String) {
                    String valueAsString = (String)value;
                    dataTypeOfPropertyOrChildren = dataFactory.getDataTypeOfPropertyOrChildren((IKey)role);
                    if (!IElementaryDataType.class.isAssignableFrom(dataTypeOfPropertyOrChildren.getStructureType())) throw new EXDataCreationFailed((Exception)new IllegalArgumentException("Value of structured data type is of type String instead of Record"));
                    IDataType concreteDataTypeOfDataTypeOfPropertyOrChildren = dataTypeOfPropertyOrChildren.getConcreteDataType();
                    IElementaryDataType elementaryDataTypeOfPropertyOrChildren = (IElementaryDataType)concreteDataTypeOfDataTypeOfPropertyOrChildren;
                    Object propertyOrChild = Record.decodeNonNullElementaryData(valueAsString, elementaryDataTypeOfPropertyOrChildren);
                    dataFactory.addPropertyOrChild((IKey)role, propertyOrChild);
                    continue;
                }
                if (!(value instanceof IRecord)) throw new EXDataCreationFailed((Exception)new IllegalArgumentException("Value is neither String nor Record"));
                Record valueAsRecord = (Record)value;
                dataTypeOfPropertyOrChildren = dataFactory.getDataTypeOfPropertyOrChildren((IKey)role);
                Object propertyOrChild = valueAsRecord.decodeNonNullData(dataTypeOfPropertyOrChildren);
                dataFactory.addPropertyOrChild((IKey)role, propertyOrChild);
            }
        }
        catch (EXUnknownFlagOrPropertyOrChildRoleForStructuredData exception) {
            boolean erroneousFlagOrPropertyOrChildToIgnore = dataFactory.isErroneousFlagOrPropertyOrChildToIgnore((IKey)role, (EXDataLoadingException)exception);
            if (erroneousFlagOrPropertyOrChildToIgnore) return;
            throw new EXDataCreationFailed((Exception)((Object)exception));
        }
        catch (EXDataCreationFailed exception) {
            boolean erroneousFlagOrPropertyOrChildToIgnore = dataFactory.isErroneousFlagOrPropertyOrChildToIgnore((IKey)role, (EXDataLoadingException)exception);
            if (erroneousFlagOrPropertyOrChildToIgnore) return;
            throw exception;
        }
        catch (EXDataAssemblingFailed exception) {
            boolean erroneousFlagOrPropertyOrChildToIgnore = dataFactory.isErroneousFlagOrPropertyOrChildToIgnore((IKey)role, (EXDataLoadingException)exception);
            if (erroneousFlagOrPropertyOrChildToIgnore) return;
            throw new EXDataCreationFailed((Exception)((Object)exception));
        }
    }

    private static Object decodeNonNullElementaryData(String value, IElementaryDataType dataType) throws EXDataCreationFailed {
        IElementaryDataFactory dataFactory = dataType.createDataFactory();
        dataFactory.setCharacters(value);
        Object data = dataFactory.createDataElement();
        return data;
    }

    public IXMLElementWO createRootElement(IList_<XMLProcessingInstruction> rootProcessingInstructions, XMLElementName elementName, IList_<XMLAttribute> attributes) {
        this.addAll(ROOT_PROCESSING_INSTRUCTION_KEY, rootProcessingInstructions.asJavaList());
        IRecord parent = null;
        this.init(elementName, attributes, parent);
        return this;
    }

    private void init(XMLElementName xmlElementName, IList_<XMLAttribute> attributes, IRecord parentElement) {
        Object nameSpaceObject;
        String elementName = xmlElementName.getElementName();
        this.set(ELEMENT_NAME_KEY, elementName);
        String nameSpace = xmlElementName.getNameSpace();
        String parentNameSpace = parentElement != null ? ((nameSpaceObject = parentElement.get(nameSpace)) != null && nameSpaceObject instanceof String ? (String)nameSpaceObject : null) : null;
        if (!(nameSpace == null || parentNameSpace != null && parentNameSpace.equals(nameSpace))) {
            this.set(NAMESPACE_KEY, nameSpace);
        } else {
            this.reset(NAMESPACE_KEY);
        }
        for (XMLAttribute attribute : attributes) {
            XMLAttributeName xmlAttributeName = attribute.getAttributeName();
            XMLAttributeValue xmlAttributeValue = attribute.getAttributeValue();
            this.setXMLAttribute(xmlAttributeName, xmlAttributeValue);
        }
    }

    private void setXMLAttribute(XMLAttributeName xmlAttributeName, XMLAttributeValue xmlAttributeValue) {
        String attributeName = xmlAttributeName.getAttributeName();
        String attributeValue = xmlAttributeValue.getRawStringValue();
        this.set(String.valueOf(ATTRIBUTE_KEY_PREFIX) + attributeName, attributeValue);
    }

    public IXMLElementWO createChildElement(XMLElementName elementName, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        Record record = new Record(this.graphicsAndFilesHelper, this.locale);
        Record parentRecord = this;
        record.init(elementName, attributes, parentRecord);
        this.add(CONTENT_KEY, record);
        return record;
    }

    public void characters(String characters) throws EXXMLDecodingFailed {
        this.add(CONTENT_KEY, characters);
    }

    public void processingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLDecodingFailed {
        this.add(CONTENT_KEY, processingInstruction);
    }

    public void endElement() throws EXXMLDecodingFailed {
    }

    public IList_<XMLProcessingInstruction> getRootProcessingInstructions() {
        List<Object> rootProcessingInstructionsAsJavaList = this.getAll(ROOT_PROCESSING_INSTRUCTION_KEY);
        ArrayList_ rootProcessingInstructions = new ArrayList_(rootProcessingInstructionsAsJavaList.size());
        for (Object rootProcessingInstructionObject : rootProcessingInstructionsAsJavaList) {
            XMLProcessingInstruction rootProcessingInstruction = (XMLProcessingInstruction)rootProcessingInstructionObject;
            rootProcessingInstructions.add((Object)rootProcessingInstruction);
        }
        return rootProcessingInstructions;
    }

    public XMLElementName getElementName() {
        String elementName = (String)this.get(ELEMENT_NAME_KEY);
        String namespace = (String)this.get(NAMESPACE_KEY);
        XMLElementName xmlElementName = new XMLElementName(namespace, elementName);
        return xmlElementName;
    }

    public IList_<XMLAttribute> getAttributes() {
        ArrayList_ attributes = new ArrayList_();
        for (String key : this.getKeySet()) {
            if (!key.startsWith(ATTRIBUTE_KEY_PREFIX)) continue;
            XMLAttributeName attributeName = new XMLAttributeName(key.substring(ATTRIBUTE_KEY_PREFIX.length()));
            XMLAttributeValue attributeValue = new XMLAttributeValue((String)this.get(key));
            XMLAttribute attribute = new XMLAttribute(attributeName, attributeValue);
            attributes.add((Object)attribute);
        }
        return attributes;
    }

    public IList_<IXMLItemRO> getChildItems() {
        ArrayList_ contents = new ArrayList_();
        for (Object content : this.getAll(CONTENT_KEY)) {
            if (content instanceof String) {
                String characters = (String)content;
                contents.add((Object)new XMLCharacters(characters));
                continue;
            }
            if (content instanceof Record) {
                Record child = (Record)content;
                contents.add((Object)child);
                continue;
            }
            if (!(content instanceof XMLProcessingInstruction)) continue;
            XMLProcessingInstruction processingInstruction = (XMLProcessingInstruction)content;
            contents.add((Object)new XMLProcessingInstructionItem(processingInstruction));
        }
        return contents;
    }
}

