/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.ElementPresentationRule;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.Link;
import com.arcway.cockpit.docgen.provider.PlanDocGenProxy;
import com.arcway.cockpit.docgen.provider.PlanPresentationRule;
import com.arcway.cockpit.docgen.provider.ProjectDocGenProxy;
import com.arcway.cockpit.docgen.provider.SectionDocGenProxy;
import com.arcway.cockpit.docgen.provider.StakeholderDocGenProxy;
import com.arcway.cockpit.docgen.provider.StakeholderRoleDocGenProxy;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.UniqueElementTypeDescription;
import com.arcway.cockpit.docgen.provider.interfaces.IElementPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.ILink;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElementTypeDescription;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.IProject;
import com.arcway.cockpit.docgen.provider.interfaces.IProjectDataProvider;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.docgen.provider.utils.PlanComparator;
import com.arcway.cockpit.docgen.provider.utils.StakeholderComparator;
import com.arcway.cockpit.docgen.provider.utils.StakeholderRoleComparator;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectDataReportProvider
implements IProjectRelatedReportProvider,
IProjectDataProvider {
    private IProjectRelatedReportContext reportContext;
    private Locale projectLocale;
    private IWorkbenchPage currentPage;

    @Override
    public void setup(IProjectRelatedReportContext reportContext) {
        this.reportContext = reportContext;
        this.projectLocale = new Locale(reportContext.getProjectAgent().getLanguageID());
        this.currentPage = reportContext.getCurrentPage();
    }

    public Collection<AbstractFilter> getFilters() {
        return this.reportContext.getFilterCollection();
    }

    @Override
    public IProject getProject() {
        return new ProjectDocGenProxy(this.reportContext.getProjectAgent().getProject(), this.reportContext.getProjectAgent(), this.reportContext.getFilterCollection(), this.getPlanGraphicsProvider(), this.projectLocale, this.reportContext.getPresentationContext(), this.currentPage);
    }

    @Override
    public Collection<IModelElementTypeDescription> getModelElementTypes() {
        return Arrays.asList(this.getUniqueElementTypes());
    }

    private GraphicsAndFilesHelper getPlanGraphicsProvider() {
        return this.reportContext.getGraphicsProvider();
    }

    @Deprecated
    public String getName() {
        String result = null;
        result = HTMLEncoder.encode((String)this.reportContext.getProjectAgent().getProjectName());
        return result;
    }

    @Deprecated
    public String[] getDescription() {
        String description = this.reportContext.getProjectAgent().getProjectDescription();
        List descriptionList = StringUtil.splitTextLines((String)description);
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        String[] result = resultAsList.toArray(new String[resultAsList.size()]);
        return result;
    }

    @Deprecated
    public SectionDocGenProxy getRootSection() {
        return ((ProjectDocGenProxy)this.getProject()).getRootSection();
    }

    @Deprecated
    public PlanDocGenProxy[] getAllPlans() {
        ArrayList plans = new ArrayList(this.reportContext.getProjectAgent().getAllPlans(this.reportContext.getFilterCollection()));
        Collections.sort(plans, new PlanComparator());
        PlanDocGenProxy[] result = new PlanDocGenProxy[plans.size()];
        int counter = 0;
        for (IPlan plan : plans) {
            PlanDocGenProxy planDescription;
            result[counter] = planDescription = new PlanDocGenProxy(plan, this.reportContext.getProjectAgent(), this.reportContext.getFilterCollection(), this.getPlanGraphicsProvider(), this.projectLocale, this.currentPage);
            ++counter;
        }
        return result;
    }

    @Deprecated
    public UniqueElementDocGenProxy[] getAllUniqueElements() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.reportContext.getProjectAgent().getAllUniqueElements(this.reportContext.getFilterCollection()));
        return this.getUniqueElementDocGenProxyArray(uniqueElements, null);
    }

    @Deprecated
    public UniqueElementDocGenProxy[] getAllUniqueElements(String typeID) {
        assert (typeID != null) : "typeID must not be null";
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.reportContext.getProjectAgent().getAllUniqueElements(this.reportContext.getFilterCollection()));
        return this.getUniqueElementDocGenProxyArray(uniqueElements, typeID);
    }

    private UniqueElementDocGenProxy[] getUniqueElementDocGenProxyArray(List<IUniqueElement> uniqueElements, String typeID) {
        List<IModelElement> docGenProxies = UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, typeID, this.reportContext.getProjectAgent(), this.reportContext.getFilterCollection(), this.getPlanGraphicsProvider(), this.projectLocale, this.currentPage);
        return docGenProxies.toArray(new UniqueElementDocGenProxy[docGenProxies.size()]);
    }

    @Deprecated
    public StakeholderDocGenProxy[] getAllStakeholders() {
        ArrayList stakeholders = new ArrayList(this.reportContext.getProjectAgent().getStakeholders());
        Collections.sort(stakeholders, new StakeholderComparator());
        StakeholderDocGenProxy[] result = new StakeholderDocGenProxy[stakeholders.size()];
        int counter = 0;
        for (IStakeholder stakeholder : stakeholders) {
            StakeholderDocGenProxy stakeholderProxy;
            result[counter] = stakeholderProxy = new StakeholderDocGenProxy(stakeholder, this.reportContext.getProjectAgent(), this.getPlanGraphicsProvider(), this.reportContext.getFilterCollection(), this.projectLocale);
            ++counter;
        }
        return result;
    }

    @Deprecated
    public StakeholderRoleDocGenProxy[] getAllStakeholderRoles() {
        ArrayList stakeholderRoles = new ArrayList(this.reportContext.getProjectAgent().getRoles());
        Collections.sort(stakeholderRoles, new StakeholderRoleComparator());
        StakeholderRoleDocGenProxy[] result = new StakeholderRoleDocGenProxy[stakeholderRoles.size()];
        int counter = 0;
        for (IStakeholderRole stakeholderRole : stakeholderRoles) {
            StakeholderRoleDocGenProxy stakeholderRoleProxy;
            result[counter] = stakeholderRoleProxy = new StakeholderRoleDocGenProxy(stakeholderRole, this.reportContext.getProjectAgent(), this.getPlanGraphicsProvider(), this.reportContext.getFilterCollection(), this.projectLocale);
            ++counter;
        }
        return result;
    }

    @Deprecated
    public IModelElementTypeDescription[] getUniqueElementTypes() {
        return this.getConstructionElementTypes();
    }

    @Deprecated
    public UniqueElementTypeDescription[] getConstructionElementTypes() {
        List typeList = ExtensionMgr.getDefault().getCurrentConstructionElementTypes();
        UniqueElementTypeDescription[] typeDescriptions = new UniqueElementTypeDescription[typeList.size()];
        int i = 0;
        while (i < typeList.size()) {
            typeDescriptions[i] = new UniqueElementTypeDescription((IConstructionElementTypeDescription)typeList.get(i), this.projectLocale);
            ++i;
        }
        return typeDescriptions;
    }

    @Deprecated
    public SectionDocGenProxy findSection(String sectionPath) {
        return (SectionDocGenProxy)this.getProject().findFolder(sectionPath);
    }

    @Override
    public ILink createLink(String href, String title, String show, String target) {
        return new Link(href, title, show, target);
    }

    @Override
    public IPlanPresentationRule createPlanPresentationRule() {
        return new PlanPresentationRule();
    }

    @Override
    public IElementPresentationRule createElementPresentationRule() {
        return new ElementPresentationRule();
    }

    @Override
    public String generateUID() {
        return UUIDGenerator.getUniqueID();
    }
}

