/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.interfaces.IElementPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.ILink;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.lib.geometry.Dimension;
import java.util.Collection;
import java.util.Map;

public class PlanPresentationRule
implements IPlanPresentationRule {
    private String role = null;
    private String individualVersionName = null;
    private Double zoom = null;
    private double offsetXinMM = 0.0;
    private double offsetYinMM = 0.0;
    private Dimension sizeInMM;
    private boolean withMetaInformation = false;
    private boolean withComments = true;
    private String styleSheetFilename = null;
    private Map<String, ILink> linkMap = null;
    private Map<String, IElementPresentationRule> elementPresentationRules = null;
    private boolean isElementPresentationRulesReferToModelElementUIDs = true;
    private String attributeIDForReplacedPlanElementName = null;
    private String attributeIDForReplacedPlanElementDescription = null;
    private String attributeIDForReplacedPlanElementComment = null;
    private double angle = 0.0;
    private Collection<String> planElementUIDsToHide = null;
    private IRecord planElementsToAdd = null;
    private double translationXOfPlanElementsToAdd = 0.0;
    private double translationYOfPlanElementsToAdd = 0.0;
    private double anchoringToleranceOfPlanElementsToAdd = 0.0;

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public void setIndividualVersionName(String individualVersionName) {
        this.individualVersionName = individualVersionName;
    }

    @Override
    public String getIndividualVersionName() {
        return this.individualVersionName;
    }

    @Override
    public void setZoom(double zoom, double offsetXinMM, double offsetYInMM) {
        this.zoom = zoom;
        this.offsetXinMM = offsetXinMM;
        this.offsetYinMM = offsetYInMM;
    }

    @Override
    public void resetZoom() {
        this.zoom = null;
        this.offsetXinMM = 0.0;
        this.offsetYinMM = 0.0;
    }

    @Override
    public Double getZoom() {
        return this.zoom;
    }

    @Override
    public double getOffsetXinMM() {
        return this.offsetXinMM;
    }

    @Override
    public double getOffsetYinMM() {
        return this.offsetYinMM;
    }

    @Override
    public void setSizeInMM(double w, double h) {
        this.sizeInMM = new Dimension(w, h);
    }

    @Override
    public Double getWidthInMM() {
        return this.sizeInMM == null ? null : Double.valueOf(this.sizeInMM.width);
    }

    @Override
    public Double getHeightInMM() {
        return this.sizeInMM == null ? null : Double.valueOf(this.sizeInMM.height);
    }

    @Override
    public void resetSize() {
        this.sizeInMM = null;
    }

    @Override
    public void setWithMetaInformation(boolean withMetaInformation) {
        this.withMetaInformation = withMetaInformation;
    }

    @Override
    public boolean isWithMetaInformation() {
        return this.withMetaInformation;
    }

    @Override
    public void setWithComments(boolean withComments) {
        this.withComments = withComments;
    }

    @Override
    public boolean isWithComments() {
        return this.withComments;
    }

    @Override
    public void setStyleSheetFilename(String styleSheetFilename) {
        this.styleSheetFilename = styleSheetFilename;
    }

    @Override
    public String getStyleSheetFilename() {
        return this.styleSheetFilename;
    }

    @Override
    public void setLinkMap(Map<String, ILink> linkMap) {
        this.linkMap = linkMap;
    }

    @Override
    public Map<String, ILink> getLinkMap() {
        return this.linkMap;
    }

    @Override
    public void setElementPresentationRules(Map<String, IElementPresentationRule> elementPresentationRules) {
        this.elementPresentationRules = elementPresentationRules;
    }

    @Override
    public Map<String, IElementPresentationRule> getElementPresentationRules() {
        return this.elementPresentationRules;
    }

    @Override
    public void setElementPresentationRuleUIDsArePlanElementUIDs() {
        this.isElementPresentationRulesReferToModelElementUIDs = false;
    }

    @Override
    public void setElementPresentationRuleUIDsAreModelElementUIDs() {
        this.isElementPresentationRulesReferToModelElementUIDs = true;
    }

    @Override
    public boolean isElementPresentationRulesReferToModelElementUIDs() {
        return this.isElementPresentationRulesReferToModelElementUIDs;
    }

    @Override
    public void setAttributeIDForReplacedPlanElementName(String attributeIDForReplacedPlanElementName) {
        this.attributeIDForReplacedPlanElementName = attributeIDForReplacedPlanElementName;
    }

    @Override
    public String getAttributeIDForReplacedPlanElementName() {
        return this.attributeIDForReplacedPlanElementName;
    }

    @Override
    public void setAttributeIDForReplacedPlanElementDescription(String attributeIDForReplacedPlanElementDescription) {
        this.attributeIDForReplacedPlanElementDescription = attributeIDForReplacedPlanElementDescription;
    }

    @Override
    public String getAttributeIDForReplacedPlanElementDescription() {
        return this.attributeIDForReplacedPlanElementDescription;
    }

    @Override
    public void setAttributeIDForReplacedPlanElementComment(String globalElementPropertyID) {
        this.attributeIDForReplacedPlanElementComment = globalElementPropertyID;
    }

    @Override
    public String getAttributeIDForReplacedPlanElementComment() {
        return this.attributeIDForReplacedPlanElementComment;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    public void setHiddenPlanElementUIDs(Collection<String> planElementUIDs) {
        this.planElementUIDsToHide = planElementUIDs;
    }

    public Collection<String> getHiddenPlanElementUIDs() {
        return this.planElementUIDsToHide;
    }

    public void setPlanElementsToAdd(IRecord planToAdd, double translationX, double translationY, double anchoringTolerance) {
        this.planElementsToAdd = planToAdd;
        this.translationXOfPlanElementsToAdd = translationX;
        this.translationYOfPlanElementsToAdd = translationY;
        this.anchoringToleranceOfPlanElementsToAdd = anchoringTolerance;
    }

    public void resetPlanElementsToAdd() {
        this.planElementsToAdd = null;
        this.translationXOfPlanElementsToAdd = 0.0;
        this.translationYOfPlanElementsToAdd = 0.0;
        this.anchoringToleranceOfPlanElementsToAdd = 0.0;
    }

    public IRecord getPlanElementsToAdd() {
        return this.planElementsToAdd;
    }

    public double getTranslationXOfPlanElementsToAdd() {
        return this.translationXOfPlanElementsToAdd;
    }

    public double getTranslationYOfPlanElementsToAdd() {
        return this.translationYOfPlanElementsToAdd;
    }

    public double getAnchoringToleranceOfPlanElementsToAdd() {
        return this.anchoringToleranceOfPlanElementsToAdd;
    }
}

