/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractGraphicsProvidingDocGenProxy;
import com.arcway.cockpit.docgen.provider.DocGenColor;
import com.arcway.cockpit.docgen.provider.DocGenRectangle;
import com.arcway.cockpit.docgen.provider.ElementPresentationRule;
import com.arcway.cockpit.docgen.provider.HighlightRequest;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.PlanElementInfo;
import com.arcway.cockpit.docgen.provider.PlanInfo;
import com.arcway.cockpit.docgen.provider.PlanPresentationRule;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.SectionDocGenProxy;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IElementPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.IFolder;
import com.arcway.cockpit.docgen.provider.interfaces.ILink;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IPlan;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanElementInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanPresentationRule;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.interfaces.IRectangle;
import com.arcway.cockpit.docgen.provider.interfaces.IRequestFlowInfo;
import com.arcway.cockpit.docgen.provider.interfaces.ITextInfo;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.docgen.provider.planagent.PlanExporterControllerExtension;
import com.arcway.cockpit.docgen.provider.planagent.PlanLoader;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planagents.PlanElementsCreationRequest;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.XMLCoDec;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementRequestFlowInfo;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementTextInfo;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IPlanDataProvider;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import de.plans.lib.util.HTMLEncoder;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class PlanDocGenProxy
extends AbstractGraphicsProvidingDocGenProxy
implements IPlan {
    private static final ILogger logger = Logger.getLogger(PlanDocGenProxy.class);
    private final IDocGeneratorProjectAgent projectAgent;
    private final com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan;
    private final Collection<AbstractFilter> filters;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public PlanDocGenProxy(com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper fileAttributeProvider, Locale locale, IWorkbenchPage currentPage) {
        super((IAttributeOwner)plan, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.plan = plan;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.plan.getUID();
    }

    @Override
    public String getTypeID() {
        return "plan";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"com.arcway.cockpit.plan")).getDisplayName(this.locale);
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.plan.getPlanName());
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.plan.getDescription());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.plan.getPlanName());
    }

    @Override
    public String getPlanType() {
        return HTMLEncoder.encode((String)this.plan.getPlantypeUID());
    }

    @Override
    public IFolder getFolder() {
        ISection parent = this.projectAgent.getParent(this.plan, this.filters);
        if (parent != null) {
            return new SectionDocGenProxy(parent, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return null;
    }

    @Override
    public List<? extends IFolder> getAllFolders() {
        List parents = this.projectAgent.getParentsOfPlan(this.plan, this.filters);
        ArrayList<SectionDocGenProxy> result = new ArrayList<SectionDocGenProxy>(parents.size());
        for (ISection parent : parents) {
            SectionDocGenProxy sectionDescription = new SectionDocGenProxy(parent, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            result.add(sectionDescription);
        }
        return result;
    }

    @Deprecated
    public IFolder getParent() {
        return this.getFolder();
    }

    @Deprecated
    public List<? extends IFolder> getAllParents() {
        return this.getAllFolders();
    }

    public List<IModelElement> getAllModelElements() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUEForPlan(this.plan, this.filters));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getLeafModelElementsOfCausalityRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getLastUniqueElementsOnPlan(this.plan.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getLeafModelElementsOfContainmentRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getLastUniqueElementsOnPlan(this.plan.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getRootModelElementsOfCausalityRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getFirstUniqueElementsOnPlan(this.plan.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getRootModelElementsOfContainmentRelationship() {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getFirstUniqueElementsOnPlan(this.plan.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(uniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    @Deprecated
    public IModelElement[] getContainedUniqueElements() {
        return this.getAllModelElements().toArray(new IModelElement[0]);
    }

    @Deprecated
    public List<IModelElement> getContainedRootUniqueElements() {
        return this.getRootModelElementsOfContainmentRelationship();
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.plan.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.plan.getAttribute(attrType);
        if (attribute != null && (attributeType = this.plan.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.plan.getModificationCount());
    }

    @Override
    public void open() {
        this.openWithPresentationRule(null);
    }

    @Override
    public void openWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        if (this.currentPage != null) {
            PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
            PlanDisplayParameters planDisplayParameters = this.calculatePlanDisplayParameters(planPresentationRule_);
            Collection openEditors = this.projectAgent.openProjector(this.plan, this.currentPage, planDisplayParameters);
            for (IExternalPlanEditorControllerExtension openEditor : openEditors) {
                Collection highlightRequests = planDisplayParameters.getHighlightRequests();
                openEditor.highlightElements(HighlightLevel.BUSINESS, highlightRequests);
                List projectionRequests = planDisplayParameters.getProjectionRequests();
                if (projectionRequests.isEmpty()) {
                    openEditor.stopProjection();
                    continue;
                }
                List uniqueElementProjectionRequests = Collections.emptyList();
                openEditor.project(projectionRequests, uniqueElementProjectionRequests);
            }
        } else {
            logger.error("Cannot open plan " + this.plan.getPlanName() + ": No target window.");
        }
    }

    @Override
    protected IGraphicProvider createGraphicProvider() {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        return graphicProvider;
    }

    @Override
    public String getImage(Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getPNGFileWithMetaInformation() {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        return this.getPNGFile(planPresentationRule);
    }

    @Override
    public String getSVGFile(Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithMetaInformation() {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithMetaInformation(Map<String, ILink> linkMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithMetaInformation(Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getWMFFileWithMetaInformation() {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        return this.getWMFFile(planPresentationRule);
    }

    @Override
    public String getImageFileWithMetaInformation() {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getImageFileWithMetaInformation(Map<String, ILink> linkMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getImageFileWithMetaInformation(Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(true);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getPNGFile(boolean withMetaInformation, boolean withComments) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(withMetaInformation);
        planPresentationRule.setWithComments(withComments);
        return this.getPNGFile(planPresentationRule);
    }

    @Override
    public String getSVGFile(boolean withMetaInformation, boolean withComments) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(withMetaInformation);
        planPresentationRule.setWithComments(withComments);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getWMFFile(boolean withMetaInformation, boolean withComments) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(withMetaInformation);
        planPresentationRule.setWithComments(withComments);
        return this.getWMFFile(planPresentationRule);
    }

    @Override
    public String getImage(boolean withMetaInformation, boolean withComments) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setWithMetaInformation(withMetaInformation);
        planPresentationRule.setWithComments(withComments);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getImageFileWithReplacedPlanElementName(String globalElementPropertyID) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getImageFileWithReplacedPlanElementName(String globalElementPropertyID, Map<String, ILink> linkMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getImageFileWithReplacedPlanElementName(String globalElementPropertyID, Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getPNGFileWithReplacedPlanElementName(String globalElementPropertyID) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        return this.getPNGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithReplacedPlanElementName(String globalElementPropertyID) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithReplacedPlanElementName(String globalElementPropertyID, Map<String, ILink> linkMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithReplacedPlanElementName(String globalElementPropertyID, Map<String, ILink> linkMapOfRepresentedElements, Map<String, IElementPresentationRule> presentationMapOfRepresentedElements) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        planPresentationRule.setLinkMap(linkMapOfRepresentedElements);
        planPresentationRule.setElementPresentationRules(presentationMapOfRepresentedElements);
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getWMFFileWithReplacedPlanElementName(String globalElementPropertyID) {
        PlanPresentationRule planPresentationRule = new PlanPresentationRule();
        planPresentationRule.setAttributeIDForReplacedPlanElementName(globalElementPropertyID);
        return this.getWMFFile(planPresentationRule);
    }

    @Override
    public IPlanInfo getImageInfo(IPlanPresentationRule planPresentationRule) {
        ArrayList<IPlanElementInfo> arrayList;
        Rectangle viewSizeInMM;
        PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        if (graphicProvider.launch(IProgressDisplay.DUMMY)) {
            viewSizeInMM = graphicProvider.getViewSizeInMM();
            Collection ueForPlan = this.projectAgent.getUEForPlan(this.plan, this.filters);
            HashSet<String> ueUIDsForPlan = new HashSet<String>(ueForPlan.size() * 2);
            for (IUniqueElement iUniqueElement : ueForPlan) {
                ueUIDsForPlan.add(iUniqueElement.getUID());
            }
            Map unfilteredPlanElementUIDs2UEUIDForPlan = this.projectAgent.getUnfilteredPlanElementUIDs2UEUIDForPlan(this.plan);
            HashMap<String, String> planElementUIDs2UEUIDForPlan = new HashMap<String, String>(unfilteredPlanElementUIDs2UEUIDForPlan.size() * 2);
            for (Map.Entry entry : unfilteredPlanElementUIDs2UEUIDForPlan.entrySet()) {
                String string = (String)entry.getKey();
                String ueUID = (String)entry.getValue();
                if (!ueUIDsForPlan.contains(ueUID)) continue;
                planElementUIDs2UEUIDForPlan.put(string, ueUID);
            }
            Map<String, IElementPresentationRule> presentationRulesForPresentationElements = this.calculatePresentationRulesForPresentationElements(planPresentationRule_);
            HashMap<String, PlanElementInfo> planElementUID2PlanElementInfo = new HashMap<String, PlanElementInfo>();
            Collection<? extends IPlanAgentStructuredPlanElement> collection = graphicProvider.getPlanStructure();
            for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : collection) {
                IProjection projection;
                String planElementUID = iPlanAgentStructuredPlanElement.getPlanElementUID();
                String planElementTypeID = iPlanAgentStructuredPlanElement.getPlanElementTypeID();
                String planElementName = iPlanAgentStructuredPlanElement.getPlanElementName();
                String planElementDesc = iPlanAgentStructuredPlanElement.getPlanElementDescription();
                String planElementAspectID = iPlanAgentStructuredPlanElement.getPlanElementAspectID();
                int topologyType = this.convertTopologyType(iPlanAgentStructuredPlanElement.getToplogyType());
                Rectangle planElementBoundsInMM = iPlanAgentStructuredPlanElement.getOuterBoundsInMM();
                Rectangle planElementProjectionArea = iPlanAgentStructuredPlanElement.getProjectionAreaInMM();
                IElementPresentationRule elementPresentationRule = presentationRulesForPresentationElements.get(planElementUID);
                if (elementPresentationRule != null && (projection = elementPresentationRule.getProjection()) != null) {
                    Point position = projection.getPosition(planElementProjectionArea);
                    GeoVector translation = new GeoVector(position);
                    Rectangle boundaryRelative = projection.getBoundary();
                    Rectangle boundaryAbsolute = boundaryRelative.move(translation);
                    planElementBoundsInMM = planElementBoundsInMM.union(boundaryAbsolute);
                }
                IRectangle outerBoundsInMM = PlanDocGenProxy.convertRectangle(planElementBoundsInMM);
                IRectangle pointUnionInMM = PlanDocGenProxy.convertRectangle(iPlanAgentStructuredPlanElement.getPointUnionInMM());
                IRectangle projectionAreaInMM = PlanDocGenProxy.convertRectangle(planElementProjectionArea);
                boolean isComment = iPlanAgentStructuredPlanElement.isComment();
                Collection<? extends ITextInfo> textInfos = PlanDocGenProxy.convertTextInfos(iPlanAgentStructuredPlanElement.getTextInfos());
                Collection<? extends IRequestFlowInfo> requestFlowInfos = PlanDocGenProxy.convertRequestFlowInfos(iPlanAgentStructuredPlanElement.getRequestFlowInfos());
                PlanElementInfo planElementInfo = new PlanElementInfo(planElementUID, planElementTypeID, planElementName, planElementDesc, planElementAspectID, topologyType, outerBoundsInMM, pointUnionInMM, projectionAreaInMM, isComment, textInfos, requestFlowInfos);
                String uniqueElementUID = (String)planElementUIDs2UEUIDForPlan.get(planElementUID);
                if (uniqueElementUID != null) {
                    planElementInfo.setModelElementUID(uniqueElementUID);
                }
                planElementUID2PlanElementInfo.put(planElementUID, planElementInfo);
            }
            arrayList = new ArrayList<IPlanElementInfo>(collection.size());
            for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : collection) {
                String planElementUID = iPlanAgentStructuredPlanElement.getPlanElementUID();
                PlanElementInfo planElementInfo = (PlanElementInfo)planElementUID2PlanElementInfo.get(planElementUID);
                planElementInfo.setContainers(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getContainers(), planElementUID2PlanElementInfo));
                planElementInfo.setContainedPlanElements(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getContainedPlanElements(), planElementUID2PlanElementInfo));
                planElementInfo.setPredecessors(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getPredecessors(), planElementUID2PlanElementInfo));
                planElementInfo.setSuccessors(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getSuccessors(), planElementUID2PlanElementInfo));
                planElementInfo.setReaders(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getReaders(), planElementUID2PlanElementInfo));
                planElementInfo.setWriters(PlanDocGenProxy.convertPlanElementInfos(iPlanAgentStructuredPlanElement.getWriters(), planElementUID2PlanElementInfo));
                arrayList.add(planElementInfo);
            }
        } else {
            logger.warn("Determination of graphic size failed - could not launch graphic provider");
            throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesHelper.GraphicCreationFailedMessage"));
        }
        FlowType flowType = graphicProvider.getFlowType();
        PlanInfo planInfo = new PlanInfo(viewSizeInMM, arrayList, flowType);
        graphicProvider.close();
        graphicProvider.dispose();
        return planInfo;
    }

    public int convertTopologyType(TopologyType topologyType) {
        switch (topologyType) {
            case FLAT: {
                return 0;
            }
            case DEEP: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final String getLinkForShow(IPlanPresentationRule planPresentationRule) {
        PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
        HashMap<String, PlanDisplayParameters> parameters = new HashMap<String, PlanDisplayParameters>();
        if (planPresentationRule_ != null) {
            PlanDisplayParameters planDisplayParameters = this.calculatePlanDisplayParameters(planPresentationRule_);
            parameters.put("planDisplayParameters", planDisplayParameters);
        }
        return HTMLEncoder.encode((String)ICOCKPITEclipseClientController.INSTANCE.getLinkForShow((ICockpitProjectData)this.getWrappedAttributeOwner(), parameters, this.getGraphicsAndFilesHelper().getTinyizeContext()).toString());
    }

    private static final Collection<? extends ITextInfo> convertTextInfos(Collection<? extends IPlanElementTextInfo> planElementTextInfos) {
        ArrayList<1> textInfos = new ArrayList<1>(planElementTextInfos.size());
        for (IPlanElementTextInfo iPlanElementTextInfo : planElementTextInfos) {
            List text = StringUtil.splitTextLines((String)iPlanElementTextInfo.getText());
            boolean isEmpty = true;
            for (String line : text) {
                if (line.trim().length() <= 0) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) continue;
            final List<String> textHTMLEncoded = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(text);
            final String role = iPlanElementTextInfo.getRole();
            final double height = iPlanElementTextInfo.getTextLineHeight();
            ITextInfo textInfo = new ITextInfo(){

                @Override
                public String getRole() {
                    return role;
                }

                @Override
                public List<String> getText() {
                    return textHTMLEncoded;
                }

                @Override
                public double getTextLineHeight() {
                    return height;
                }
            };
            textInfos.add(textInfo);
        }
        return textInfos;
    }

    private static final Collection<? extends IRequestFlowInfo> convertRequestFlowInfos(Collection<? extends IPlanElementRequestFlowInfo> planElementRequestFlowInfos) {
        ArrayList<2> requestFlowInfos = new ArrayList<2>(planElementRequestFlowInfos.size());
        for (IPlanElementRequestFlowInfo iPlanElementRequestFlowInfo : planElementRequestFlowInfos) {
            final String role = iPlanElementRequestFlowInfo.getRole();
            final int angle = iPlanElementRequestFlowInfo.getDirection().toInteger();
            IRequestFlowInfo requesFlowInfo = new IRequestFlowInfo(){

                @Override
                public String getRole() {
                    return role;
                }

                @Override
                public int getAngleInDegrees() {
                    return angle;
                }
            };
            requestFlowInfos.add(requesFlowInfo);
        }
        return requestFlowInfos;
    }

    private static final List<? extends IPlanElementInfo> convertPlanElementInfos(List<? extends IPlanAgentStructuredPlanElement> originalPlanElements, Map<String, PlanElementInfo> planElementUID2PlanElementInfo) {
        ArrayList<PlanElementInfo> planElementInfos = new ArrayList<PlanElementInfo>(originalPlanElements.size());
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : originalPlanElements) {
            String planElementUID = iPlanAgentStructuredPlanElement.getPlanElementUID();
            PlanElementInfo planElementInfo = planElementUID2PlanElementInfo.get(planElementUID);
            planElementInfos.add(planElementInfo);
        }
        return planElementInfos;
    }

    public static final IRectangle convertRectangle(Rectangle rectangle) {
        DocGenRectangle targetRectangle = rectangle == null ? null : new DocGenRectangle(rectangle);
        return targetRectangle;
    }

    @Override
    public String getImageWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        return this.getImage(planPresentationRule);
    }

    @Override
    public String getPNGFileWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        return this.getPNGFile(planPresentationRule);
    }

    @Override
    public String getSVGFileWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        return this.getSVGFile(planPresentationRule);
    }

    @Override
    public String getWMFFileWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        return this.getWMFFile(planPresentationRule);
    }

    @Override
    public String getEMFFileWithPresentationRule(IPlanPresentationRule planPresentationRule) {
        return this.getEMFFile(planPresentationRule);
    }

    private String getImage(IPlanPresentationRule planPresentationRule) {
        PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        ForcedViewRectangle forcedViewRectangle = ForcedViewRectangle.convert(planPresentationRule);
        Map<String, String> roleMap = this.createRoleMapOfRepresentedElements(planPresentationRule_);
        String styleSheetFilename = planPresentationRule_.getStyleSheetFilename();
        boolean isElementPresentationRulesReferToModelElementUIDs = planPresentationRule_.isElementPresentationRulesReferToModelElementUIDs();
        boolean representedElementsArePresentationElements = !isElementPresentationRulesReferToModelElementUIDs;
        String imageText = this.getImageInternal(graphicProvider, roleMap, styleSheetFilename, planPresentationRule_.getLinkMap(), representedElementsArePresentationElements, forcedViewRectangle);
        graphicProvider.dispose();
        return imageText;
    }

    private String getPNGFile(IPlanPresentationRule planPresentationRule) {
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        ForcedViewRectangle forcedViewRectangle = ForcedViewRectangle.convert(planPresentationRule);
        String imageText = this.getPNGImage(graphicProvider, forcedViewRectangle);
        graphicProvider.dispose();
        return imageText;
    }

    private String getSVGFile(IPlanPresentationRule planPresentationRule) {
        PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        ForcedViewRectangle forcedViewRectangle = ForcedViewRectangle.convert(planPresentationRule);
        Map<String, String> roleMap = this.createRoleMapOfRepresentedElements(planPresentationRule_);
        String styleSheetFilename = planPresentationRule_.getStyleSheetFilename();
        boolean isElementPresentationRulesReferToModelElementUIDs = planPresentationRule_.isElementPresentationRulesReferToModelElementUIDs();
        boolean representedElementsArePresentationElements = !isElementPresentationRulesReferToModelElementUIDs;
        String imageText = this.getSVGImageInternal(graphicProvider, roleMap, styleSheetFilename, planPresentationRule_.getLinkMap(), representedElementsArePresentationElements, forcedViewRectangle);
        graphicProvider.dispose();
        return imageText;
    }

    private String getWMFFile(IPlanPresentationRule planPresentationRule) {
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        ForcedViewRectangle forcedViewRectangle = ForcedViewRectangle.convert(planPresentationRule);
        String imageText = this.getWMFImage(graphicProvider, forcedViewRectangle);
        graphicProvider.dispose();
        return imageText;
    }

    private String getEMFFile(IPlanPresentationRule planPresentationRule) {
        PlanExporterControllerExtension graphicProvider = this.createGraphicProvider(planPresentationRule);
        ForcedViewRectangle forcedViewRectangle = ForcedViewRectangle.convert(planPresentationRule);
        String imageText = this.getEMFImage(graphicProvider, forcedViewRectangle);
        graphicProvider.dispose();
        return imageText;
    }

    private Map<String, String> createRoleMapOfRepresentedElements(PlanPresentationRule planPresentationRule) {
        Map<String, IElementPresentationRule> elementPresentationRules;
        HashMap<String, String> roleMap = new HashMap<String, String>();
        String planRole = planPresentationRule.getRole();
        if (planRole != null) {
            String planUID = this.getUniqueIdentifier();
            roleMap.put(planUID, planRole);
        }
        if ((elementPresentationRules = planPresentationRule.getElementPresentationRules()) != null) {
            for (Map.Entry<String, IElementPresentationRule> entry : elementPresentationRules.entrySet()) {
                String elementID = entry.getKey();
                IElementPresentationRule elementPresentationRule = entry.getValue();
                ElementPresentationRule elementPresentationRule_ = (ElementPresentationRule)elementPresentationRule;
                String role = elementPresentationRule_.getRole();
                if (role == null) continue;
                roleMap.put(elementID, role);
            }
        }
        return roleMap;
    }

    @Override
    protected <T> Map<String, T> createMapOfPresentationElements(Map<String, T> mapOfRepresentedElements, boolean representedElementsArePresentationElements) {
        HashMap<Object, Object> mapOfPresentationElements;
        if (representedElementsArePresentationElements) {
            mapOfPresentationElements = new HashMap<String, T>(mapOfRepresentedElements);
        } else {
            mapOfPresentationElements = new HashMap();
            String planUID = this.getUniqueIdentifier();
            T planValue = mapOfRepresentedElements.get(planUID);
            if (planValue != null) {
                mapOfPresentationElements.put(planUID, planValue);
            }
            Map planElementUIDs2UEUID = this.projectAgent.getUnfilteredPlanElementUIDs2UEUIDForPlan(this.plan);
            for (Map.Entry planElementUID2UEUID : planElementUIDs2UEUID.entrySet()) {
                String uniqueElementUID = (String)planElementUID2UEUID.getValue();
                T value = mapOfRepresentedElements.get(uniqueElementUID);
                if (value == null) continue;
                String planElementUID = (String)planElementUID2UEUID.getKey();
                mapOfPresentationElements.put(planElementUID, value);
            }
        }
        return mapOfPresentationElements;
    }

    private PlanExporterControllerExtension createGraphicProvider(IPlanPresentationRule planPresentationRule) {
        PlanPresentationRule planPresentationRule_ = (PlanPresentationRule)planPresentationRule;
        boolean withMetaInformation = planPresentationRule_.isWithMetaInformation();
        boolean withComments = planPresentationRule_.isWithComments();
        double angle = planPresentationRule_.getAngle();
        PlanDisplayParameters planDisplayParameters = this.calculatePlanDisplayParameters(planPresentationRule_);
        PlanExporterControllerExtension graphicProvider = new PlanExporterControllerExtension(this.projectAgent, this.plan, planDisplayParameters, withMetaInformation, withComments, angle);
        return graphicProvider;
    }

    private PlanDisplayParameters calculatePlanDisplayParameters(PlanPresentationRule planPresentationRule_) {
        PlanDisplayParameters planDisplayParameters;
        if (planPresentationRule_ != null) {
            PlanElementsCreationRequest planElementsCreationRequest;
            String humanReadableIDForNameAttribute = planPresentationRule_.getAttributeIDForReplacedPlanElementName();
            IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute = null;
            if (humanReadableIDForNameAttribute != null) {
                IAttributeTypesProvider uniqueElementAttributeTypesProvider = this.projectAgent.getFrameDataAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
                for (IAttributeType attributeType : PlanAgentManager.getValidNameAttributeTypes((IAttributeTypesProvider)uniqueElementAttributeTypesProvider)) {
                    if (!attributeType.getHumanReadableID().equals(humanReadableIDForNameAttribute)) continue;
                    uniqueElementAttributeTypeIDofNameAttribute = attributeType.getAttributeTypeID();
                }
            }
            String humanReadableIDForDescriptionAttribute = planPresentationRule_.getAttributeIDForReplacedPlanElementDescription();
            IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute = null;
            if (humanReadableIDForDescriptionAttribute != null) {
                IAttributeTypesProvider uniqueElementAttributeTypesProvider = this.projectAgent.getFrameDataAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
                for (IAttributeType attributeType : PlanAgentManager.getValidDescriptionAttributeTypes((IAttributeTypesProvider)uniqueElementAttributeTypesProvider)) {
                    if (!attributeType.getHumanReadableID().equals(humanReadableIDForDescriptionAttribute)) continue;
                    uniqueElementAttributeTypeIDofDescriptionAttribute = attributeType.getAttributeTypeID();
                }
            }
            String humanReadableIDForCommentAttribute = planPresentationRule_.getAttributeIDForReplacedPlanElementComment();
            IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute = null;
            if (humanReadableIDForCommentAttribute != null) {
                IAttributeTypesProvider uniqueElementAttributeTypesProvider = this.projectAgent.getFrameDataAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
                for (IAttributeType attributeType : PlanAgentManager.getValidDescriptionAttributeTypes((IAttributeTypesProvider)uniqueElementAttributeTypesProvider)) {
                    if (!attributeType.getHumanReadableID().equals(uniqueElementAttributeTypeIDofCommentAttribute)) continue;
                    uniqueElementAttributeTypeIDofCommentAttribute = attributeType.getAttributeTypeID();
                }
            }
            Map<String, IElementPresentationRule> presentationRulesForPresentationElements = this.calculatePresentationRulesForPresentationElements(planPresentationRule_);
            Collection<? extends IHighlightRequest> highlightRequests = PlanDocGenProxy.createHighlightRequests(presentationRulesForPresentationElements);
            List<? extends IProjectionRequest> projectionRequests = PlanDocGenProxy.createProjectionRequests(presentationRulesForPresentationElements);
            String individualVersionName = planPresentationRule_.getIndividualVersionName();
            Map<String, String> planElementUID2individualNameReplacement = PlanDocGenProxy.createIndividualNameReplacements(presentationRulesForPresentationElements);
            Map<String, String> planElementUID2individualDescriptionReplacement = PlanDocGenProxy.createIndividualDescriptionReplacements(presentationRulesForPresentationElements);
            Map<String, String> planElementUID2individualCommentReplacement = PlanDocGenProxy.createIndividualCommentReplacements(presentationRulesForPresentationElements);
            Collection<String> planElementUIDsOfPlanElementsToDelete = planPresentationRule_.getHiddenPlanElementUIDs();
            IRecord planWithPlanElementsToCreateAsRecord = planPresentationRule_.getPlanElementsToAdd();
            if (planWithPlanElementsToCreateAsRecord != null) {
                PlanLoader planLoader = new PlanLoader(planWithPlanElementsToCreateAsRecord);
                GeoVector translation = new GeoVector(planPresentationRule_.getTranslationXOfPlanElementsToAdd(), planPresentationRule_.getTranslationYOfPlanElementsToAdd());
                double anchoringTolerance = planPresentationRule_.getAnchoringToleranceOfPlanElementsToAdd();
                planElementsCreationRequest = new PlanElementsCreationRequest((IPlanDataProvider)planLoader, translation, anchoringTolerance);
            } else {
                planElementsCreationRequest = null;
            }
            planDisplayParameters = new PlanDisplayParameters(uniqueElementAttributeTypeIDofNameAttribute, uniqueElementAttributeTypeIDofDescriptionAttribute, uniqueElementAttributeTypeIDofCommentAttribute, individualVersionName, planElementUID2individualNameReplacement, planElementUID2individualDescriptionReplacement, planElementUID2individualCommentReplacement, planElementUIDsOfPlanElementsToDelete, planElementsCreationRequest, highlightRequests, projectionRequests);
        } else {
            IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute = null;
            IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute = null;
            IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute = null;
            String individualVersionName = null;
            Map planElementUID2individualNameReplacement = null;
            Map planElementUID2individualDescriptionReplacement = null;
            Map planElementUID2individualCommentReplacement = null;
            Collection highlightRequests = null;
            List projectionRequests = null;
            Collection planElementUIDsOfPlanElementsToDelete = null;
            PlanElementsCreationRequest planElementsCreationRequest = null;
            planDisplayParameters = new PlanDisplayParameters(uniqueElementAttributeTypeIDofNameAttribute, uniqueElementAttributeTypeIDofDescriptionAttribute, uniqueElementAttributeTypeIDofCommentAttribute, individualVersionName, planElementUID2individualNameReplacement, planElementUID2individualDescriptionReplacement, planElementUID2individualCommentReplacement, planElementUIDsOfPlanElementsToDelete, planElementsCreationRequest, highlightRequests, projectionRequests);
        }
        return planDisplayParameters;
    }

    private Map<String, IElementPresentationRule> calculatePresentationRulesForPresentationElements(PlanPresentationRule planPresentationRule_) {
        Map<String, IElementPresentationRule> presentationRulesForRepresentedElements = planPresentationRule_.getElementPresentationRules();
        boolean isElementPresentationRulesReferToModelElementUIDs = planPresentationRule_.isElementPresentationRulesReferToModelElementUIDs();
        Map<String, IElementPresentationRule> presentationRulesForPresentationElements = this.createPresentationRulesForPresentationElements(presentationRulesForRepresentedElements, isElementPresentationRulesReferToModelElementUIDs);
        return presentationRulesForPresentationElements;
    }

    private static Map<String, String> createIndividualNameReplacements(Map<String, IElementPresentationRule> presentationRulesForPresentationElements) {
        HashMap<String, String> planElementUID2individualNameReplacement = new HashMap<String, String>();
        for (Map.Entry<String, IElementPresentationRule> presentationRuleForPresentationElements : presentationRulesForPresentationElements.entrySet()) {
            String planElementUID = presentationRuleForPresentationElements.getKey();
            IElementPresentationRule elementPresentationRule = presentationRuleForPresentationElements.getValue();
            ElementPresentationRule elementPresentationRule_ = (ElementPresentationRule)elementPresentationRule;
            String displayName = elementPresentationRule_.getDisplayName();
            if (displayName == null) continue;
            planElementUID2individualNameReplacement.put(planElementUID, displayName);
        }
        return planElementUID2individualNameReplacement;
    }

    private static Map<String, String> createIndividualDescriptionReplacements(Map<String, IElementPresentationRule> presentationRulesForPresentationElements) {
        HashMap<String, String> planElementUID2individualDescriptionReplacement = new HashMap<String, String>();
        for (Map.Entry<String, IElementPresentationRule> presentationRuleForPresentationElements : presentationRulesForPresentationElements.entrySet()) {
            String planElementUID = presentationRuleForPresentationElements.getKey();
            IElementPresentationRule elementPresentationRule = presentationRuleForPresentationElements.getValue();
            ElementPresentationRule elementPresentationRule_ = (ElementPresentationRule)elementPresentationRule;
            String description = elementPresentationRule_.getDescription();
            if (description == null) continue;
            planElementUID2individualDescriptionReplacement.put(planElementUID, description);
        }
        return planElementUID2individualDescriptionReplacement;
    }

    private static Map<String, String> createIndividualCommentReplacements(Map<String, IElementPresentationRule> presentationRulesForPresentationElements) {
        HashMap<String, String> planElementUID2individualDescriptionReplacement = new HashMap<String, String>();
        for (Map.Entry<String, IElementPresentationRule> presentationRuleForPresentationElements : presentationRulesForPresentationElements.entrySet()) {
            String planElementUID = presentationRuleForPresentationElements.getKey();
            IElementPresentationRule elementPresentationRule = presentationRuleForPresentationElements.getValue();
            ElementPresentationRule elementPresentationRule_ = (ElementPresentationRule)elementPresentationRule;
            String description = elementPresentationRule_.getComment();
            if (description == null) continue;
            planElementUID2individualDescriptionReplacement.put(planElementUID, description);
        }
        return planElementUID2individualDescriptionReplacement;
    }

    private static Collection<? extends IHighlightRequest> createHighlightRequests(Map<String, IElementPresentationRule> presentationRulesForPresentationElements) {
        ArrayList<IHighlightRequest> highlightRequests = new ArrayList<IHighlightRequest>();
        for (Map.Entry<String, IElementPresentationRule> entry : presentationRulesForPresentationElements.entrySet()) {
            String uid = entry.getKey();
            IElementPresentationRule presentationRule = entry.getValue();
            IHighlightRequest highlightRequest = PlanDocGenProxy.createHighlightRequest(uid, presentationRule);
            highlightRequests.add(highlightRequest);
        }
        return highlightRequests;
    }

    private static List<? extends IProjectionRequest> createProjectionRequests(Map<String, IElementPresentationRule> presentationRulesForPresentationElements) {
        ArrayList<IProjectionRequest> projectionRequests = new ArrayList<IProjectionRequest>();
        for (Map.Entry<String, IElementPresentationRule> entry : presentationRulesForPresentationElements.entrySet()) {
            String uid = entry.getKey();
            IElementPresentationRule presentationRule = entry.getValue();
            IProjection projection = presentationRule.getProjection();
            if (projection == null) continue;
            IProjectionRequest projectionRequest = PlanDocGenProxy.createProjectionRequest(uid, projection);
            projectionRequests.add(projectionRequest);
        }
        return projectionRequests;
    }

    private static IProjectionRequest createProjectionRequest(final String uid, final IProjection projection) {
        IProjectionRequest projectionRequest = new IProjectionRequest(){

            public String getPlanElementUID() {
                return uid;
            }

            public IProjection getProjection() {
                return projection;
            }
        };
        return projectionRequest;
    }

    private Map<String, IElementPresentationRule> createPresentationRulesForPresentationElements(Map<String, IElementPresentationRule> presentationRulesForRepresentedElements, boolean isElementPresentationRulesReferToModelElementUIDs) {
        Map<String, IElementPresentationRule> presentationRulesForPresentationElements;
        if (presentationRulesForRepresentedElements != null) {
            boolean representedElementsArePresentationElements = !isElementPresentationRulesReferToModelElementUIDs;
            presentationRulesForPresentationElements = this.createMapOfPresentationElements(presentationRulesForRepresentedElements, representedElementsArePresentationElements);
        } else {
            presentationRulesForPresentationElements = Collections.emptyMap();
        }
        return presentationRulesForPresentationElements;
    }

    private static IHighlightRequest createHighlightRequest(String planElementUID, IElementPresentationRule presentationRule) {
        ElementPresentationRule elementPresentationRule_ = (ElementPresentationRule)presentationRule;
        Color fillColor = DocGenColor.toColor(elementPresentationRule_.getFillColor());
        double fillOpacity = elementPresentationRule_.getFillOpacity();
        Color lineColor = DocGenColor.toColor(elementPresentationRule_.getLineColor());
        double colorWeight = elementPresentationRule_.getColorWeight();
        Color coronaColor = DocGenColor.toColor(elementPresentationRule_.getCoronaColor());
        double coronaWidth = elementPresentationRule_.getCoronaWidth();
        boolean showGuidelines = elementPresentationRule_.showGuidelines();
        return new HighlightRequest(planElementUID, fillColor, fillOpacity, lineColor, colorWeight, coronaColor, coronaWidth, showGuidelines);
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }

    public IRecord toXMLRecord() {
        PlanDisplayParameters planDisplayParameters = new PlanDisplayParameters();
        OpenedPlan openedPlan = this.projectAgent.createOpenedPlan(this.plan, planDisplayParameters);
        try {
            openedPlan.loadContent();
        }
        catch (ServerNotAvailableException e) {
            throw new RuntimeException(e);
        }
        catch (EXServerException e) {
            throw new RuntimeException(e);
        }
        catch (LoginCanceledException e) {
            throw new RuntimeException(e);
        }
        catch (UnknownServerException e) {
            throw new RuntimeException(e);
        }
        catch (ExPrematureEndOfTransfer e) {
            throw new RuntimeException(e);
        }
        File planFile = openedPlan.getTempFile();
        Record record = new Record(this.getGraphicsAndFilesHelper(), this.getLocale());
        try {
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(planFile));
                XMLCoDec.decode((InputStream)inputStream, (IXMLRootElementFactoryWO)record, (boolean)true);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Planfile not found.", e);
            }
            catch (EXXMLDecodingFailed e) {
                throw new RuntimeException("Planfile not valid.", e);
            }
        }
        finally {
            openedPlan.closePlan();
        }
        return record;
    }
}

