/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import de.plans.lib.util.HTMLEncoder;
import java.util.List;
import java.util.Locale;

public class HistoryEntry
implements IHistoryEntry {
    private final String version;
    private final String userRealName;
    private final String userLoginID;
    private final String userDistringuishedName;
    private final String date;
    private final List<String> comment;
    private final String uid;
    public static final int COMMIT_COUNT_FOR_INVALID_VERSION = -1;

    public HistoryEntry(EOCommitCountAndCommitInformation commitInformation, Locale projectLocale, PresentationContext presentationContext) {
        this.version = HistoryEntry.getVersionForCommitCount(commitInformation.getCommitCount());
        String realName = commitInformation.getCommitInformation().getCommitingUserInformation().getRealName();
        if (realName == null) {
            realName = "";
        }
        this.userRealName = HTMLEncoder.encode((String)realName);
        String loginID = commitInformation.getCommitInformation().getCommitingUserInformation().getLoginID();
        if (loginID == null) {
            loginID = "";
        }
        this.userLoginID = HTMLEncoder.encode((String)loginID);
        String distinguishedName = commitInformation.getCommitInformation().getCommitingUserInformation().getDistinguishedName();
        if (distinguishedName == null) {
            distinguishedName = "";
        }
        this.userDistringuishedName = HTMLEncoder.encode((String)distinguishedName);
        this.date = HTMLEncoder.encode((String)presentationContext.convertDateAndTimeWithoutSecondsToString(commitInformation.getCommitInformation().getCommitDate(), projectLocale));
        String commitCommentAsString = commitInformation.getCommitInformation().getCommitComment();
        List commitCommentAsList = StringUtil.splitTextLines((String)commitCommentAsString);
        this.comment = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(commitCommentAsList);
        this.uid = commitInformation.getCommitInformation().getCommitUID();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getUserRealname() {
        return this.userRealName;
    }

    @Override
    public String getUserLoginID() {
        return this.userLoginID;
    }

    @Override
    public String getUserDistinguishedName() {
        return this.userDistringuishedName;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public List<String> getComment() {
        return this.comment;
    }

    public static int getCommitCountForVersionNumber(String version) {
        String decodedVersion = HTMLEncoder.decode((String)version);
        try {
            Integer commitCount = Integer.valueOf(decodedVersion);
            return commitCount;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getVersionForCommitCount(int commitCount) {
        return HTMLEncoder.encode((String)Integer.toString(commitCount));
    }

    @Override
    public String getUniqueIdentifier() {
        return this.uid;
    }
}

