/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.DocGenColor;
import com.arcway.cockpit.docgen.provider.interfaces.IColor;
import com.arcway.cockpit.docgen.provider.interfaces.IElementPresentationRule;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import java.util.Collection;

public class ElementPresentationRule
implements IElementPresentationRule {
    private String role = null;
    private String displayName = null;
    private String description = null;
    private String comment = null;
    private IColor fillColor = null;
    private double fillOpacity = 0.0;
    private IColor lineColor = null;
    private double colorWeight = 1.0;
    private IColor coronaColor = null;
    private double coronaWidth = 0.0;
    private boolean showGuidelines = false;
    private IProjection projection = null;

    @Override
    public IElementPresentationRule getCopy() {
        ElementPresentationRule copy = new ElementPresentationRule();
        copy.role = this.role;
        copy.displayName = this.displayName;
        copy.description = this.description;
        copy.comment = this.comment;
        copy.fillColor = this.fillColor;
        copy.fillOpacity = this.fillOpacity;
        copy.lineColor = this.lineColor;
        copy.colorWeight = this.colorWeight;
        copy.coronaColor = this.coronaColor;
        copy.coronaWidth = this.coronaWidth;
        copy.showGuidelines = this.showGuidelines;
        copy.projection = this.projection;
        return copy;
    }

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description == null ? null : StringUtil.replaceLineBreaksWithWindowsLineBreaks((String)description);
    }

    @Override
    public void setDescriptionFromStringList(Collection<? extends String> description) {
        this.description = description == null ? null : StringUtil.concatWithWindowsLineBreaks(description, (boolean)false);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment == null ? null : StringUtil.replaceLineBreaksWithWindowsLineBreaks((String)comment);
    }

    @Override
    public void setCommentAsStringList(Collection<? extends String> comment) {
        this.comment = comment == null ? null : StringUtil.concatWithWindowsLineBreaks(comment, (boolean)false);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setFillColor(int red, int green, int blue) {
        this.fillColor = new DocGenColor(red, green, blue);
    }

    @Override
    public void resetFillColor() {
        this.fillColor = null;
    }

    @Override
    public IColor getFillColor() {
        return this.fillColor;
    }

    @Override
    public double getFillOpacity() {
        return this.fillOpacity;
    }

    @Override
    public void setFillOpacity(double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    @Override
    public void setLineColor(int red, int green, int blue) {
        this.lineColor = new DocGenColor(red, green, blue);
    }

    @Override
    public void resetLineColor() {
        this.lineColor = null;
    }

    @Override
    public IColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setColorWeight(double colorWeight) {
        this.colorWeight = colorWeight;
    }

    @Override
    public double getColorWeight() {
        return this.colorWeight;
    }

    @Override
    public void setCorona(int red, int green, int blue, double width) {
        this.coronaColor = new DocGenColor(red, green, blue);
        this.coronaWidth = width;
    }

    @Override
    public void resetCorona() {
        this.coronaColor = null;
        this.coronaWidth = 0.0;
    }

    @Override
    public IColor getCoronaColor() {
        return this.coronaColor;
    }

    @Override
    public double getCoronaWidth() {
        return this.coronaWidth;
    }

    @Override
    public void setShowGuidelines(boolean showGuidelines) {
        this.showGuidelines = showGuidelines;
    }

    @Override
    public boolean showGuidelines() {
        return this.showGuidelines;
    }

    @Override
    public void setProjection(IProjection projection) {
        this.projection = projection;
    }

    @Override
    public IProjection getProjection() {
        return this.projection;
    }
}

