/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.interfaces.IArrayHelper;
import com.arcway.cockpit.docgen.provider.interfaces.ICockpitData;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ArrayHelper
implements IReportRelatedReportProvider,
IArrayHelper {
    private IReportRelatedReportContext reportContext = null;
    public static final String WRAPPED_OBJECT_KEY = "wrappedObject";
    public static final String UNIQUE_IDENTIFIER_KEY = "uniqueIdentifier";
    public static final String DISPLAY_NAME_KEY = "displayName";
    public static final String TYPE_ID_KEY = "typeID";
    public static final String CATEGORY_ID_KEY = "categoryID";
    public static final String CUSTOM_KEY_PREFIX = "custom.";
    public static final String ID_KEY = "ID";
    public static final String TITLE_KEY = "title";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    public static final String OBJECT_TYPE_KEY = "objectType";

    @Override
    public void setup(IReportRelatedReportContext reportContext) {
        this.reportContext = reportContext;
    }

    @Override
    public boolean arrayIsEmpty(Object[] array) {
        boolean isEmpty = array == null || array.length == 0;
        return isEmpty;
    }

    @Override
    public boolean arrayIsEmpty(String[] array) {
        boolean isEmpty = array == null || array.length == 0;
        return isEmpty;
    }

    @Override
    public boolean arrayIsEmpty(List<Object> array) {
        return array.isEmpty();
    }

    @Override
    public int getArraySize(Object[] array) {
        int arraySize = 0;
        if (array != null) {
            arraySize = array.length;
        }
        return arraySize;
    }

    @Override
    public int getArraySize(String[] array) {
        int arraySize = 0;
        if (array != null) {
            arraySize = array.length;
        }
        return arraySize;
    }

    public int getArraySize(Object array) {
        int arraySize = 0;
        if (array != null && array instanceof List) {
            arraySize = ((List)array).size();
        }
        return arraySize;
    }

    @Override
    public int getArraySize(List<Object> array) {
        return array.size();
    }

    @Override
    public List<Object> appendToArray(Object[] array, Object o) {
        if (array == null) {
            return Collections.singletonList(o);
        }
        ArrayList<Object> newList = new ArrayList<Object>(array.length + 1);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            newList.add(i);
            ++n2;
        }
        newList.add(o);
        return newList;
    }

    @Override
    public List<Object> appendToArray(String[] array, Object o) {
        if (array == null) {
            return Collections.singletonList(o);
        }
        ArrayList<Object> newList = new ArrayList<Object>(array.length + 1);
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            newList.add(i);
            ++n2;
        }
        newList.add(o);
        return newList;
    }

    @Override
    public List<Object> appendToArray(List<Object> array, Object o) {
        if (array == null) {
            return Collections.singletonList(o);
        }
        ArrayList<Object> newList = new ArrayList<Object>(array.size() + 1);
        newList.addAll(array);
        newList.add(o);
        return newList;
    }

    @Override
    public List<Object> convertToList(Object[] array) {
        return Arrays.asList(array);
    }

    @Override
    public List<String> convertToList(String[] array) {
        return Arrays.asList(array);
    }

    @Override
    @Deprecated
    public List<Object> convertToList(List<Object> array) {
        return array;
    }

    @Override
    public List<?> createList() {
        return new ArrayList();
    }

    @Override
    public Set<?> createHashSet() {
        return new HashSet();
    }

    @Override
    public SortedSet<?> createSortedSet() {
        return new TreeSet();
    }

    @Override
    public SortedMap<?, ?> createSortedMap() {
        return new TreeMap();
    }

    @Override
    public Map<?, ?> createHashMap() {
        return new HashMap();
    }

    @Override
    public Record createRecord() {
        return new Record(this.reportContext.getGraphicsProvider(), this.reportContext.getPresentationContext().getLocale());
    }

    @Override
    public IRecord getCachedRecord(Map<String, IRecord> uid2cachedRecord, ICockpitData cockpitData) {
        return this.getCachedRecord(uid2cachedRecord, cockpitData, null);
    }

    public IRecord getCachedRecord(Map<String, IRecord> uid2cachedRecord, ICockpitData cockpitData, Set<String> keyWhiteList) {
        String uid = cockpitData.getUniqueIdentifier();
        IRecord cachedRecord = uid2cachedRecord.get(uid);
        if (cachedRecord == null) {
            cachedRecord = cockpitData.toRecord(keyWhiteList);
            uid2cachedRecord.put(uid, cachedRecord);
        }
        return cachedRecord;
    }

    @Override
    public List<IRecord> getCachedRecords(Map<String, IRecord> uid2cachedRecord, Collection<ICockpitData> cockpitDatas) {
        ArrayList<IRecord> cachedRecords = new ArrayList<IRecord>(cockpitDatas.size());
        for (ICockpitData cockpitData : cockpitDatas) {
            IRecord cachedRecord = this.getCachedRecord(uid2cachedRecord, cockpitData);
            cachedRecords.add(cachedRecord);
        }
        return cachedRecords;
    }

    @Override
    public IRecord getCachedRecordCrossProject(Map<String, Map<String, IRecord>> projectUID2uid2cachedRecord, ICockpitData cockpitData, Set<String> keyWhiteList) {
        String projectUID = cockpitData.getProjectUniqueIdentifier();
        Map<String, IRecord> uid2cachedRecord = projectUID2uid2cachedRecord.get(projectUID);
        if (uid2cachedRecord == null) {
            uid2cachedRecord = new TreeMap<String, IRecord>();
            projectUID2uid2cachedRecord.put(projectUID, uid2cachedRecord);
        }
        return this.getCachedRecord(uid2cachedRecord, cockpitData, keyWhiteList);
    }

    @Override
    public List<IRecord> getCachedRecordsCrossProject(Map<String, Map<String, IRecord>> projectUID2uid2cachedRecord, Collection<ICockpitData> cockpitDatas, Set<String> keyWhiteList) {
        ArrayList<IRecord> cachedRecords = new ArrayList<IRecord>(cockpitDatas.size());
        for (ICockpitData cockpitData : cockpitDatas) {
            IRecord cachedRecord = this.getCachedRecordCrossProject(projectUID2uid2cachedRecord, cockpitData, keyWhiteList);
            cachedRecords.add(cachedRecord);
        }
        return cachedRecords;
    }

    @Override
    public SortedSet<IRecord> createRecordSortedSet(final List<String> propertyIDsForSorting) {
        TreeSet<IRecord> sortedCachedRecords = new TreeSet<IRecord>(new Comparator<IRecord>(){

            @Override
            public int compare(IRecord o1, IRecord o2) {
                return Record.compare(o1, o2, propertyIDsForSorting);
            }
        });
        return sortedCachedRecords;
    }

    @Override
    public SortedSet<IRecord> sortRecords(Collection<IRecord> records, List<String> propertyIDsForSorting) {
        SortedSet<IRecord> sortedSet = this.createRecordSortedSet(propertyIDsForSorting);
        sortedSet.addAll(records);
        return sortedSet;
    }

    @Override
    public XMLProcessingInstruction createProcessingInstruction(String target, String data) {
        return new XMLProcessingInstruction(target, data);
    }
}

