/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.graphicsandfiles.FileInReportDescription;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.DataModelProvider;
import com.arcway.cockpit.docgen.provider.ModificationResult;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.ReportFileHelper;
import com.arcway.cockpit.docgen.provider.interfaces.ICockpitData;
import com.arcway.cockpit.docgen.provider.interfaces.IImageInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.todo_release.IModificationResult;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.lib.codec.Base64;
import com.arcway.lib.java.Equals;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.util.HTMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractAttributeOwnerDocGenProxy
implements ICockpitData {
    private static final ILogger logger = Logger.getLogger(AbstractAttributeOwnerDocGenProxy.class);
    private final IAttributeOwner wrappedAttributeOwner;
    private final IGraphicsAndFilesHelper fileAttributeAndGraphicsProvider;
    private final IFrameProjectAgent projectAgent;
    private final Locale locale;
    private static final int FILE_PROPERTY_WITH_FILE_SET = 1;
    private static final int FILE_PROPERTY_WITH_NO_FILE_SET = 2;
    private static final int NON_FILE_PROPERTY_WITH_VALUE_SET = 4;
    private static final int NON_FILE_PROPERTY_WITH_NO_VALUE_SET = 5;
    private static final int NO_PROPERTY = 7;
    private static final int INVISIBLE_PROPERTY = 8;
    private static final int DATE_TIME_PROPERTY_WITH_VALUE_SET = 1;
    private static final int DATE_TIME_PROPERTY_WITH_NO_VALUE_SET = 2;
    private static final int NOT_A_DATE_TIME_PROPERTY = 3;
    private static final int DATE_TIME_PROPERTY_NOT_VISIBLE = 4;
    private static final String REGEXP_FOR_MULTIPLECHOICE_SEPARATION = ",";

    public AbstractAttributeOwnerDocGenProxy(IAttributeOwner attributeOwner, IGraphicsAndFilesHelper fileAttributeProvider, IFrameProjectAgent projectAgent, Locale locale) {
        this.wrappedAttributeOwner = attributeOwner;
        this.fileAttributeAndGraphicsProvider = fileAttributeProvider;
        this.projectAgent = projectAgent;
        this.locale = locale;
    }

    protected final IAttributeOwner getWrappedAttributeOwner() {
        return this.wrappedAttributeOwner;
    }

    @Override
    public final String getProjectUniqueIdentifier() {
        return this.wrappedAttributeOwner.getProjectUID();
    }

    protected final Locale getLocale() {
        return this.locale;
    }

    @Override
    public List<String> getCommitVersions() {
        return null;
    }

    public final boolean hasProperty(String propertyID) {
        int propertyStatus = this.getPropertyStatus(propertyID);
        return propertyStatus != 7 && propertyStatus != 8;
    }

    public final boolean hasPropertyValue(String propertyID) {
        int propertyStatus = this.getPropertyStatus(propertyID);
        return propertyStatus == 1 || propertyStatus == 4;
    }

    private final boolean hasFilePropertyAvailable(String propertyID) {
        return this.getPropertyStatus(propertyID) == 1 || this.getPropertyStatus(propertyID) == 2;
    }

    private final boolean hasFilePropertySet(String propertyID) {
        return this.getPropertyStatus(propertyID) == 1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getPropertyStatus(String propertyID) {
        block13: {
            block14: {
                if (this.wrappedAttributeOwner == null) {
                    return 7;
                }
                if (propertyID == null) {
                    return 7;
                }
                IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
                if (attributeType == null) break block13;
                if (!ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem((IAttributeOwner)this.wrappedAttributeOwner, (IAttributeType)attributeType)) break block14;
                if (attributeType.getDataType().getID().equals("image") || attributeType.getDataType().getID().equals("file")) {
                    try {
                        IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                        if (attribute == null) {
                            return 2;
                        }
                        if (!((FileID)attribute.getAttributeValue()).equals((Object)FileID.NO_FILE)) {
                            return 1;
                        }
                        return 2;
                    }
                    catch (ExInvalidAttributeType e) {
                        return 2;
                    }
                }
                {
                    catch (ExInvalidAttributeType e) {
                        return 7;
                    }
                    try {
                        IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                        if (AbstractAttributeOwnerDocGenProxy.isAttributeValueNotEmpty(attribute.getAttributeValue())) {
                            return 4;
                        }
                        return 5;
                    }
                    catch (ExInvalidAttributeType e) {}
                    return 5;
                }
            }
            return 8;
        }
        return 7;
    }

    public final Long getDateTimeProperty_MilliSecondsSince_01_01_1970(String propertyID) {
        Long value;
        block7: {
            if (this.wrappedAttributeOwner == null) {
                return null;
            }
            if (propertyID == null) {
                return null;
            }
            value = null;
            try {
                IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
                if (attributeType == null || attributeType.isUserDefined() && !ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem((IAttributeOwner)this.wrappedAttributeOwner, (IAttributeType)attributeType) || !attributeType.getDataType().getID().equals("date")) break block7;
                try {
                    IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                    if (attribute != null) {
                        value = DataTypeDate.getValueAsLong((Object)attribute.getAttributeValue());
                    }
                }
                catch (ExInvalidAttributeType e) {
                    value = null;
                }
            }
            catch (ExInvalidAttributeType e) {
                value = null;
            }
        }
        return value;
    }

    public final boolean hasDateTimeProperty(String propertyID) {
        return this.getDateTimePropertyStatus(propertyID) == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getDateTimePropertyStatus(String propertyID) {
        if (this.wrappedAttributeOwner == null) {
            return 7;
        }
        if (propertyID == null) {
            return 7;
        }
        try {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
            if (attributeType == null) {
                return 7;
            }
            if (!ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem((IAttributeOwner)this.wrappedAttributeOwner, (IAttributeType)attributeType)) {
                return 4;
            }
            if (!attributeType.getDataType().getID().equals("date")) {
                return 3;
            }
            try {
                IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                if (attribute == null) {
                    return 2;
                }
                Long value = DataTypeDate.getValueAsLong((Object)attribute.getAttributeValue());
                if (value != null) {
                    return 1;
                }
                return 2;
            }
            catch (ExInvalidAttributeType e) {
                return 2;
            }
        }
        catch (ExInvalidAttributeType e2) {
            return 7;
        }
    }

    public final String getPropertyAsString(String propertyID) {
        this.checkProperty(propertyID);
        int propertyStatus = this.getPropertyStatus(propertyID);
        if (propertyStatus == 2) {
            return "";
        }
        if (propertyStatus == 1) {
            return this.getFileProperty(propertyID);
        }
        if (propertyStatus == 4 || propertyStatus == 5) {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
            IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
            if (attribute != null) {
                IAttributeTypeDataType dataType = attributeType.getDataType();
                Object o = attribute.getAttributeValue();
                if (o != null) {
                    return HTMLEncoder.encode((String)dataType.getValueAsSingleLineString(o, attributeType.getValueRange(), ", ", this.locale));
                }
            }
            return "";
        }
        return "";
    }

    public final Object getPropertyAsJavaObject(String propertyID) {
        this.checkProperty(propertyID);
        int propertyStatus = this.getPropertyStatus(propertyID);
        if (propertyStatus == 2 || propertyStatus == 1) {
            return null;
        }
        if (propertyStatus == 4 || propertyStatus == 5) {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
            IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
            if (attribute != null) {
                IAttributeTypeDataType dataType = attributeType.getDataType();
                Object o = attribute.getAttributeValue();
                if (o != null) {
                    return dataType.getCopy(o, attributeType.getValueRange());
                }
            }
            return null;
        }
        return null;
    }

    public final List<String> getPropertyAsStringArray(String propertyID) {
        return this.getPropertyAsStringList(propertyID);
    }

    public final List<String> getPropertyAsStringList(String propertyID) {
        this.checkProperty(propertyID);
        int propertyStatus = this.getPropertyStatus(propertyID);
        if (propertyStatus == 2) {
            return Collections.emptyList();
        }
        if (propertyStatus == 1) {
            return Collections.singletonList(this.getFileProperty(propertyID));
        }
        if (propertyStatus == 4 || propertyStatus == 5) {
            List<String> result;
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
            IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
            IAttributeTypeDataType dataType = attributeType.getDataType();
            Object value = attribute.getAttributeValue();
            if (attributeType.getDataType() instanceof DataTypeText) {
                List textList = StringUtil.splitTextLines((String)DataTypeText.getInstanceText().getValueAsMultiLineString(value));
                result = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(textList);
            } else if (attributeType.getDataType() instanceof DataTypeEnumerationMultiple) {
                List textList = ((DataTypeEnumerationMultiple)attributeType.getDataType()).getValueAsStrings(value, attributeType.getValueRange(), this.locale);
                result = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(textList);
            } else {
                String stringValue;
                result = value != null ? ((stringValue = HTMLEncoder.encode((String)dataType.getValueAsSingleLineString(value, attributeType.getValueRange(), ", ", this.locale))) != null ? Collections.singletonList(stringValue) : Collections.emptyList()) : Collections.emptyList();
            }
            return result;
        }
        return Collections.emptyList();
    }

    public final String getFileProperty(String propertyID) {
        return this.getFileProperty(propertyID, 0.0, 0.0);
    }

    public final String getFileProperty(String propertyID, double width_mm, double height_mm) {
        String snippet = null;
        FileInReportDescription fileInReportDescription = this.fetchFileProperty(propertyID, new PostProcessingFileFetcher());
        snippet = fileInReportDescription != null ? this.getGraphicsAndFilesHelper().getSnippetForFileInRawReportFormat(fileInReportDescription, width_mm, height_mm) : "";
        return snippet;
    }

    public final String getFilePropertyAsFileName(String propertyID) {
        return this.getFilePropertyAsFileName(propertyID, null);
    }

    public static String getFileName(File file) {
        String fileName = file != null ? file.getAbsolutePath() : "";
        return fileName;
    }

    public final String getFilePropertyAsFileName(String propertyID, String fileNamePrefix) {
        File file = this.fetchFileProperty(propertyID, new PreProcessingFileFetcher(fileNamePrefix));
        String fileName = AbstractAttributeOwnerDocGenProxy.getFileName(file);
        return fileName;
    }

    public final List<String> getFilePropertyAsStringList(String propertyID, String characterEncoding) {
        List<String> fileContentAsStringListNONHTML = this.getFilePropertyAsRawStringList(propertyID, characterEncoding);
        List<String> fileContent = AbstractAttributeOwnerDocGenProxy.convertFileContentIntoHTMLEncodedNormalisedMultilineTextOutput(fileContentAsStringListNONHTML);
        return fileContent;
    }

    public static final List<String> convertFileContentIntoHTMLEncodedNormalisedMultilineTextOutput(List<String> fileContentAsStringListNONHTML) {
        List<String> fileContent = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(fileContentAsStringListNONHTML);
        return fileContent;
    }

    public final List<String> getFilePropertyAsRawStringList(String propertyID, String characterEncoding) {
        byte[] byteBuffer = this.getFilePropertyAsRawData(propertyID);
        return AbstractAttributeOwnerDocGenProxy.convertFileContentIntoRawStringList(characterEncoding, byteBuffer);
    }

    public static final List<String> convertFileContentIntoRawStringList(String characterEncoding, byte[] byteBuffer) {
        List fileContentAsStringListNONHTML;
        try {
            String fileContentAsString = new String(byteBuffer, characterEncoding);
            fileContentAsStringListNONHTML = StringUtil.splitTextLines((String)fileContentAsString);
        }
        catch (UnsupportedEncodingException e) {
            fileContentAsStringListNONHTML = Collections.emptyList();
        }
        return fileContentAsStringListNONHTML;
    }

    public final List<String> getFilePropertyAsBase64StringList(String propertyID, boolean breakLines) {
        byte[] byteBuffer = this.getFilePropertyAsRawData(propertyID);
        List<String> fileContentAsStringListBase64 = AbstractAttributeOwnerDocGenProxy.getBase64StringList(breakLines, byteBuffer);
        return fileContentAsStringListBase64;
    }

    public IImageInfo readImageInfoOfFileProperty(String propertyID) {
        IImageInfo imageInfo;
        File file = this.fetchFileProperty(propertyID, new PreProcessingFileFetcher(null));
        if (file != null) {
            imageInfo = ReportFileHelper.readImageInfo(file);
            file.delete();
        } else {
            imageInfo = null;
        }
        return imageInfo;
    }

    public static final List<String> getBase64StringList(boolean breakLines, byte[] byteBuffer) {
        String fileContentAsBase64String = new String(Base64.encodeBytes((byte[])byteBuffer, (boolean)breakLines));
        List fileContentAsStringListBase64 = StringUtil.splitTextLines((String)fileContentAsBase64String);
        return fileContentAsStringListBase64;
    }

    public final byte[] getFilePropertyAsRawData(String propertyID) {
        byte[] byteBuffer;
        block9: {
            File file = this.fetchFileProperty(propertyID, new PreProcessingFileFetcher(null));
            if (file != null) {
                byteBuffer = new byte[(int)file.length()];
                try {
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        inputStream.read(byteBuffer);
                        break block9;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    file.delete();
                }
            }
            byteBuffer = new byte[]{};
        }
        return byteBuffer;
    }

    public final <T> T fetchFileProperty(String propertyID, IFileFetcher<T> fileFetcher) {
        this.checkFilePropertySet(propertyID);
        if (this.fileAttributeAndGraphicsProvider == null) {
            return null;
        }
        int propertyStatus = this.getPropertyStatus(propertyID);
        if (propertyStatus == 1) {
            try {
                IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
                AbstractDataTypeWithFile fileDataType = (AbstractDataTypeWithFile)attributeType.getDataType();
                try {
                    IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                    if (attribute != null) {
                        FileID attributeFileID = (FileID)attribute.getAttributeValue();
                        ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(this.wrappedAttributeOwner.getProjectUID());
                        T file = fileFetcher.fetchFile(fileDataType, attributeFileID, (IFrameProjectAgent)projectAgent_);
                        return file;
                    }
                }
                catch (ExInvalidAttributeType e) {
                    return null;
                }
            }
            catch (ExInvalidAttributeType e) {
                return null;
            }
            return null;
        }
        return null;
    }

    protected final IGraphicsAndFilesHelper getGraphicsAndFilesHelper() {
        return this.fileAttributeAndGraphicsProvider;
    }

    protected static final boolean isAttributeValueNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String && ((String)value).length() == 0) {
            return false;
        }
        if (value instanceof List && ((List)value).size() == 0) {
            return false;
        }
        return !(value instanceof FileID) || !((FileID)value).equals((Object)FileID.NO_FILE);
    }

    @Deprecated
    public final String getDisplaynameOfProperty(String propertyTypeID) {
        this.checkProperty(propertyTypeID);
        try {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
            return HTMLEncoder.encode((String)attributeType.getDisplayName());
        }
        catch (ExInvalidAttributeType exInvalidAttributeType) {
            logger.error("Property of type " + propertyTypeID + " does not exist!");
            return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
        }
    }

    @Deprecated
    public final String getDatatypeIDOfProperty(String propertyTypeID) {
        this.checkProperty(propertyTypeID);
        try {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
            return HTMLEncoder.encode((String)attributeType.getDataType().getID());
        }
        catch (ExInvalidAttributeType exInvalidAttributeType) {
            logger.error("Property of type " + propertyTypeID + " does not exist!");
            return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
        }
    }

    @Deprecated
    public final String getDatatypeDisplaynameOfProperty(String propertyTypeID) {
        this.checkProperty(propertyTypeID);
        try {
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
            return HTMLEncoder.encode((String)attributeType.getDataType().getDisplayName(this.locale));
        }
        catch (ExInvalidAttributeType exInvalidAttributeType) {
            logger.error("Property of type " + propertyTypeID + " does not exist!");
            return String.valueOf(Messages.getString("AbstractCockpitDataWrapper.unknown_property1")) + propertyTypeID + Messages.getString("AbstractCockpitDataWrapper.unknown_property2");
        }
    }

    public static void sortArray(Object[] theArray, String propertyTypeID) {
        IAttributeType attributeType;
        if (theArray.length == 0) {
            return;
        }
        try {
            AbstractAttributeOwnerDocGenProxy wrapper = (AbstractAttributeOwnerDocGenProxy)theArray[0];
            attributeType = wrapper.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
        }
        catch (ExInvalidAttributeType ex) {
            return;
        }
        final IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
        final Comparator attributeTypeComparator = attributeType.getDataType().getComparator(attributeType.getValueRange());
        Arrays.sort(theArray, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                if (!(arg0 instanceof AbstractAttributeOwnerDocGenProxy) || !(arg1 instanceof AbstractAttributeOwnerDocGenProxy)) {
                    return 0;
                }
                return attributeTypeComparator.compare(((AbstractAttributeOwnerDocGenProxy)arg0).wrappedAttributeOwner.getAttribute(attributeTypeID).getAttributeValue(), ((AbstractAttributeOwnerDocGenProxy)arg1).wrappedAttributeOwner.getAttribute(attributeTypeID).getAttributeValue());
            }
        });
    }

    public static void sortList(List theList, String propertyTypeID) {
        IAttributeType attributeType;
        if (theList.size() == 0) {
            return;
        }
        try {
            AbstractAttributeOwnerDocGenProxy wrapper = (AbstractAttributeOwnerDocGenProxy)theList.get(0);
            attributeType = wrapper.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
        }
        catch (ExInvalidAttributeType ex) {
            logger.warn("Property type " + propertyTypeID + " is not defined.");
            return;
        }
        final IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
        final Comparator attributeTypeComparator = attributeType.getDataType().getComparator(attributeType.getValueRange());
        Collections.sort(theList, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                if (!(arg0 instanceof AbstractAttributeOwnerDocGenProxy) || !(arg1 instanceof AbstractAttributeOwnerDocGenProxy)) {
                    return 0;
                }
                return attributeTypeComparator.compare(((AbstractAttributeOwnerDocGenProxy)arg0).wrappedAttributeOwner.getAttribute(attributeTypeID).getAttributeValue(), ((AbstractAttributeOwnerDocGenProxy)arg1).wrappedAttributeOwner.getAttribute(attributeTypeID).getAttributeValue());
            }
        });
    }

    protected final void checkProperty(String propertyTypeID) {
        if (!this.hasProperty(propertyTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.PropertyDoesNotExist1")) + " \"" + propertyTypeID + "\" " + Messages.getString("ErrorMessage.PropertyDoesNotExist2"));
        }
    }

    private final void checkFilePropertySet(String propertyTypeID) {
        if (!this.hasFilePropertySet(propertyTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.FilePropertyDoesNotExist1")) + " \"" + propertyTypeID + "\" " + Messages.getString("ErrorMessage.FilePropertyDoesNotExist2"));
        }
    }

    private final void checkFilePropertyAvailable(String propertyTypeID) {
        if (!this.hasFilePropertyAvailable(propertyTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.FilePropertyDoesNotExist1")) + " \"" + propertyTypeID + "\" " + Messages.getString("ErrorMessage.FilePropertyDoesNotExist2"));
        }
    }

    public final String getCategoryID() {
        ObjectTypeCategoryID categoryID = this.wrappedAttributeOwner.getCategoryID();
        if (categoryID != null) {
            ObjectTypeCategory category = this.projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
            if (category != null) {
                return category.getHumanReadableID();
            }
            logger.error("Cannot find object type category (id=" + categoryID.getUID() + ")" + " specified for custom property (id=" + this.wrappedAttributeOwner.getUID() + ")");
            return null;
        }
        return null;
    }

    public final String getCategoryLabel() {
        ObjectTypeCategoryID categoryID = this.wrappedAttributeOwner.getCategoryID();
        if (categoryID != null) {
            ObjectTypeCategory category = this.projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
            if (category != null) {
                return HTMLEncoder.encode((String)category.getDisplayName());
            }
            logger.error("Cannot find object type category (id=" + categoryID.getUID() + ")" + " specified for custom property (id=" + this.wrappedAttributeOwner.getUID() + ")");
            return null;
        }
        return HTMLEncoder.encode((String)ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
    }

    public final boolean hasDefaultCategory() {
        return this.wrappedAttributeOwner.getCategoryID() == null;
    }

    @Override
    public final IRecord toRecord() {
        Set<String> keyWhiteList = null;
        return this.toRecord(keyWhiteList);
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        Record record = new Record(this.fileAttributeAndGraphicsProvider, this.locale, this, keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("categoryID")) {
            record.set("categoryID", this.getCategoryID());
        }
        String typeID = this.getTypeID();
        for (String propertyID : DataModelProvider.getCustomPropertyIdsForObjectType(this.projectAgent, typeID)) {
            List<String> values;
            if (keyWhiteList != null && !keyWhiteList.contains(propertyID) || !this.hasPropertyValue(propertyID)) continue;
            IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyID);
            IAttributeTypeDataType dataType = attributeType.getDataType();
            if ("file".equals(dataType.getID()) || "image".equals(dataType.getID())) {
                boolean breakLines = true;
                IAttribute attribute = this.wrappedAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
                FileID attributeFileID = (FileID)attribute.getAttributeValue();
                if (attributeFileID != null && !FileID.NO_FILE.equals((Object)attributeFileID)) {
                    FileMetaInformationItem metaInformation = this.projectAgent.getFilesManager().getFileMetaInformation(attributeFileID);
                    String originalFileName = metaInformation.getOriginalFileName();
                    String fileNameKey = String.valueOf(propertyID) + "._originalfileName";
                    record.set(fileNameKey, originalFileName);
                    values = this.getFilePropertyAsBase64StringList(propertyID, breakLines);
                } else {
                    values = null;
                }
            } else if ("date".equals(dataType.getID())) {
                Long longValue = this.getDateTimeProperty_MilliSecondsSince_01_01_1970(propertyID);
                values = longValue == null ? Collections.emptyList() : Collections.singletonList(longValue.toString());
                record.add("_dateProperty", propertyID);
            } else {
                if (dataType instanceof DataTypeEnumerationMultiple) {
                    record.add("_commaSeparatedProperty", propertyID);
                }
                values = this.getPropertyAsStringList(propertyID);
            }
            record.addAll(propertyID, values);
        }
        return record;
    }

    public final Collection<IModificationResult> setProperty(String propertyTypeID, String newValueAsString) throws JvmExternalResourceInteractionException {
        this.checkProperty(propertyTypeID);
        return this.setProperty_Internal(propertyTypeID, newValueAsString, newValueAsString);
    }

    public final Collection<IModificationResult> setFileProperty(String propertyTypeID, String fileNameOfFileToBeRead, String fileNameOfProperty) throws JvmExternalResourceInteractionException {
        this.checkFilePropertyAvailable(propertyTypeID);
        return this.setProperty_Internal(propertyTypeID, fileNameOfFileToBeRead, fileNameOfProperty);
    }

    /*
     * WARNING - void declaration
     */
    protected final Collection<IModificationResult> setProperty_Internal(String propertyTypeID, String newValueAsString, String originalFileName) throws JvmExternalResourceInteractionException {
        Object newValue;
        this.checkProperty(propertyTypeID);
        IAttributeType attributeType = this.wrappedAttributeOwner.getAttributeTypeByHumanreadableID(propertyTypeID);
        IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
        IAttributeTypeDataType dataType = attributeType.getDataType();
        String dataTypeID = dataType.getID();
        IValueRange valueRange = attributeType.getValueRange();
        IAttribute oldAttribute = this.wrappedAttributeOwner.getAttribute(attributeTypeID);
        String separator = dataType instanceof DataTypeEnumerationMultiple ? REGEXP_FOR_MULTIPLECHOICE_SEPARATION : null;
        if ("file".equals(dataTypeID) || "image".equals(dataTypeID)) {
            String fileName = AbstractAttributeOwnerDocGenProxy.getTrimmedFilename(newValueAsString);
            if (fileName != null) {
                void var15_16;
                File file = new File(fileName);
                String trimmedOriginalFileName = AbstractAttributeOwnerDocGenProxy.getTrimmedFilename(originalFileName);
                if (trimmedOriginalFileName == null) {
                    FileResource fileResource = new FileResource(file);
                } else {
                    FileResourceWithOverwrittenName fileResourceWithOverwrittenName = new FileResourceWithOverwrittenName(file, trimmedOriginalFileName);
                }
                newValue = this.loadFileIntoTemporaryStorage((IStreamResource)var15_16);
            } else {
                newValue = FileID.NO_FILE;
            }
        } else {
            newValue = dataType.getAttributeValueFromString(newValueAsString, valueRange, separator);
        }
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        Attribute newAttribute = new Attribute(attributeTypeID, newValue);
        newAttributes.add(newAttribute);
        if (this.wrappedAttributeOwner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW iAttributeOwnerRW = (IAttributeOwnerRW)this.wrappedAttributeOwner;
            iAttributeOwnerRW.requestAttributeModificationPermission((IAttribute)newAttribute, (ILocksAndPermissionsTransactionController)transactionController);
        } else if (this.wrappedAttributeOwner instanceof IAttributeModificationManager) {
            IAttributeModificationManager iAttributeModificationManager = (IAttributeModificationManager)this.wrappedAttributeOwner;
            iAttributeModificationManager.requestAttributeModificationPermission((IAttribute)newAttribute, (ILocksAndPermissionsTransactionController)transactionController);
        } else {
            throw new IllegalArgumentException(this.wrappedAttributeOwner.getClass().getSimpleName());
        }
        Collection modificationProblems = transactionController.execute();
        if (modificationProblems.isEmpty()) {
            for (IAttribute iAttribute : newAttributes) {
                try {
                    if (this.wrappedAttributeOwner instanceof IAttributeOwnerRW) {
                        IAttributeOwnerRW attributeOwnerRW = (IAttributeOwnerRW)this.wrappedAttributeOwner;
                        attributeOwnerRW.setAttribute(iAttribute);
                        continue;
                    }
                    if (this.wrappedAttributeOwner instanceof IAttributeModificationManager) {
                        IAttributeModificationManager attributeModificationManager = (IAttributeModificationManager)this.wrappedAttributeOwner;
                        attributeModificationManager.modifyAttribute(iAttribute, (Object)oldAttribute);
                        continue;
                    }
                    throw new IllegalArgumentException(this.wrappedAttributeOwner.getClass().getSimpleName());
                }
                catch (EXNoPermission e) {
                    throw new RuntimeException(e);
                }
                catch (EXNoLock e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Collection<IModificationResult> collection = AbstractAttributeOwnerDocGenProxy.convertModificationResults(modificationProblems);
        return collection;
    }

    private static final String getTrimmedFilename(String untrimmedFileName) {
        String trimmedFileName;
        String fileName = untrimmedFileName != null ? ((trimmedFileName = untrimmedFileName.trim()).length() > 0 ? trimmedFileName : null) : null;
        return fileName;
    }

    private final FileID loadFileIntoTemporaryStorage(IStreamResource file) throws JvmExternalResourceInteractionException {
        return this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage(file);
    }

    public static final <T extends IAttributeOwner> List<T> filterByCategoryID(List<? extends T> toFilter, String categoryID) {
        if (toFilter == null) {
            return null;
        }
        ArrayList<IAttributeOwner> filtered = new ArrayList<IAttributeOwner>(toFilter.size());
        for (IAttributeOwner customPropertyAccess : toFilter) {
            if (!Equals.equals((Object)customPropertyAccess.getCategoryID(), (Object)categoryID)) continue;
            filtered.add(customPropertyAccess);
        }
        return filtered;
    }

    private static final Collection<IModificationResult> convertModificationResults(Collection<IModificationProblem> modificationProblems) {
        ArrayList<IModificationResult> modificationResults = new ArrayList<IModificationResult>(modificationProblems.size());
        for (IModificationProblem modificationProblem : modificationProblems) {
            modificationResults.add(new ModificationResult(modificationProblem));
        }
        return modificationResults;
    }

    protected final String getProjectUIDForLink() {
        return this.projectAgent.getProjectUID();
    }

    @Deprecated
    public final String getLinkForOpen() {
        return this.getLinkForShow();
    }

    @Override
    public final String getLinkForShow() {
        return HTMLEncoder.encode((String)ICOCKPITEclipseClientController.INSTANCE.getLinkForShow((ICockpitProjectData)this.wrappedAttributeOwner, Collections.emptyMap(), this.getGraphicsAndFilesHelper().getTinyizeContext()).toString());
    }

    private static interface IFileFetcher<T> {
        public T fetchFile(AbstractDataTypeWithFile var1, FileID var2, IFrameProjectAgent var3);
    }

    private class PostProcessingFileFetcher
    implements IFileFetcher<FileInReportDescription> {
        private PostProcessingFileFetcher() {
        }

        @Override
        public FileInReportDescription fetchFile(AbstractDataTypeWithFile attributeDataType, FileID attributeValue, IFrameProjectAgent projectAgent_) {
            return AbstractAttributeOwnerDocGenProxy.this.getGraphicsAndFilesHelper().createFileObject(attributeDataType, attributeValue, projectAgent_);
        }
    }

    private class PreProcessingFileFetcher
    implements IFileFetcher<File> {
        private final String fileNamePrefix;

        private PreProcessingFileFetcher(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
        }

        @Override
        public File fetchFile(AbstractDataTypeWithFile attributeDataType, FileID attributeValue, IFrameProjectAgent projectAgent_) {
            return AbstractAttributeOwnerDocGenProxy.this.getGraphicsAndFilesHelper().createPreProcessingFileObject(attributeDataType, attributeValue, projectAgent_, this.fileNamePrefix);
        }
    }
}

