/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.graphicsandfiles;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.graphicsandfiles.FileInReportDescription;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicInReportDescription;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesStore;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.graphicsandfiles.IRawReportFormatSnippetProviderForFiles;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.planagent.AbstractGraphicAdapter;
import com.arcway.cockpit.docgen.provider.planagent.EMFGraphicsAdapter;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.docgen.provider.planagent.PNGGraphicsAdapter;
import com.arcway.cockpit.docgen.provider.planagent.SVGGraphicsAdapter;
import com.arcway.cockpit.docgen.provider.planagent.WMFGraphicsAdapter;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.files.FilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.svg.ILink;
import de.plans.lib.util.FileHelper;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class GraphicsAndFilesHelper
implements IGraphicsAndFilesHelper {
    private static final ILogger logger = Logger.getLogger(GraphicsAndFilesHelper.class);
    private final GraphicsAndFilesStore graphicsAndFilesStore;
    private final String tinyizeContext;
    private final String prefferedImageType;
    private final PlanImageSizeHint preferredImageSize;
    private final IRawReportFormatSnippetProviderForFiles rawReportFormatSnippetProviderForFiles;
    private final PNGGraphicsAdapter pngGraphicsAdapter = new PNGGraphicsAdapter();
    private final SVGGraphicsAdapter svgGraphicsAdapter = new SVGGraphicsAdapter();
    private final WMFGraphicsAdapter wmfGraphicsAdapter = new WMFGraphicsAdapter();
    private final EMFGraphicsAdapter emfGraphicsAdapter = new EMFGraphicsAdapter();
    private final Map<String, AbstractGraphicAdapter> map_imageExtension_graphicsAdapter = new HashMap<String, AbstractGraphicAdapter>();
    private final Map<String, String> map_imageExtension_imageFormat;

    public GraphicsAndFilesHelper(GraphicsAndFilesStore graphicsAndFilesStore, String preferredImageType, PlanImageSizeHint preferredImageSize, IRawReportFormatSnippetProviderForFiles rawReportFormatSnippetProviderForFiles, String tinyizeContext) {
        this.map_imageExtension_graphicsAdapter.put(".png", this.pngGraphicsAdapter);
        this.map_imageExtension_graphicsAdapter.put(".svg", this.svgGraphicsAdapter);
        this.map_imageExtension_graphicsAdapter.put(".wmf", this.wmfGraphicsAdapter);
        this.map_imageExtension_graphicsAdapter.put(".emf", this.emfGraphicsAdapter);
        this.map_imageExtension_imageFormat = new HashMap<String, String>();
        this.map_imageExtension_imageFormat.put(".png", "PNG");
        this.map_imageExtension_imageFormat.put(".svg", "SVG");
        this.map_imageExtension_imageFormat.put(".wmf", "WMF");
        this.map_imageExtension_imageFormat.put(".emf", "EMF");
        this.graphicsAndFilesStore = graphicsAndFilesStore;
        this.prefferedImageType = preferredImageType;
        this.preferredImageSize = preferredImageSize;
        this.rawReportFormatSnippetProviderForFiles = rawReportFormatSnippetProviderForFiles;
        this.tinyizeContext = tinyizeContext;
    }

    @Override
    public String getTinyizeContext() {
        return this.tinyizeContext;
    }

    public PlanImageSizeHint getPreferredImageSize() {
        return this.preferredImageSize;
    }

    @Override
    public GraphicInReportDescription createSVG(IGraphicProvider plan, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle, IProgressDisplay pDisplay) {
        return this.createGraphic(plan, pDisplay, ".svg", roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
    }

    @Override
    public GraphicInReportDescription createWMF(IGraphicProvider plan, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle, IProgressDisplay pDisplay) {
        return this.createGraphic(plan, pDisplay, ".wmf", roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
    }

    @Override
    public GraphicInReportDescription createEMF(IGraphicProvider plan, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle, IProgressDisplay pDisplay) {
        return this.createGraphic(plan, pDisplay, ".emf", roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
    }

    @Override
    public GraphicInReportDescription createPNG(IGraphicProvider plan, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle, IProgressDisplay pDisplay) {
        return this.createGraphic(plan, pDisplay, ".png", roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
    }

    @Override
    public GraphicInReportDescription createPrefferedPlanExport(IGraphicProvider plan, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle, IProgressDisplay pDisplay) {
        if (this.prefferedImageType != null) {
            return this.createGraphic(plan, pDisplay, this.prefferedImageType, roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
        }
        return null;
    }

    private GraphicInReportDescription createGraphic(IGraphicProvider graphicProvider, IProgressDisplay pDisplay, String extension, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle) {
        GraphicInReportDescription description;
        String graphicProviderUID = graphicProvider.getUID();
        File tempImageFile = this.graphicsAndFilesStore.createTemporaryFileForGraphicOrFileObject(graphicProviderUID, extension);
        AbstractGraphicAdapter graphicAdapter = this.map_imageExtension_graphicsAdapter.get(extension);
        if (graphicAdapter == null) {
            logger.warn("Graphic creation failed - unknown image format: " + extension);
            throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesHelper.UnknownImageFormatMessage"));
        }
        if (graphicProvider.launch(pDisplay)) {
            try {
                try {
                    description = this.createImage(tempImageFile, graphicProvider, graphicAdapter, extension, roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
                }
                catch (EXEmptyResult e) {
                    description = null;
                }
                catch (PrintingFailure e) {
                    logger.error((Throwable)e);
                    throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesHelper.GraphicCreationFailedMessage"));
                }
            }
            finally {
                graphicProvider.close();
            }
        } else {
            logger.warn("Graphic creation failed - could not launch graphic provider");
            throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesHelper.GraphicCreationFailedMessage"));
        }
        return description;
    }

    private GraphicInReportDescription createImage(File tempImageFile, IGraphicProvider plan, AbstractGraphicAdapter graphicAdapter, String extension, Map<String, String> roleMapOfPresentationElements, String styleSheetFilename, Map<String, ILink> linkMapOfPresentationElements, ForcedViewRectangle forcedViewRectangle) throws EXEmptyResult, PrintingFailure {
        GraphicInReportDescription description = null;
        Dimension graphicSize = graphicAdapter.export(this.preferredImageSize, plan, roleMapOfPresentationElements, styleSheetFilename, linkMapOfPresentationElements, forcedViewRectangle);
        try {
            graphicAdapter.save(tempImageFile);
            String tempImageName = tempImageFile.getName();
            description = new GraphicInReportDescription(tempImageName, plan.getName(), graphicSize.width, graphicSize.height, this.map_imageExtension_imageFormat.get(extension));
            if (logger.isDebugEnabled()) {
                logger.debug("createImage() - Plan image created : tempImageFile = " + tempImageFile + ", graphicSize = " + graphicSize);
            }
        }
        finally {
            graphicAdapter.disposeImages();
        }
        return description;
    }

    @Override
    public FileInReportDescription createFileObject(AbstractDataTypeWithFile attributeDataType, FileID attributeValue, IFrameProjectAgent projectAgent) {
        FileMetaInformationItem metaInformation = projectAgent.getFilesManager().getFileMetaInformation(attributeValue);
        String loggerMessage = "Could not fetch file copy for report file name: " + metaInformation.getOriginalFileName();
        try {
            File fileFromArchive = attributeDataType.getFileCopy((Object)attributeValue);
            File fileInFileStore = this.createTempFileObject(fileFromArchive, null);
            FileInReportDescription description = new FileInReportDescription(fileInFileStore.getName(), metaInformation.getOriginalFileName());
            if (logger.isDebugEnabled()) {
                logger.debug("createFileObject() - File object created : tempFile = " + fileInFileStore);
            }
            return description;
        }
        catch (ServerNotAvailableException e) {
            logger.error(loggerMessage, (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error(loggerMessage, (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error(loggerMessage, (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error(loggerMessage, (Throwable)e);
        }
        catch (ExPrematureEndOfTransfer e) {
            logger.error(loggerMessage, (Throwable)e);
        }
        return null;
    }

    @Override
    public File createPostProcessingFileObject(AbstractDataTypeWithFile attributeDataType, FileID attributeValue, IFrameProjectAgent projectAgent, String fileNamePrefix) {
        File fileFromArchive = this.createPreProcessingFileObject(attributeDataType, attributeValue, projectAgent, fileNamePrefix);
        File fileInFileStore = fileFromArchive == null ? null : this.createTempFileObject(fileFromArchive, fileNamePrefix);
        return fileInFileStore;
    }

    @Override
    public File createPreProcessingFileObject(final AbstractDataTypeWithFile attributeDataType, final FileID attributeValue, IFrameProjectAgent projectAgent, String fileNamePrefix) {
        FileMetaInformationItem metaInformation = projectAgent.getFilesManager().getFileMetaInformation(attributeValue);
        final String loggerMessage = "Could not fetch file copy for report file name: " + metaInformation.getOriginalFileName();
        final File[] fileFromArchive = new File[1];
        FilesManager.doWithPrefix((String)fileNamePrefix, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    fileFromArchive[0] = attributeDataType.getFileCopy((Object)attributeValue);
                }
                catch (ServerNotAvailableException e) {
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (EXServerException e) {
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error(loggerMessage, (Throwable)e);
                }
                catch (ExPrematureEndOfTransfer e) {
                    logger.error(loggerMessage, (Throwable)e);
                }
            }
        });
        return fileFromArchive[0];
    }

    @Override
    public File createTempFileObject(File file, String fileNamePrefix) {
        File fileInFileStore = this.graphicsAndFilesStore.storeFileInTemporaryDirectory(file, fileNamePrefix);
        return fileInFileStore;
    }

    @Override
    public File createTempFileObject(String prefix, String extension) {
        File fileInFileStore = this.graphicsAndFilesStore.createTemporaryFileForGraphicOrFileObject(prefix, extension);
        return fileInFileStore;
    }

    @Override
    public String getSnippetForGraphicInRawReportFormat(GraphicInReportDescription graphicInReportDescr) {
        assert (this.rawReportFormatSnippetProviderForFiles != null);
        return this.rawReportFormatSnippetProviderForFiles.getSnippetForFileInRawReportFormat(graphicInReportDescr.getGraphicFileName(), graphicInReportDescr.getGraphicDisplayName(), graphicInReportDescr.getFormat(), graphicInReportDescr.getWidth(), graphicInReportDescr.getHeight());
    }

    @Override
    public String getSnippetForFileInRawReportFormat(FileInReportDescription fileInReportDescr, double with_mm, double height_mm) {
        assert (this.rawReportFormatSnippetProviderForFiles != null);
        return this.rawReportFormatSnippetProviderForFiles.getSnippetForFileInRawReportFormat(fileInReportDescr.getFileName(), fileInReportDescr.getOriginalFileName(), FileHelper.getFileType((String)fileInReportDescr.getOriginalFileName()), with_mm, height_mm);
    }
}

