/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.core;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.IProgressReporter;
import com.arcway.cockpit.docgen.core.velocity.Velocity15_2_Cockpit_LogChute;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class VelocityEngineWithProgress
implements IProgressReporter {
    private static final ILogger logger = Logger.getLogger(VelocityEngineWithProgress.class);
    public static final String PROGRESS_REPORTER_KEY = "ProgressReporter";
    private final boolean cancelable;
    private ProgressMonitorDialog pmd;

    public VelocityEngineWithProgress(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public boolean mergeTemplate(final VelocityEngine engine, final String templateName, final String encoding, final Context context, final Writer writer) throws Exception {
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(Messages.getString("ReportGenerator.InfoPreprocessing"), -1);
                        context.put(VelocityEngineWithProgress.PROGRESS_REPORTER_KEY, (Object)VelocityEngineWithProgress.this);
                        engine.mergeTemplate(templateName, encoding, context, writer);
                        monitor.done();
                    }
                    catch (Exception rgE) {
                        throw new InvocationTargetException(rgE);
                    }
                }
                finally {
                    Velocity15_2_Cockpit_LogChute.reportErrors();
                }
            }
        };
        boolean hasBeenCanceled = false;
        this.pmd = new ProgressMonitorDialog(new Shell());
        try {
            boolean threadable = false;
            this.pmd.run(threadable, this.cancelable, rwp);
        }
        catch (Throwable e1) {
            Throwable targetOfTarget;
            Throwable target = e1;
            if (target instanceof InvocationTargetException) {
                target = ((InvocationTargetException)target).getTargetException();
            }
            if (target instanceof MethodInvocationException && (targetOfTarget = ((MethodInvocationException)target).getWrappedThrowable()) instanceof InterruptedException) {
                target = targetOfTarget;
            }
            if (target instanceof InterruptedException) {
                hasBeenCanceled = true;
            }
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            String title = Messages.getString("ReportGenerator.UnknownExceptionTitle");
            String message = Messages.getString("ReportGenerator.UnknownExceptionMessage");
            throw new ReportGenerationException(title, message, target);
        }
        if (this.pmd.getProgressMonitor().isCanceled()) {
            hasBeenCanceled = true;
        }
        return hasBeenCanceled;
    }

    @Override
    public void checkForCancelation() throws ReportGenerationCanceledException {
        final boolean[] isCanceled = new boolean[1];
        Display display = this.pmd.getShell().getDisplay();
        while (display.readAndDispatch()) {
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                isCanceled[0] = VelocityEngineWithProgress.this.pmd.getProgressMonitor().isCanceled();
            }
        });
        if (isCanceled[0]) {
            Velocity15_2_Cockpit_LogChute.suppressErrors();
            throw new ReportGenerationCanceledException();
        }
    }

    @Override
    public void reportProgress(final String message) throws ReportGenerationCanceledException {
        this.pmd.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                VelocityEngineWithProgress.this.pmd.getProgressMonitor().subTask(message);
            }
        });
        this.checkForCancelation();
    }
}

