/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.core;

import com.arcway.cockpit.docgen.consoleui.util.DummyReportOutputTemplate;
import com.arcway.cockpit.docgen.consoleui.util.DummyReportTemplate;
import com.arcway.cockpit.docgen.core.AbstractVelocityReportProcessor;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportOutputtemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.ui.IWorkbenchPage;

public class NonUIVelocityReportProcessor
extends AbstractVelocityReportProcessor {
    private static final ILogger logger = Logger.getLogger(NonUIVelocityReportProcessor.class);
    public static final String INFIX_PREFIX = "[-[";
    public static final String INFIX_POSTFIX = "]-]";
    private final IDocGeneratorProjectAgent projectAgent;
    private final Locale reportLocale;
    private final IReportTemplateRW reportTemplate;
    private final IReportType reportType;
    private final String outputFileName;
    private final IReportOutputtemplateRW reportOutputTemplate;
    private String errorMessage = null;
    private final Map<String, Object> varArgs;
    private final Integer timeOutInSeconds;
    private final IWorkbenchPage workbenchPage;
    private final Map<String, List<IFilterItemProvider>> projectUID2filterItems;

    public NonUIVelocityReportProcessor(IDocGeneratorProjectAgent p_projectAgent, Locale reportLocale, String reportTypeID, String templateFileName, IDocGeneratorProjectAgent p_projectAgentForOutputTemplate, String outputTemplateFileName, String outputFileName, String name, String description, Integer imageWidthInMM, Integer imageHeightInMM, Map<String, Object> varArgs, Integer timeOutInSeconds, IWorkbenchPage workbenchPage, Map<String, List<IFilterItemProvider>> projectUID2filterItems) {
        this.projectAgent = p_projectAgent;
        this.reportLocale = reportLocale == null && p_projectAgent != null ? p_projectAgent.getProjectLocale() : reportLocale;
        this.reportTemplate = this.determineReportTemplate(p_projectAgent, templateFileName);
        this.reportType = this.determineReportType(reportTypeID);
        this.outputFileName = outputFileName;
        this.reportOutputTemplate = this.determineReportOutputTemplate(p_projectAgentForOutputTemplate == null ? p_projectAgent : p_projectAgentForOutputTemplate, outputTemplateFileName, name, description, imageWidthInMM, imageHeightInMM);
        this.varArgs = varArgs;
        this.timeOutInSeconds = timeOutInSeconds;
        this.workbenchPage = workbenchPage;
        this.projectUID2filterItems = projectUID2filterItems;
    }

    private IReportTemplateRW determineReportTemplate(IDocGeneratorProjectAgent projectAgentForTemplate, String templateFileName) {
        if (templateFileName == null) {
            this.setErrorMessage("template is not specified");
            return null;
        }
        if (templateFileName.startsWith(INFIX_PREFIX) && templateFileName.endsWith(INFIX_POSTFIX)) {
            String templateInfix = templateFileName.substring(INFIX_PREFIX.length(), templateFileName.length() - INFIX_POSTFIX.length());
            if (projectAgentForTemplate == null) {
                this.setErrorMessage("template: template with infix " + templateInfix + " not found: no project specified.");
                return null;
            }
            IReportTemplateFolder rootReportTemplateFolder = projectAgentForTemplate.getRootReportTemplateFolder();
            IReportTemplateRW template = NonUIVelocityReportProcessor.findReportTemplate(projectAgentForTemplate, rootReportTemplateFolder, templateInfix);
            if (template == null) {
                this.setErrorMessage("template: template with infix " + templateInfix + " not found in project " + projectAgentForTemplate.getProjectName() + ".");
                return null;
            }
            return template;
        }
        File templateFile = new File(templateFileName);
        if (!templateFile.exists()) {
            this.setErrorMessage("template file: " + templateFileName + " not found.");
            return null;
        }
        return new DummyReportTemplate(templateFileName, projectAgentForTemplate != null ? projectAgentForTemplate.getProjectUID() : null);
    }

    private static IReportTemplateRW findReportTemplate(IDocGeneratorProjectAgent projectAgent, IReportTemplateFolder reportTemplateFolder, String infix) {
        IReportTemplate found = null;
        List childReportTemplates = projectAgent.getChildReportTemplates(reportTemplateFolder);
        for (IReportTemplate childReportTemplate : childReportTemplates) {
            String name = childReportTemplate.getName();
            if (!name.contains(infix)) continue;
            found = childReportTemplate;
            break;
        }
        if (found == null) {
            List childReportTemplateFolders = projectAgent.getChildReportTemplateFolders(reportTemplateFolder);
            for (IReportTemplateFolder childReportTemplateFolder : childReportTemplateFolders) {
                found = NonUIVelocityReportProcessor.findReportTemplate(projectAgent, childReportTemplateFolder, infix);
                if (found != null) break;
            }
        }
        return (IReportTemplateRW)found;
    }

    private IReportOutputtemplateRW determineReportOutputTemplate(IDocGeneratorProjectAgent projectAgentForTemplate, String outputTemplateFileName, String name, String description, Integer imageWidthInMM, Integer imageHeightInMM) {
        if (this.reportType != null && this.reportType.getRequiredOutputTemplateTypeID() != null) {
            if (outputTemplateFileName == null) {
                this.setErrorMessage("output template is required but not specified");
                return null;
            }
            if (outputTemplateFileName.startsWith(INFIX_PREFIX) && outputTemplateFileName.endsWith(INFIX_POSTFIX)) {
                String outputTemplateInfix = outputTemplateFileName.substring(INFIX_PREFIX.length(), outputTemplateFileName.length() - INFIX_POSTFIX.length());
                if (projectAgentForTemplate == null) {
                    this.setErrorMessage("output template: template with infix " + outputTemplateInfix + " not found: no project specified.");
                    return null;
                }
                IReportTemplateFolder rootReportTemplateFolder = projectAgentForTemplate.getRootReportTemplateFolder();
                IReportOutputtemplateRW outputTemplate = NonUIVelocityReportProcessor.findReportOutputTemplate(projectAgentForTemplate, rootReportTemplateFolder, outputTemplateInfix);
                if (outputTemplate == null) {
                    this.setErrorMessage("output template: output template with infix " + outputTemplateInfix + " not found in project " + projectAgentForTemplate.getProjectName() + ".");
                    return null;
                }
                return outputTemplate;
            }
            File outputTemplateFile = new File(outputTemplateFileName);
            if (!outputTemplateFile.exists()) {
                this.setErrorMessage("output template file: " + outputTemplateFileName + " not found.");
                return null;
            }
            return new DummyReportOutputTemplate(outputTemplateFile.getAbsolutePath(), name, description, imageWidthInMM, imageHeightInMM);
        }
        return null;
    }

    private static IReportOutputtemplateRW findReportOutputTemplate(IDocGeneratorProjectAgent projectAgent, IReportTemplateFolder reportTemplateFolder, String infix) {
        IReportOutputTemplate found = null;
        List childReportTemplates = projectAgent.getChildReportOutputTemplates(reportTemplateFolder);
        for (IReportOutputTemplate childReportTemplate : childReportTemplates) {
            String name = childReportTemplate.getName();
            if (!name.contains(infix)) continue;
            found = childReportTemplate;
            break;
        }
        if (found == null) {
            List childReportTemplateFolders = projectAgent.getChildReportTemplateFolders(reportTemplateFolder);
            for (IReportTemplateFolder childReportTemplateFolder : childReportTemplateFolders) {
                found = NonUIVelocityReportProcessor.findReportOutputTemplate(projectAgent, childReportTemplateFolder, infix);
                if (found != null) break;
            }
        }
        return (IReportOutputtemplateRW)found;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IReportType determineReportType(String optionalReportTypeID) {
        String reportTypeID;
        Collection possibleReportTypes = DocGeneratorManager.getPossibleReportTypes((IReportTemplate)this.reportTemplate, (boolean)true);
        if (optionalReportTypeID == null) {
            if (possibleReportTypes.size() != 1) {
                this.setErrorMessage("parameter reporttype is missing");
                return null;
            }
            reportTypeID = ((IReportType)possibleReportTypes.iterator().next()).getID();
        } else {
            reportTypeID = optionalReportTypeID;
        }
        IReportType determinedReportType = DocGeneratorManager.getReportType((String)reportTypeID);
        if (determinedReportType == null) {
            this.setErrorMessage("invalid report type parameter: " + reportTypeID);
            return null;
        }
        return determinedReportType;
    }

    private void setErrorMessage(String errorMessage) {
        if (this.errorMessage == null) {
            this.errorMessage = errorMessage;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        try {
            ReportResultFileType outputFileType;
            ReportJob reportJob = this.projectAgent != null ? new ReportJob(this.projectAgent, this.reportLocale) : new ReportJob(this.reportLocale);
            reportJob.setReportTemplate((IReportTemplate)this.reportTemplate);
            reportJob.setReportType(this.reportType);
            reportJob.setOutputTemplate((IReportOutputTemplate)this.reportOutputTemplate);
            if (this.timeOutInSeconds != null) {
                reportJob.setTimeOutInSeconds(this.timeOutInSeconds.intValue());
            }
            if ((outputFileType = this.getOutputFileType(reportJob)) != ReportResultFileType.NO_OUTPUT && !this.reportType.hasDeterminedOutputFile()) {
                if (this.outputFileName == null) {
                    return "parameter outputfilename is missing";
                }
                reportJob.setReportFileName(this.outputFileName);
            }
            reportJob.setFilterSettings(this.projectUID2filterItems);
            reportJob.setVarArgs(this.varArgs);
            this.generateReport(reportJob, this.workbenchPage);
            return null;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    private ReportResultFileType getOutputFileType(ReportJob reportJob) {
        String outputFormatID;
        IReportOutputFormat outputFormat;
        ReportResultFileType outputFileType = ReportResultFileType.NO_OUTPUT;
        if (this.reportType != null && this.projectAgent != null && (outputFormat = this.projectAgent.getReportOutputFormat(outputFormatID = this.reportType.getOutputFormat(reportJob.getReportTemplate()))) != null) {
            outputFileType = outputFormat.getOutputFileType();
        }
        return outputFileType;
    }
}

