/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.core;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.ExtensionMgr;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.core.ReportController;
import com.arcway.cockpit.docgen.core.VelocityEngineWithProgress;
import com.arcway.cockpit.docgen.core.VelocityLogger;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.core.velocity.Velocity15_2_Cockpit_LogChute;
import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.IAbstractReportProvider;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.interfaces.IReportController;
import com.arcway.cockpit.docgen.writer.DocumentationWriterProvider;
import com.arcway.cockpit.docgen.writer.IDocumentationWriter;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.ReportTemplateHeaders;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ConfigurationMgr;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.ReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IResultLauncher;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import com.arcway.cockpit.frame.client.project.docgenerator.reportinfo.ReportMetaInfo;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;

public class AbstractVelocityReportProcessor {
    private static final String TEMPLATE_HEADER_TEMPLATE_ENCODING_DEFAULT_VALUE = "UTF-8";
    private static final String TEMPLATE_HEADER_TARGET_ENCODING_DEFAULT_VALUE = "UTF-8";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String OUTPUT_FORMAT_ID = "outputFormatId";
    public static final String OUTPUT_TEMPLATE_NAME = "outputTemplateName";
    public static final String OUTPUT_TEMPLATE_DESCRIPTION = "outputTemplateDescription";
    public static final String PAGE_SIZE_HINT_ID = "pageSizeHint";
    public static final String VELOCITY_LOGGER_KEY = "logger";
    public static final String JAVA_MATH_ID = "javaMath";
    public static final String REPORT_CONTROLLER_KEY = "reportController";
    private static final List<Tuple<String, String>> VELOCITYENGINE_PROPERTIES_TOBESET = new ArrayList<Tuple<String, String>>();
    private static final List<Tuple<String, String>> VELOCITYENGINE_PROPERTIES_TOBEADDED;

    static {
        VELOCITYENGINE_PROPERTIES_TOBESET.add((Tuple<String, String>)new Tuple((Object)"runtime.log.logsystem.class", (Object)Velocity15_2_Cockpit_LogChute.class.getName()));
        VELOCITYENGINE_PROPERTIES_TOBEADDED = new ArrayList<Tuple<String, String>>();
        VELOCITYENGINE_PROPERTIES_TOBEADDED.add((Tuple<String, String>)new Tuple((Object)"resource.loader", (Object)"fileloader"));
        VELOCITYENGINE_PROPERTIES_TOBEADDED.add((Tuple<String, String>)new Tuple((Object)"fileloader.resource.loader.name", (Object)"File Loader"));
        VELOCITYENGINE_PROPERTIES_TOBEADDED.add((Tuple<String, String>)new Tuple((Object)"fileloader.resource.loader.class", (Object)"com.arcway.cockpit.docgen.core.velocity.DirectFileResourceLoader"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateReport(ReportJob reportJob, IWorkbenchPage currentPage) throws ReportGenerationException {
        File outputFile;
        IReportType reportType = reportJob.getReportType();
        ReportResultFileType reportResultFileType = reportJob.getReportFileType();
        if (reportResultFileType != ReportResultFileType.NO_OUTPUT && reportType.hasDeterminedOutputFile() && (outputFile = reportType.determineOutputFile(reportJob)) != null) {
            reportJob.setReportFileName(outputFile.getAbsolutePath());
        }
        ReportController reportController = new ReportController();
        try {
            IReportTemplate teportTemplate;
            File file;
            boolean hasBeenCanceled;
            Map<String, String> reportTemplateHeader;
            File tempReportFile;
            String tinyizeContext;
            IResultLauncher resultLauncher;
            List outputTemplateDescription;
            String outputTemplateName;
            VelocityReportJob velocityReportJob = new VelocityReportJob(reportJob);
            String reportTypeID = reportType.getID();
            IDocumentationWriter writer = DocumentationWriterProvider.getDocumentationWriter(reportTypeID);
            IReportOutputTemplate outputTemplate = velocityReportJob.getBaseReportJob().getOutputTemplate();
            if (outputTemplate != null) {
                outputTemplateName = outputTemplate.getName();
                outputTemplateDescription = StringUtil.splitTextLines((String)outputTemplate.getDescription());
            } else {
                outputTemplateName = null;
                outputTemplateDescription = null;
            }
            PlanImageSizeHint imageSizeHint = writer.getPreferredImageSize();
            if (outputTemplate != null) {
                Integer imageWidth = outputTemplate.getImageWidthMM();
                Integer imageHeight = outputTemplate.getImageHeightMM();
                if (imageWidth != null && imageWidth > 0 || imageHeight != null && imageHeight > 0) {
                    Dimension d = imageSizeHint.getPreferredSizeInMM();
                    double resolution = imageSizeHint.getResolution();
                    if (imageWidth != null && imageWidth > 0) {
                        d.width = imageWidth.intValue();
                    }
                    if (imageHeight != null && imageHeight > 0) {
                        d.height = imageHeight.intValue();
                    }
                    imageSizeHint = PlanImageSizeHint.getSizeHintInMM(d, resolution);
                }
            }
            if ((resultLauncher = reportType.getResultLauncher()) != null) {
                tinyizeContext = resultLauncher.getTinyizeContext(reportJob.getReportFilename());
                ICOCKPITEclipseClientController.INSTANCE.freeTinyContext(tinyizeContext);
            } else {
                tinyizeContext = null;
            }
            GraphicsAndFilesHelper graphicsProvider = new GraphicsAndFilesHelper(velocityReportJob.getGraphicsAndFilesStore(), writer.getPreferredImageType(), imageSizeHint, writer, tinyizeContext);
            File templateFile = velocityReportJob.getBaseReportJob().getReportTemplateFile();
            try {
                tempReportFile = SessionTempDirectoryManager.createSessionTempFile((String)"rep", (String)".tmp");
                tempReportFile.deleteOnExit();
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                throw new ReportGenerationException(Messages.getString("GraphicsAndFilesStore.CantCreateTempFile.Title"), Messages.getString("GraphicsAndFilesStore.CantCreateTempFile.Message"), (Throwable)jeriE);
            }
            try {
                reportTemplateHeader = ReportTemplateHeaders.readASCIIHeader(templateFile);
                reportJob.setReportTemplateHeader(reportTemplateHeader);
            }
            catch (IOException ioE) {
                String title = Messages.getString("ReportGenerator.IOExceptionTitle");
                String message = Messages.getString("ReportGenerator.IOExceptionMessage");
                throw new ReportGenerationException(title, message, (Throwable)ioE);
            }
            boolean cancelable = ReportTemplateHeaders.isHeaderParameterTrue(reportTemplateHeader, "cancelable");
            VelocityEngineWithProgress velocityEngineWithProgress = new VelocityEngineWithProgress(cancelable);
            VelocityLogger velocityLogger = new VelocityLogger(velocityEngineWithProgress);
            Map varArgs = reportJob.getVarArgs();
            try {
                try {
                    String outputFileName = reportJob.getReportFilename();
                    reportJob.getProjectAgent();
                    hasBeenCanceled = AbstractVelocityReportProcessor.generateRawReportUsingVelocityEngine(velocityEngineWithProgress, templateFile, reportJob.getReportTemplateHeader(), tempReportFile, AbstractVelocityReportProcessor.getVelocityContext(velocityReportJob.getBaseReportJob().getReportType().getID(), velocityReportJob.getBaseReportJob().getProjectAgent(), outputFileName, outputTemplateName, outputTemplateDescription, graphicsProvider, writer, velocityReportJob.getBaseReportJob().getPresentationContext(), velocityReportJob.getBaseReportJob().getFilters(), velocityReportJob.getBaseReportJob().getDocGeneratorEngineConfiguration(), varArgs, velocityLogger, reportController, currentPage));
                    if (hasBeenCanceled) {
                        velocityLogger.debug("Merging velocity template canceled. Size of intermediate result: " + tempReportFile.length() + " bytes.");
                        velocityLogger.info("Report generation canceled by the user");
                    } else {
                        velocityLogger.debug("Successfully merged velocity template. Size of intermediate result: " + tempReportFile.length() + " bytes.");
                    }
                }
                catch (Exception e) {
                    velocityLogger.debug("Failed to merge velocity template. Size of (incomplete) intermediate result: " + tempReportFile.length() + " bytes.");
                    throw e;
                }
            }
            finally {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)templateFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    velocityLogger.warn("Could not delete obsolete temporary copy of report template file.", e);
                }
            }
            if (!hasBeenCanceled) {
                velocityReportJob.setRawReportFile(tempReportFile);
                writer.postProcess(velocityReportJob, currentPage);
            }
            switch (reportResultFileType) {
                case DIRECTORY: {
                    if (!reportController.isWriteReportInfo()) break;
                    File reportDir = new File(reportJob.getReportFilename());
                    assert (AbstractVelocityReportProcessor.assertPostprocessingResultFileListIsComplete(reportDir, reportJob.getReportResultFiles()));
                    ReportMetaInfo.writeReportInfo((String)reportDir.getName(), (String)reportType.getDisplayName(), (String)reportJob.getProjectAgent().getProjectName(), (long)System.currentTimeMillis(), (File)reportDir, (Collection)reportJob.getReportResultFiles());
                    break;
                }
                case FILE: {
                    assert (reportJob.getReportResultFiles().size() == 1);
                    break;
                }
                case NO_OUTPUT: {
                    assert (reportJob.getReportResultFiles().isEmpty());
                    break;
                }
            }
            File targetFile = null;
            if (reportController.isOverwriteResultFile()) {
                targetFile = reportController.getResultFile();
            } else {
                ReportResultFileType reportFileType = reportJob.getReportFileType();
                if (reportFileType != ReportResultFileType.NO_OUTPUT) {
                    String filename;
                    String string = filename = reportFileType == ReportResultFileType.DIRECTORY ? reportJob.getReportMainFileName() : reportJob.getReportFilename();
                    if (filename == null) throw new ReportGenerationException("No file name given", "The report processor did non return a file name.", null);
                    File file2 = new File(filename);
                    if (!file2.exists()) throw new ReportGenerationException("File not found", "The report processor returned a non existing file name. " + reportFileType + ": >" + filename + "<", null);
                    targetFile = file2;
                }
            }
            reportJob.setReportMainFileName(targetFile == null ? null : targetFile.getAbsolutePath());
            velocityReportJob.getGraphicsAndFilesStore().dispose();
            try {
                FileHelper.deleteExistingFileOrDirectory((File)tempReportFile);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                velocityLogger.warn("Could not delete obsolete intermediate report result file.", jeriE);
            }
            String filename = reportJob.getReportMainFileName();
            if (filename == null || !(file = new File(filename)).exists() || resultLauncher == null || (teportTemplate = reportJob.getReportTemplate()) == null) return;
            DocGenConfigurationPerReport docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(teportTemplate.getUID(), reportJob.getProjectAgent().getProjectUID());
            ReportParameters reportParameters = new ReportParameters(reportJob, docGenConfiguration);
            resultLauncher.showResult(currentPage, file, new File(reportJob.getReportFilename()), (IReportParameters)reportParameters);
            return;
        }
        catch (ReportGenerationException rgE) {
            throw rgE;
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("ReportGenerator.ExceptionTitle"), Messages.getString("ReportGenerator.ExceptionMessage"), (Throwable)e);
        }
    }

    private static boolean assertPostprocessingResultFileListIsComplete(File reportDir, Collection<File> reportFiles) {
        HashSet<File> reportFileSet = new HashSet<File>(reportFiles);
        ArrayList<File> remainingDirs = new ArrayList<File>();
        HashSet<File> reportDirContents = new HashSet<File>();
        File nextDir = reportDir;
        do {
            File[] fileArray = nextDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                reportDirContents.add(file);
                if (file.isDirectory()) {
                    remainingDirs.add(file);
                }
                ++n2;
            }
        } while ((nextDir = remainingDirs.isEmpty() ? null : (File)remainingDirs.remove(0)) != null);
        return reportFileSet.containsAll(reportDirContents) && (reportFileSet.size() == reportDirContents.size() || reportFileSet.size() == reportDirContents.size() + 1 && reportFileSet.contains(reportDir));
    }

    private static VelocityContext getVelocityContext(String outputFormatID, IDocGeneratorProjectAgent projectAgent, String outputFile, String outputTemplateName, List<String> outputTemplateDescription, GraphicsAndFilesHelper graphicsProvider, IDocumentationWriter writer, PresentationContext presentationContext, Map<String, Collection<AbstractFilter>> filters, DocGenConfigurationItem velocityConfigurationItem, Map<String, Object> varArgs, VelocityLogger velocityLogger, IReportController reportController, IWorkbenchPage currentPage) {
        boolean projectRelated = projectAgent != null;
        VelocityContext context = new VelocityContext();
        if (varArgs != null) {
            IRecord varArgsRecord = AbstractVelocityReportProcessor.convertVarArgsToRecord(varArgs, graphicsProvider, presentationContext.getLocale(), true);
            for (String string : varArgsRecord.getKeySet()) {
                Object value = varArgsRecord.get(string);
                context.put(string, value);
            }
        }
        context.put(OUTPUT_FILE, (Object)outputFile);
        context.put(OUTPUT_FORMAT_ID, (Object)outputFormatID);
        if (outputTemplateName != null) {
            context.put(OUTPUT_TEMPLATE_NAME, (Object)outputTemplateName);
        }
        if (outputTemplateDescription != null) {
            context.put(OUTPUT_TEMPLATE_DESCRIPTION, outputTemplateDescription);
        }
        context.put(PAGE_SIZE_HINT_ID, (Object)graphicsProvider.getPreferredImageSize());
        context.put(JAVA_MATH_ID, Math.class);
        context.put(VELOCITY_LOGGER_KEY, (Object)velocityLogger);
        context.put(REPORT_CONTROLLER_KEY, (Object)reportController);
        HashMap<String, IAbstractReportProvider> reportDataProviders = new HashMap<String, IAbstractReportProvider>();
        reportDataProviders.putAll(ExtensionMgr.createReportRelatedReportDataProviders(filters, presentationContext, graphicsProvider, !projectRelated, currentPage));
        reportDataProviders.putAll(ExtensionMgr.createReportTemplateRelatedReportDataProviders(velocityConfigurationItem, filters, presentationContext, graphicsProvider, currentPage));
        if (projectRelated) {
            reportDataProviders.putAll(ExtensionMgr.createProjectRelatedReportDataProviders(graphicsProvider, filters, presentationContext, projectAgent, projectRelated, currentPage));
        }
        for (Map.Entry entry : reportDataProviders.entrySet()) {
            String contextKey = (String)entry.getKey();
            IAbstractReportProvider reportProvider = (IAbstractReportProvider)entry.getValue();
            DocGenConfigurationItem reportProviderConfiguration = velocityConfigurationItem.getChild(contextKey);
            if (reportProviderConfiguration == null) {
                reportProviderConfiguration = new DocGenConfigurationItem(contextKey);
                velocityConfigurationItem.addChild(reportProviderConfiguration);
            }
            context.put(contextKey, (Object)reportProvider);
        }
        return context;
    }

    private static IRecord convertVarArgsToRecord(Map<String, Object> varArgs, GraphicsAndFilesHelper graphicsAndFilesHelper, Locale locale, boolean childrenOnly) {
        Record record = new Record(graphicsAndFilesHelper, locale);
        Map attributes = (Map)varArgs.get("attributes");
        for (Map.Entry attribute : attributes.entrySet()) {
            String key = (String)attribute.getKey();
            String value = (String)attribute.getValue();
            record.set(key, value);
        }
        List children = (List)varArgs.get("children");
        for (Map child : children) {
            String role = (String)child.get("name");
            IRecord childRecord = AbstractVelocityReportProcessor.convertVarArgsToRecord(child, graphicsAndFilesHelper, locale, false);
            record.add(role, childRecord);
        }
        return record;
    }

    private static boolean generateRawReportUsingVelocityEngine(VelocityEngineWithProgress velocityEngineWithProgress, File templateFile, Map<String, String> header, File reportFile, VelocityContext velocityContext) throws ReportGenerationException {
        boolean hasBeenCanceled;
        VelocityEngine engine;
        try {
            String directiveParseMaxDepth;
            Velocity15_2_Cockpit_LogChute.reportErrors();
            engine = new VelocityEngine();
            AbstractVelocityReportProcessor.initialiseVelocityEngine(engine);
            String velocimacroMaxDepth = ReportTemplateHeaders.getHeaderParameter(header, "velocimacroMaxDepth", null);
            if (velocimacroMaxDepth != null) {
                engine.setProperty("velocimacro.max.depth", (Object)velocimacroMaxDepth);
            }
            if ((directiveParseMaxDepth = ReportTemplateHeaders.getHeaderParameter(header, "directiveParseMaxDepth", null)) != null) {
                engine.setProperty("directive.parse.max.depth", (Object)directiveParseMaxDepth);
            }
            if (ReportTemplateHeaders.isHeaderParameterTrue(header, "realLocalVariables")) {
                engine.setProperty("velocimacro.context.localscope", (Object)Boolean.TRUE);
            }
            engine.init();
        }
        catch (Exception e) {
            throw new ReportGenerationException(Messages.getString("VelocityReportProcessor.VelocityInitialisationProblem.Title"), Messages.getString("VelocityReportProcessor.VelocityInitialisationProblem.Message"), (Throwable)e);
        }
        try {
            String templateEncoding = ReportTemplateHeaders.getHeaderParameter(header, "templateEncoding", "UTF-8");
            String targetEncoding = ReportTemplateHeaders.getHeaderParameter(header, "targetEncoding", "UTF-8");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), targetEncoding));
            hasBeenCanceled = velocityEngineWithProgress.mergeTemplate(engine, templateFile.getAbsolutePath(), templateEncoding, (Context)velocityContext, writer);
            writer.flush();
            writer.close();
        }
        catch (ResourceNotFoundException rnfe) {
            String title = Messages.getString("ReportGenerator.TemplateNotFoundTitle");
            String message = NLS.bind((String)Messages.getString("ReportGenerator.TemplateNotFoundMessage"), (Object)templateFile);
            throw new ReportGenerationException(title, message, (Throwable)rnfe);
        }
        catch (ParseErrorException pee) {
            String title = Messages.getString("ReportGenerator.SyntaxErrorTitle");
            String msg = Messages.getString("ReportGenerator.SyntaxErrorMsg");
            msg = String.valueOf(msg) + pee.getLocalizedMessage();
            throw new ReportGenerationException(title, msg, (Throwable)pee);
        }
        catch (MethodInvocationException mIE) {
            String title = Messages.getString("ReportGenerator.RuntimeErrorTitle");
            String msg = String.valueOf(Messages.getString("ReportGenerator.RuntimeErrorMsg1")) + " \"" + mIE.getMethodName() + "\" " + Messages.getString("ReportGenerator.RuntimeErrorMsg2") + " \"" + mIE.getReferenceName() + "\" " + Messages.getString("ReportGenerator.RuntimeErrorMsg3");
            int line = mIE.getLineNumber();
            int column = mIE.getColumnNumber();
            msg = line != -1 && column != -1 ? String.valueOf(msg) + " [" + Messages.getString("ReportGenerator.RuntimeErrorMsg5") + " " + line + ", " + Messages.getString("ReportGenerator.RuntimeErrorMsg6") + " " + column + "]:\n\n" : String.valueOf(msg) + ":\n\n";
            if (mIE.getWrappedThrowable() instanceof ReportDataProviderException) {
                ReportDataProviderException rdpe = (ReportDataProviderException)mIE.getWrappedThrowable();
                msg = mIE.getMethodName().equals("abort") && !rdpe.showDetailedInformation() ? mIE.getWrappedThrowable().getMessage() : String.valueOf(msg) + mIE.getWrappedThrowable().getMessage();
            } else {
                msg = String.valueOf(msg) + Messages.getString("ReportGenerator.RuntimeErrorMsg4");
                if (mIE.getWrappedThrowable() != null) {
                    msg = String.valueOf(msg) + " (" + mIE.getWrappedThrowable().getClass().getName() + ")";
                }
            }
            throw new ReportGenerationException(title, msg, (Throwable)mIE);
        }
        catch (IOException ioE) {
            String title = Messages.getString("ReportGenerator.IOExceptionTitle");
            String message = Messages.getString("ReportGenerator.IOExceptionMessage");
            throw new ReportGenerationException(title, message, (Throwable)ioE);
        }
        catch (Exception e) {
            String title = Messages.getString("ReportGenerator.UnknownExceptionTitle");
            String message = Messages.getString("ReportGenerator.UnknownExceptionMessage");
            throw new ReportGenerationException(title, message, (Throwable)e);
        }
        return hasBeenCanceled;
    }

    public static void initialiseVelocityEngine(VelocityEngine engine) {
        for (Tuple<String, String> property : VELOCITYENGINE_PROPERTIES_TOBESET) {
            engine.setProperty((String)property.getT1(), property.getT2());
        }
        for (Tuple<String, String> property : VELOCITYENGINE_PROPERTIES_TOBEADDED) {
            engine.addProperty((String)property.getT1(), property.getT2());
        }
    }

    public static void initialiseVelocityEngine(RuntimeInstance runtimeInstance) {
        for (Tuple<String, String> property : VELOCITYENGINE_PROPERTIES_TOBESET) {
            runtimeInstance.setProperty((String)property.getT1(), property.getT2());
        }
        for (Tuple<String, String> property : VELOCITYENGINE_PROPERTIES_TOBEADDED) {
            runtimeInstance.addProperty((String)property.getT1(), property.getT2());
        }
    }
}

