/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.consoleui;

import com.arcway.cockpit.docgen.consoleui.ContinueInCaseOfErrorParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.FormatParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.HTMLOutputTemplateParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputGenerationTimeOutInSecondsParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputTemplateDescriptionParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputTemplateImageHeightInMMParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputTemplateImageWidthInMMParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputTemplateNameParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.OutputTemplateParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.ReportTemplateParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.ReportTypeParameterSpecification;
import com.arcway.cockpit.docgen.consoleui.WordOutputTemplateParameterSpecification;
import com.arcway.cockpit.docgen.core.NonUIVelocityReportProcessor;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterBinding;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.VarargsParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectOfOutputTemplateParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ReportLanguageParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerOfOutputTemplateParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.ui.IWorkbenchPage;

public class CreateReportAction
implements ICockpitConsoleAction {
    private static final ILogger LOGGER = Logger.getLogger(CreateReportAction.class);
    private static final String COMMAND_NAME = "report";
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(new ICockpitConsoleActionParameterSpecification[]{ServerParameterSpecification.getSingleton(), ProjectParameterSpecification.getSingleton(), ReportTypeParameterSpecification.getSingleton(), ReportTemplateParameterSpecification.getSingleton(), ServerOfOutputTemplateParameterSpecification.getSingleton(), ProjectOfOutputTemplateParameterSpecification.getSingleton(), OutputTemplateParameterSpecification.getSingleton(), OutputTemplateNameParameterSpecification.getSingleton(), OutputTemplateDescriptionParameterSpecification.getSingleton(), OutputTemplateImageWidthInMMParameterSpecification.getSingleton(), OutputTemplateImageHeightInMMParameterSpecification.getSingleton(), OutputGenerationTimeOutInSecondsParameterSpecification.getSingleton(), ContinueInCaseOfErrorParameterSpecification.getSingleton(), OutputParameterSpecification.getSingleton(), VarargsParameterSpecification.getSingleton(), FormatParameterSpecification.getSingleton(), HTMLOutputTemplateParameterSpecification.getSingleton(), WordOutputTemplateParameterSpecification.getSingleton()}));
    public static final String USER_MESSAGE_PREFIX = "##";

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        NonUIVelocityReportProcessor commandContext;
        String serverName = null;
        String projectName = null;
        String reportLanguage = null;
        String templateName = null;
        String reportType = null;
        String outputName = null;
        String serverNameForOutputTemplate = null;
        String projectNameForOutputTemplate = null;
        String outputTemplateFile = null;
        String name = null;
        String description = null;
        Integer imageWidthInMM = 0;
        Integer imageHeightInMM = 0;
        Integer timeOutInSeconds = 0;
        boolean continueInCaseOfError = false;
        Map<String, Object> varArgs = null;
        IDocGeneratorProjectAgent projectAgent = null;
        IDocGeneratorProjectAgent projectAgentForOutputTemplate = null;
        for (ICockpitConsoleActionParameterBinding parameter : parameters) {
            ICockpitConsoleActionParameterSpecification parameterSpecification = parameter.getSpecification();
            if (parameterSpecification == ServerParameterSpecification.getSingleton()) {
                serverName = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ServerParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == ProjectParameterSpecification.getSingleton()) {
                projectName = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ProjectParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == ReportLanguageParameterSpecification.getSingleton()) {
                reportLanguage = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ReportLanguageParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == ReportTypeParameterSpecification.getSingleton() || parameterSpecification == FormatParameterSpecification.getSingleton()) {
                String reportTypeString = (String)parameter.getValue();
                if (reportTypeString == null || (reportType = CreateReportAction.normaliseReportType(reportTypeString)) != null) continue;
                throw new ScriptExecutionException("Could not create report. (project: " + projectName + " , server: " + serverName + "). Invalid report type parameter: " + reportTypeString);
            }
            if (parameterSpecification == ReportTemplateParameterSpecification.getSingleton()) {
                templateName = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ReportTemplateParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == OutputTemplateParameterSpecification.getSingleton() || parameterSpecification == HTMLOutputTemplateParameterSpecification.getSingleton() || parameterSpecification == WordOutputTemplateParameterSpecification.getSingleton()) {
                outputTemplateFile = (String)parameter.getValue();
                continue;
            }
            if (parameterSpecification == ServerOfOutputTemplateParameterSpecification.getSingleton()) {
                serverNameForOutputTemplate = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ServerOfOutputTemplateParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == ProjectOfOutputTemplateParameterSpecification.getSingleton()) {
                projectNameForOutputTemplate = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ProjectOfOutputTemplateParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == OutputTemplateNameParameterSpecification.getSingleton()) {
                name = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputTemplateNameParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == OutputTemplateDescriptionParameterSpecification.getSingleton()) {
                description = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputTemplateDescriptionParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification == OutputTemplateImageWidthInMMParameterSpecification.getSingleton()) {
                imageWidthInMM = Integer.decode((String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputTemplateImageWidthInMMParameterSpecification.getSingleton()));
                continue;
            }
            if (parameterSpecification == OutputTemplateImageHeightInMMParameterSpecification.getSingleton()) {
                imageHeightInMM = Integer.decode((String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputTemplateImageHeightInMMParameterSpecification.getSingleton()));
                continue;
            }
            if (parameterSpecification == OutputGenerationTimeOutInSecondsParameterSpecification.getSingleton()) {
                timeOutInSeconds = Integer.decode((String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputGenerationTimeOutInSecondsParameterSpecification.getSingleton()));
                continue;
            }
            if (parameterSpecification == ContinueInCaseOfErrorParameterSpecification.getSingleton()) {
                continueInCaseOfError = Boolean.parseBoolean((String)parameter.getValue((ICockpitConsoleActionParameterSpecification)ContinueInCaseOfErrorParameterSpecification.getSingleton()));
                continue;
            }
            if (parameterSpecification == OutputParameterSpecification.getSingleton()) {
                outputName = (String)parameter.getValue((ICockpitConsoleActionParameterSpecification)OutputParameterSpecification.getSingleton());
                continue;
            }
            if (parameterSpecification != VarargsParameterSpecification.getSingleton()) continue;
            varArgs = (Map)parameter.getValue((ICockpitConsoleActionParameterSpecification)VarargsParameterSpecification.getSingleton());
        }
        if (varArgs == null) {
            varArgs = new HashMap<String, Object>();
        }
        CreateReportAction.addErrorEntriesToVarArgs(parameterLog, varArgs);
        Locale reportLocale = reportLanguage != null && reportLanguage.trim().length() > 0 ? new Locale(reportLanguage) : null;
        if (projectName != null && projectName.trim().length() > 0) {
            if (serverName == null) {
                serverName = DocGeneratorProjectAgent.getUniqueServerName();
            }
            if (serverName == null) {
                throw new ScriptExecutionException("Could not create report. (project: " + projectName + " , server: " + serverName + "). Servername is missing.");
            }
            projectAgent = DocGeneratorProjectAgent.getInstance((String)serverName, (String)projectName);
            if (projectAgent == null) {
                throw new ScriptExecutionException("Could not create report. (project: " + projectName + " , server: " + serverName + "). Can not find project with this name.");
            }
        }
        if (projectNameForOutputTemplate != null && projectNameForOutputTemplate.trim().length() > 0) {
            if (serverNameForOutputTemplate == null) {
                serverNameForOutputTemplate = serverName;
            }
            if (serverNameForOutputTemplate == null) {
                throw new ScriptExecutionException("Could not create report. (project: " + projectNameForOutputTemplate + " , server: " + serverNameForOutputTemplate + "). Servername is missing.");
            }
            projectAgentForOutputTemplate = DocGeneratorProjectAgent.getInstance((String)serverNameForOutputTemplate, (String)projectNameForOutputTemplate);
            if (projectAgentForOutputTemplate == null) {
                throw new ScriptExecutionException("Could not create report. (project: " + projectNameForOutputTemplate + " , server: " + serverNameForOutputTemplate + "). Can not find project with this name.");
            }
        }
        IWorkbenchPage workbenchPage = uiContext.getWorkbenchPage();
        String[] executionMessage = new String[1];
        Map<String, List<IFilterItemProvider>> projectUID2filterItems = uiContext.getProjectUID2filterItems();
        if (projectUID2filterItems == null) {
            projectUID2filterItems = Collections.emptyMap();
            commandContext = new NonUIVelocityReportProcessor(projectAgent, reportLocale, reportType, templateName, projectAgentForOutputTemplate, outputTemplateFile, outputName, name, description, imageWidthInMM, imageHeightInMM, varArgs, timeOutInSeconds, workbenchPage, projectUID2filterItems);
            executionMessage[0] = commandContext.execute();
        } else {
            commandContext = new NonUIVelocityReportProcessor(projectAgent, reportLocale, reportType, templateName, projectAgentForOutputTemplate, outputTemplateFile, outputName, name, description, imageWidthInMM, imageHeightInMM, varArgs, timeOutInSeconds, workbenchPage, projectUID2filterItems);
            executionMessage[0] = commandContext.execute();
        }
        if (outputName == null) {
            parameterLog.logParameters(templateName);
        } else {
            parameterLog.logParameters(new File(outputName).getName());
        }
        if (executionMessage[0] != null) {
            if (continueInCaseOfError) {
                String message = "Could not create report. (project: " + projectName + " , server: " + serverName + "). Report generation failed with message: " + executionMessage[0];
                parameterLog.logErrorMessage(message);
                String errorEntry = String.valueOf(this.getCommandName()) + ": " + outputName;
                parameterLog.getErrorEntries().add(errorEntry);
            } else {
                throw new ScriptExecutionException(USER_MESSAGE_PREFIX + executionMessage[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addErrorEntriesToVarArgs(IParameterLog parameterLog, Map<String, Object> varArgs) {
        Object errorEntryListUntyped;
        ArrayList varArgsChildren = (ArrayList)varArgs.get("children");
        if (varArgsChildren == null) {
            varArgsChildren = new ArrayList();
            varArgs.put("children", varArgsChildren);
        }
        Map<String, Object> errorEntries = null;
        for (Object e : varArgsChildren) {
            String nameString;
            Map childMap;
            Object name;
            if (!(e instanceof Map) || (name = (childMap = (Map)e).get("name")) == null || !(name instanceof String) || !(nameString = (String)name).equals("errorEntries")) continue;
            errorEntries = childMap;
        }
        if (errorEntries == null) {
            errorEntries = new HashMap<String, Object>();
            errorEntries.put("name", "errorEntries");
            errorEntries.put("attributes", new HashMap());
            errorEntries.put("children", new ArrayList());
            varArgsChildren.add(errorEntries);
        }
        if ((errorEntryListUntyped = errorEntries.get("children")) != null && errorEntryListUntyped instanceof List) {
            List errorEntryListTyped;
            List list = errorEntryListTyped = (List)errorEntryListUntyped;
        } else {
            ArrayList arrayList = new ArrayList();
            errorEntries.put("children", arrayList);
        }
        for (String errorEntry : parameterLog.getErrorEntries()) {
            void var4_8;
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("value", errorEntry);
            HashMap<String, Object> entryRecord = new HashMap<String, Object>();
            entryRecord.put("name", "entry");
            entryRecord.put("attributes", attributes);
            entryRecord.put("children", new ArrayList());
            var4_8.add(entryRecord);
        }
    }

    private static String normaliseReportType(String reportTypeParameter) {
        if (reportTypeParameter.equals("ascii")) {
            return "ASCII_DOCUMENT";
        }
        if (reportTypeParameter.equals("plain")) {
            return "PLAIN";
        }
        if (reportTypeParameter.equals("html")) {
            return "HTML_DOCUMENT";
        }
        if (reportTypeParameter.equals("word")) {
            return "WORD_DOCUMENT";
        }
        if (reportTypeParameter.equals("docbook")) {
            return "DOCBOOK_XML";
        }
        if (reportTypeParameter.equals("pdf")) {
            return "PDF_DOCUMENT";
        }
        if (reportTypeParameter.equals("odt")) {
            return "ODT_DOCUMENT";
        }
        return reportTypeParameter;
    }
}

