/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen;

import com.arcway.cockpit.docgen.ExtensionMgr;
import com.arcway.cockpit.docgen.core.StandardVelocityReportProcessor;
import com.arcway.cockpit.docgen.writer.DocumentationWriterProvider;
import com.arcway.cockpit.docgen.writer.IDocumentationWriter;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportOutputFormats;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportOutputTemplateTypes;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportTemplateTypes;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IDocGenWizardPage;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.ui.IWorkbenchPage;

public class VelocityReportGenerator
implements IFrameDocGenerator {
    private StandardVelocityReportProcessor reportJobProcessor;
    private Collection<IReportType> supportedReportTypes;

    public void init() {
        this.reportJobProcessor = new StandardVelocityReportProcessor();
        this.retrieveReportTypes();
    }

    private void retrieveReportTypes() {
        this.supportedReportTypes = new ArrayList<IReportType>();
        for (IDocumentationWriter documentationWriter : DocumentationWriterProvider.getAllSupportedDocumentationWriter()) {
            VelocityReportType reportType = new VelocityReportType(documentationWriter);
            this.supportedReportTypes.add(reportType);
        }
    }

    public Collection<IReportOutputFormat> getRelevantOutputFormats() {
        return VelocityReportOutputFormats.getOutputFormats();
    }

    public Collection<IReportTemplateType> getRelevantReportTemplateTypes() {
        return VelocityReportTemplateTypes.getReportTemplateTypes();
    }

    public Collection<IReportOutputTemplateType> getRelevantReportOutputTemplateTypes() {
        return VelocityReportOutputTemplateTypes.getReportOutputTemplateTypes();
    }

    public Collection<IReportType> getSupportedReportTypes() {
        return this.supportedReportTypes;
    }

    public Collection<? extends IReportTemplate> getBuiltInReportTemplates(Locale locale) {
        List<IReportTemplate> builtInReportTemplates = ExtensionMgr.getReportTemplates(locale);
        if (builtInReportTemplates.isEmpty()) {
            builtInReportTemplates = ExtensionMgr.getReportTemplates(Locale.getDefault());
        }
        if (builtInReportTemplates.isEmpty()) {
            builtInReportTemplates = ExtensionMgr.getReportTemplates(Locale.ENGLISH);
        }
        return builtInReportTemplates;
    }

    public Collection<? extends IReportOutputTemplate> getBuiltInOutputTemplates(String reportOutputTemplateTypeID, Locale locale) {
        List<IReportOutputTemplate> builtInOutputTemplates = ExtensionMgr.getReportOutputTemplates(reportOutputTemplateTypeID, locale);
        if (builtInOutputTemplates.isEmpty()) {
            builtInOutputTemplates = ExtensionMgr.getReportOutputTemplates(reportOutputTemplateTypeID, Locale.getDefault());
        }
        if (builtInOutputTemplates.isEmpty()) {
            builtInOutputTemplates = ExtensionMgr.getReportOutputTemplates(reportOutputTemplateTypeID, Locale.ENGLISH);
        }
        return builtInOutputTemplates;
    }

    public List<IDocGenWizardPage> getDocGenWizardPages() {
        return Collections.emptyList();
    }

    public void executeReportJob(ReportJob job, IWorkbenchPage currentPage) throws ReportGenerationException {
        this.reportJobProcessor.executeReportJob(job, currentPage);
    }
}

