/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.html;

import com.arcway.cockpit.docgen.writer.html.ModulePlugin;
import com.arcway.cockpit.docgen.writer.html.preferences.IDocBook2HTMLConfigurator;
import com.arcway.lib.eclipse.platformurl.PlatformURLHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;

public class DocBook2HTMLTransformator {
    private static final ILogger logger = Logger.getLogger(DocBook2HTMLTransformator.class);
    private final IDocBook2HTMLConfigurator configurator;

    public DocBook2HTMLTransformator(IDocBook2HTMLConfigurator configurator) {
        this.configurator = configurator;
    }

    public void convert(final File inputFile, final File reportHtmlDir) throws IOException, TransformerException {
        final IOException[] ioException = new IOException[1];
        final TransformerException[] transformerException = new TransformerException[1];
        Runnable converterRunnable = new Runnable(){

            @Override
            public void run() {
                block36: {
                    File dummyXsltOutputFile;
                    block37: {
                        File mainOutputFile = new File(reportHtmlDir, "index.html");
                        boolean chunked = DocBook2HTMLTransformator.this.configurator.isChunkingEnabled();
                        OutputStream outputStream = null;
                        dummyXsltOutputFile = null;
                        try {
                            ClassLoader transformerClassLoader;
                            ClassLoader nwalshClassLoader;
                            URL xslt;
                            TransformerFactory factory = TransformerFactory.newInstance();
                            factory.setURIResolver(new URIResolver(){

                                @Override
                                public Source resolve(String href, String base) throws TransformerException {
                                    String resolvedURIString = "";
                                    String urlString = "";
                                    try {
                                        URI baseURI = new URI(base);
                                        URI hrefURI = new URI(href);
                                        URI resolvedURI = baseURI.resolve(hrefURI);
                                        resolvedURIString = resolvedURI.toString();
                                        URL url = resolvedURI.toURL();
                                        urlString = url.toString();
                                        URL javaLibURL = FileLocator.resolve((URL)url);
                                        urlString = javaLibURL.toString();
                                        InputStream inputStream = javaLibURL.openStream();
                                        StreamSource result = new StreamSource(inputStream);
                                        result.setSystemId(resolvedURIString);
                                        return result;
                                    }
                                    catch (URISyntaxException e) {
                                        throw new TransformerException("URISyntaxException while resolving href=\"" + href + "\" against base=\"" + base + "\" for TransformerFactory", e);
                                    }
                                    catch (MalformedURLException e) {
                                        throw new TransformerException("MalformedURLException while converting the URI " + resolvedURIString + " to a URL.", e);
                                    }
                                    catch (IOException e) {
                                        throw new TransformerException("IOException while opening Stream for URL " + urlString, e);
                                    }
                                }
                            });
                            if (!chunked) {
                                xslt = PlatformURLHelper.createPlatformPluginURL((String)ModulePlugin.getDefault().getBundle().getSymbolicName(), (String)"stylesheets/html/docbook.xsl");
                                outputStream = new FileOutputStream(mainOutputFile);
                            } else {
                                xslt = PlatformURLHelper.createPlatformPluginURL((String)ModulePlugin.getDefault().getBundle().getSymbolicName(), (String)"stylesheets/html/chunk.xsl");
                                dummyXsltOutputFile = new File(reportHtmlDir, "dummyXsltOutputFile.tmp");
                                outputStream = new FileOutputStream(dummyXsltOutputFile);
                            }
                            InputStream xsltStream = xslt.openStream();
                            StreamSource xsltSource = new StreamSource(xsltStream);
                            String URIString = xslt.toURI().toString();
                            xsltSource.setSystemId(URIString);
                            Transformer transformer = factory.newTransformer(xsltSource);
                            transformer.setParameter("use.extensions", "1");
                            transformer.setParameter("tablecolumns.extensions", "1");
                            transformer.setParameter("generate.section.toc.level", "0");
                            transformer.setParameter("toc.section.depth", DocBook2HTMLTransformator.this.configurator.getSectionDepth());
                            transformer.setParameter("graphicsize.extension", "0");
                            String sectionAutolabelMaxDepth = DocBook2HTMLTransformator.this.configurator.getSectionAutolabelMaxDepth();
                            if (!"0".equals(sectionAutolabelMaxDepth)) {
                                transformer.setParameter("section.autolabel", "1");
                                transformer.setParameter("section.label.includes.component.label", "1");
                                transformer.setParameter("section.autolabel.max.depth", sectionAutolabelMaxDepth);
                            }
                            if (chunked) {
                                transformer.setParameter("base.dir", String.valueOf(reportHtmlDir.getAbsolutePath()) + File.separatorChar);
                                transformer.setParameter("root.filename", de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)"index.html"));
                                transformer.setParameter("chunk.section.depth", DocBook2HTMLTransformator.this.configurator.getChunkingSectionDepth());
                                String chunk_first_sections = DocBook2HTMLTransformator.this.configurator.isDoNotChunkFirstSection() && "1".equals(DocBook2HTMLTransformator.this.configurator.getChunkingSectionDepth()) ? "0" : "1";
                                transformer.setParameter("chunk.first.sections", chunk_first_sections);
                                transformer.setParameter("chunk.quietly", "1");
                            }
                            if ((nwalshClassLoader = Class.forName("com.nwalsh.xalan.Table").getClassLoader()) != (transformerClassLoader = transformer.getClass().getClassLoader())) {
                                if (transformerClassLoader == Integer.class.getClassLoader()) {
                                    logger.warn("Unsupported ClassLoader Arrangement (1): HTML-Report creation may fail. The failure may be observed never, intermittently or always. The probability depends on your Java VM configuration. Contact ARCWAY COCKPIT support for more information.");
                                } else {
                                    logger.warn("Unsupported ClassLoader Arrangement (2): HTML-Report creation may fail. The failure may be observed never, intermittently or always. The probability depends on your Java VM configuration. Contact ARCWAY COCKPIT support for more information.");
                                }
                            }
                            StreamSource src = new StreamSource(inputFile);
                            StreamResult res = new StreamResult(outputStream);
                            transformer.setErrorListener(new ErrorListener(){

                                @Override
                                public void warning(TransformerException exception) throws TransformerException {
                                    logger.warn((Throwable)exception);
                                }

                                @Override
                                public void fatalError(TransformerException exception) throws TransformerException {
                                    transformerException[0] = exception;
                                }

                                @Override
                                public void error(TransformerException exception) throws TransformerException {
                                    transformerException[0] = exception;
                                }
                            });
                            transformer.transform(src, res);
                            if (logger.isDebugEnabled()) {
                                logger.debug("createDocument() - Documentation file successfully transformed to HTML : docBookFile=" + inputFile + ", stylesheetURL=" + xslt.toString() + ", outputFile=" + mainOutputFile);
                            }
                        }
                        catch (TransformerException e) {
                            String msg = "TransformerException when converting docBook file into html file.";
                            logger.error(msg, (Throwable)e);
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException e2) {
                                    ioException[0] = e2;
                                }
                            }
                            if (dummyXsltOutputFile != null) {
                                try {
                                    FileHelper.deleteExistingFileOrDirectory(dummyXsltOutputFile);
                                }
                                catch (JvmExternalResourceInteractionException e2) {
                                    logger.error("Unable to delete dummyXsltOutputFile file - ignoring", (Throwable)e2);
                                }
                            }
                            break block36;
                        }
                        catch (Exception e) {
                            try {
                                logger.error("Exception when converting docBook file into html file", (Throwable)e);
                                break block36;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException e3) {
                                        ioException[0] = e3;
                                    }
                                }
                                if (dummyXsltOutputFile != null) {
                                    try {
                                        FileHelper.deleteExistingFileOrDirectory(dummyXsltOutputFile);
                                    }
                                    catch (JvmExternalResourceInteractionException e2) {
                                        logger.error("Unable to delete dummyXsltOutputFile file - ignoring", (Throwable)e2);
                                    }
                                }
                            }
                        }
                        if (outputStream == null) break block37;
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            ioException[0] = e;
                        }
                    }
                    if (dummyXsltOutputFile != null) {
                        try {
                            FileHelper.deleteExistingFileOrDirectory((File)dummyXsltOutputFile);
                        }
                        catch (JvmExternalResourceInteractionException e2) {
                            logger.error("Unable to delete dummyXsltOutputFile file - ignoring", (Throwable)e2);
                        }
                    }
                }
            }
        };
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread converterWithExtendedStack = new Thread(threadGroup, converterRunnable, "HTML Converter Thread with bigger Java Stack", 0x2000000L);
        converterWithExtendedStack.start();
        try {
            converterWithExtendedStack.join();
        }
        catch (Exception e) {
            logger.error("Exception when converting docBook file into html file", (Throwable)e);
        }
        if (ioException[0] != null) {
            throw ioException[0];
        }
        if (transformerException[0] != null) {
            throw transformerException[0];
        }
    }
}

