/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.word.docbook2word.DocumentWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.lib.eclipse.ole.word.Bookmark;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Paragraph;
import com.arcway.lib.eclipse.ole.word.Paragraphs;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.Selection;
import com.arcway.lib.eclipse.ole.word.Window;

public class WriterUtil {
    public static void jumpAtEndOfDocument(Document document) {
        Range range = document.Range();
        range.set_Start(range.get_End());
        range.Select();
        range.dispose();
    }

    public static void jumpAtBookmark(Bookmark bookmark) {
        bookmark.Select();
    }

    public static Paragraph createNewParagraph(Document document, ProcessingContext processingContext) {
        Paragraph para = DocumentWriter.isJumpToExistingAnchors(processingContext) ? WriterUtil.createNewParagraphAtCurrentPosition(document) : WriterUtil.createNewParagraphAtEndOfDocument(document);
        return para;
    }

    private static Paragraph createNewParagraphAtCurrentPosition(Document document) {
        Window activeWindow = document.get_ActiveWindow();
        Selection selection = activeWindow.get_Selection();
        Paragraphs paragraphs = selection.get_Paragraphs();
        Paragraph para = WriterUtil.addParagraph(paragraphs);
        paragraphs.dispose();
        selection.dispose();
        activeWindow.dispose();
        return para;
    }

    private static Paragraph createNewParagraphAtEndOfDocument(Document document) {
        Paragraphs paragraphs = document.get_Paragraphs();
        Paragraph para = WriterUtil.addParagraph(paragraphs);
        paragraphs.dispose();
        return para;
    }

    private static Paragraph addParagraph(Paragraphs paragraphs) {
        Paragraph para = paragraphs.Add();
        Range paraRange = para.get_Range();
        if (paraRange.get_End() - paraRange.get_Start() > 1) {
            Paragraph nextParagraph = paragraphs.Add();
            para.dispose();
            para = nextParagraph;
        }
        paraRange.dispose();
        return para;
    }
}

